/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.DiceFunitureMaker.Maker;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.AquaBlock;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.CombatBlock;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.PacketBlock;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Relative;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WorldBorder;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class FurnitureMakerArea {
    private List<PacketBlock> packetBlockList = new ArrayList<PacketBlock>();
    private Location center;
    private Location corner1;
    private Location corner2;
    private Location executeBlock;
    private BoundingBox boundingbox;
    private int size;

    public FurnitureMakerArea(Location center, int size) {
        this.center = center;
        this.size = size;
        this.corner1 = FurnitureLib.getInstance().getLocationUtil().getRelative(this.center, BlockFace.EAST, (double)(size - 1), (double)size);
        this.corner2 = FurnitureLib.getInstance().getLocationUtil().getRelative(this.center, BlockFace.EAST, (double)(-size), (double)(-size + 1));
        this.corner1.setY(FurnitureLib.getVersionInt() > 17 ? (double)center.getWorld().getMinHeight() : 1.0);
        this.corner2.setY((double)center.getWorld().getMaxHeight());
        this.boundingbox = BoundingBox.of((Location)this.corner1, (Location)this.corner2);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                Location loc = new Relative(center, (double)(-x), -1.0, (double)y, BlockFace.NORTH).getSecondLocation();
                if (FurnitureLib.isNewVersion()) {
                    this.packetBlockList.add(new AquaBlock(loc, Material.WHITE_WOOL));
                    continue;
                }
                this.packetBlockList.add(new CombatBlock(loc, Material.valueOf((String)"WOOL"), 0));
            }
        }
        this.executeBlock = this.center.getBlock().getLocation().add(0.0, 1.0, 0.0);
        if (FurnitureLib.isNewVersion()) {
            this.packetBlockList.add(new AquaBlock(new Relative(this.center, -1.0, -1.0, 0.0, BlockFace.NORTH).getSecondLocation(), Material.RED_WOOL));
            this.packetBlockList.add(new AquaBlock(new Relative(this.center, 0.0, -1.0, 0.0, BlockFace.NORTH).getSecondLocation(), Material.GREEN_WOOL));
            this.packetBlockList.add(new AquaBlock(new Relative(this.center, 0.0, -1.0, 1.0, BlockFace.NORTH).getSecondLocation(), Material.BLUE_WOOL));
        } else {
            this.packetBlockList.add(new CombatBlock(new Relative(this.center, 0.0, -1.0, 0.0, BlockFace.NORTH).getSecondLocation(), Material.valueOf((String)"WOOL"), 14));
            this.packetBlockList.add(new CombatBlock(new Relative(this.center, -1.0, -1.0, 0.0, BlockFace.NORTH).getSecondLocation(), Material.valueOf((String)"WOOL"), 13));
            this.packetBlockList.add(new CombatBlock(new Relative(this.center, 0.0, -1.0, 1.0, BlockFace.NORTH).getSecondLocation(), Material.valueOf((String)"WOOL"), 11));
        }
    }

    public void show(Player player) {
        this.packetBlockList.forEach(packet -> packet.parseBlock(player));
        this.sendWorldBorder(player);
    }

    public void reset(Player player) {
        this.packetBlockList.forEach(packet -> packet.resetBlock(player));
        this.resetWorldBorder(player);
    }

    private void sendWorldBorder(Player player) {
        PacketContainer border = FurnitureLib.getVersionInt() > 16 ? new PacketContainer(PacketType.Play.Server.INITIALIZE_BORDER) : new PacketContainer(PacketType.Play.Server.WORLD_BORDER);
        border.getWorldBorderActions().write(0, (Object)EnumWrappers.WorldBorderAction.INITIALIZE);
        border.getIntegers().write(0, (Object)29999984).write(1, (Object)0).write(2, (Object)0);
        border.getLongs().writeSafely(0, (Object)0L);
        border.getDoubles().write(0, (Object)FurnitureLib.getInstance().getLocationUtil().getCenter(this.center).getX()).write(1, (Object)FurnitureLib.getInstance().getLocationUtil().getCenter(this.center).getZ()).write(2, (Object)((double)this.size * 2.0)).writeSafely(3, (Object)((double)this.size * 2.0));
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, border);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetWorldBorder(Player player) {
        if (player.getWorld().getWorldBorder() != null) {
            PacketContainer border;
            WorldBorder wb = player.getWorld().getWorldBorder();
            if (FurnitureLib.getVersionInt() > 16) {
                border = new PacketContainer(PacketType.Play.Server.SET_BORDER_SIZE);
                border.getDoubles().write(0, (Object)wb.getSize());
            } else {
                border = new PacketContainer(PacketType.Play.Server.WORLD_BORDER);
                border.getWorldBorderActions().write(0, (Object)EnumWrappers.WorldBorderAction.INITIALIZE);
                border.getIntegers().writeSafely(0, (Object)29999984).writeSafely(1, (Object)wb.getWarningTime()).writeSafely(2, (Object)wb.getWarningDistance());
                border.getLongs().write(0, (Object)0L);
                border.getDoubles().write(0, (Object)wb.getCenter().getX()).write(1, (Object)wb.getCenter().getZ()).write(2, (Object)wb.getSize()).write(3, (Object)wb.getSize());
            }
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, border);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PacketContainer border;
            if (FurnitureLib.getVersionInt() > 16) {
                border = new PacketContainer(PacketType.Play.Server.SET_BORDER_SIZE);
                border.getDoubles().write(0, (Object)Double.MAX_VALUE);
            } else {
                border = new PacketContainer(PacketType.Play.Server.WORLD_BORDER);
                border.getWorldBorderActions().write(0, (Object)EnumWrappers.WorldBorderAction.INITIALIZE);
                border.getIntegers().write(0, (Object)29999984).write(1, (Object)0).write(2, (Object)0);
                border.getLongs().write(0, (Object)0L);
                border.getDoubles().write(0, (Object)player.getWorld().getSpawnLocation().getX()).write(1, (Object)player.getWorld().getSpawnLocation().getZ()).write(2, (Object)Double.MAX_VALUE).write(3, (Object)Double.MAX_VALUE);
            }
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, border);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isInside(Location loc) {
        return this.boundingbox.contains(loc.toVector());
    }

    public String toString() {
        return Objects.isNull(this.boundingbox) ? "FurnitureMakerArea: isNULL" : "FurnitureMakerArea: " + this.boundingbox.toString();
    }

    public Location getExecuteBlock() {
        return this.executeBlock;
    }

    public Location getCenter() {
        return this.center;
    }
}

