/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.DiceFunitureMaker.Flags;

import de.Ste3et_C0st.DiceFunitureMaker.FurnitureMakerPlugin;
import de.Ste3et_C0st.DiceFunitureMaker.Maker.FurnitureMaker;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ChatInputHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ItemStackBuilder;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.ClickGui;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.GuiButton;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.entity.fDisplay;
import de.Ste3et_C0st.FurnitureLib.main.entity.fItem_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.fText_display;
import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public class DisplaySettings
extends ClickGui {
    private int glow_override = -1;
    private int lineWidth = 200;
    private int skyLight = -1;
    private int blockLight = -1;
    private float shadowStrenght = 0.0f;
    private float shadowRadius = 1.0f;
    private Display.Billboard board = Display.Billboard.FIXED;
    private AtomicInteger slotncounter = new AtomicInteger();
    private TextDisplay.TextAlignment aligment = TextDisplay.TextAlignment.CENTER;
    private boolean seeThrough = false;
    private boolean shadowed = false;
    private boolean defaultBackground = false;
    private String name = "";
    private ItemDisplay.ItemDisplayTransform itemDisplayTransform = ItemDisplay.ItemDisplayTransform.FIXED;
    private int color = -1;

    public DisplaySettings(Player player) {
        super(54, "Change Display Settings", InventoryType.CHEST, player, (Plugin)FurnitureLib.getInstance());
        this.fillComplete();
        this.initSettings();
        this.setContent();
        this.open(player);
    }

    private void initSettings() {
        Optional<fDisplay> optDisplay = this.getMaker().getEntityList().stream().filter(Objects::nonNull).filter(entry -> entry.getClass().equals(this.getMaker().getSelectedEntityType())).map(fDisplay.class::cast).findFirst();
        if (optDisplay.isPresent()) {
            fDisplay display = optDisplay.get();
            this.glow_override = display.getGlowOverride();
            this.shadowRadius = display.getShadowRadius();
            this.shadowStrenght = display.getShadowStrength();
            this.board = display.getBillboard();
            Display.Brightness brightness = display.getBrightnessObject();
            this.skyLight = brightness.getSkyLight();
            this.blockLight = brightness.getBlockLight();
            this.name = display.getCustomName();
            if (display instanceof fText_display) {
                fText_display text = (fText_display)fText_display.class.cast(display);
                this.lineWidth = text.getLineWidth();
                this.aligment = text.getTextAligment();
                this.seeThrough = text.isSeeThrough();
                this.shadowed = text.isShadowed();
                this.defaultBackground = text.isDefaultBackground();
                this.color = text.getBackgroundColorInt();
            }
            if (display instanceof fItem_display) {
                fItem_display itemDisplay = (fItem_display)display;
                this.itemDisplayTransform = itemDisplay.getItemDisplay();
            }
        }
    }

    private void setContent() {
        this.setBillboardButton();
        this.setShadowStrenghtButton();
        this.setShadowRadiusButton();
        this.setSkyLight();
        this.setBlockLight();
        if (this.getMaker().getSelectedEntityType().equals(fText_display.class)) {
            this.setLineWidth();
            this.setTextDisplayButton();
            this.setShadowed();
            this.setSeeThrough();
            this.setDefaultBackground();
            this.setBackgroundColor();
        }
        if (this.getMaker().getSelectedEntityType().equals(fItem_display.class)) {
            this.setItemDisplay();
            this.setFunctionButton();
        }
    }

    private void setBackgroundColor() {
        net.md_5.bungee.api.ChatColor chColor = net.md_5.bungee.api.ChatColor.of((Color)new Color(this.color, true));
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.DIAMOND).setName("\u00a77BackgroundColor: " + String.valueOf(chColor) + "\u25a0").setLore(new String[]{"\u00a77ColorValue: " + String.valueOf(chColor) + this.color}), event -> {
            String hex_regex = "^#([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})$";
            new ChatInputHandler(this.getPlayer(), string -> string.matches("^#([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})$"), onFinish -> {
                if (onFinish.getState() == ChatInputHandler.ReturnState.SUCCESS) {
                    String colorStr = onFinish.getInput();
                    int r = Integer.parseInt(colorStr.substring(1, 3), 16);
                    int g = Integer.parseInt(colorStr.substring(3, 5), 16);
                    int b = Integer.parseInt(colorStr.substring(5, 7), 16);
                    int alpha = 255;
                    if (colorStr.length() > 7) {
                        alpha = Integer.parseInt(colorStr.substring(7, 9), 16);
                    }
                    Color color = new Color(r, g, b, alpha);
                    this.color = color.getRGB();
                    this.getPlayer().sendMessage("\u00a7fYou Changed the Background color to: " + String.valueOf(net.md_5.bungee.api.ChatColor.of((Color)color)) + "\u25a0");
                    this.apply();
                } else if (onFinish.getState() == ChatInputHandler.ReturnState.WRONG) {
                    this.getPlayer().sendMessage("\u00a7cYour Color code is wrong.");
                }
            }, onOpen -> {
                this.getPlayer().sendMessage("\u00a7fPlease insert \u00a7aHex ColorCode \u00a7for \u00a7aRGBA Hex");
                this.getPlayer().sendMessage("\u00a7f#\u00a7aff\u00a7dff\u00a7eff");
                this.getPlayer().sendMessage("\u00a7f#\u00a7aff\u00a7dff\u00a7eff\u00a7cff");
                this.getPlayer().sendMessage("\u00a7fYou have 20 Secounds");
                this.getPlayer().closeInventory();
            }, Duration.ofSeconds(20L));
        }));
    }

    private int processIntClick(int value, int max, int min, boolean add, boolean fast) {
        int newValue;
        int n = add ? value + (fast ? 10 : 1) : (newValue = value - (fast ? 10 : 1));
        return newValue < min ? min : (newValue > max ? max : newValue);
    }

    private float processFloatClick(float value, float max, float min, boolean add, boolean fast) {
        float newValue;
        float f = add ? value + (fast ? 1.0f : 0.5f) : (newValue = value - (fast ? 1.0f : 0.5f));
        return newValue < min ? min : (newValue > max ? max : newValue);
    }

    private void setLineWidth() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.KNOWLEDGE_BOOK).setName("\u00a77LineWidth: \u00a7a" + this.lineWidth), event -> {
            int value = this.processIntClick(this.lineWidth, 1000, 1, event.isLeftClick(), event.isShiftClick());
            if (value != this.lineWidth) {
                this.lineWidth = value;
                this.apply();
            }
        }));
    }

    private void setBlockLight() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.GLOWSTONE).setName("\u00a77BlockLight: \u00a7a" + this.blockLight), event -> {
            int value = this.processIntClick(this.blockLight, 15, 0, event.isLeftClick(), event.isShiftClick());
            if (value != this.blockLight) {
                this.blockLight = value;
                this.apply();
            }
        }));
    }

    private void setSkyLight() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.LIGHT).setName("\u00a77SkyLight: \u00a7a" + this.skyLight), event -> {
            int value = this.processIntClick(this.skyLight, 15, 0, event.isLeftClick(), event.isShiftClick());
            if (value != this.skyLight) {
                this.skyLight = value;
                this.apply();
            }
        }));
    }

    private void setFunctionButton() {
        this.addButton(this.getLastSlot(), new GuiButton(ItemStackBuilder.of((Material)Material.ACACIA_BOAT).setName("\u00a77Mount " + (this.name.startsWith("#SITZ") ? "\u00a7atrue" : "\u00a7cfalse")).setLore(new String[]{this.name}), event -> {
            this.name = this.name.equalsIgnoreCase("#SITZ") ? "" : "#SITZ#";
            this.apply();
        }));
        this.addButton(this.getLastSlot() - 1, new GuiButton(ItemStackBuilder.of((Material)Material.ITEM_FRAME).setName("\u00a77ItemHolder " + (this.name.startsWith("#ITEM") ? "\u00a7atrue" : "\u00a7cfalse")).setLore(new String[]{this.name}), event -> {
            this.name = this.name.equalsIgnoreCase("#ITEM#") ? "" : "#ITEM#";
            this.apply();
        }));
    }

    private void setItemDisplay() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.DIAMOND).setName("\u00a77ItemDisplay").setLore(this.getEnumLore((Enum[])ItemDisplay.ItemDisplayTransform.values(), (Enum)this.itemDisplayTransform)), event -> {
            this.itemDisplayTransform = event.isLeftClick() ? (this.itemDisplayTransform.ordinal() + 1 < ItemDisplay.ItemDisplayTransform.values().length ? ItemDisplay.ItemDisplayTransform.values()[this.itemDisplayTransform.ordinal() + 1] : ItemDisplay.ItemDisplayTransform.NONE) : (this.itemDisplayTransform.ordinal() > 0 ? ItemDisplay.ItemDisplayTransform.values()[this.itemDisplayTransform.ordinal() - 1] : ItemDisplay.ItemDisplayTransform.FIXED);
            this.apply();
        }));
    }

    private void setDefaultBackground() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.GLOW_ITEM_FRAME).setName("\u00a77DefaultBackground: \u00a7a" + this.defaultBackground), event -> {
            this.defaultBackground = !this.defaultBackground;
            this.apply();
        }));
    }

    private void setShadowed() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.INK_SAC).setName("\u00a77Shadowed: \u00a7a" + this.shadowed), event -> {
            this.shadowed = !this.shadowed;
            this.apply();
        }));
    }

    private void setSeeThrough() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.GLASS_BOTTLE).setName("\u00a77See Through: \u00a7a" + this.seeThrough), event -> {
            this.seeThrough = !this.seeThrough;
            this.apply();
        }));
    }

    private void setTextDisplayButton() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.ENCHANTED_BOOK).setName("\u00a77Text Aligment").setLore(this.getEnumLore((Enum[])TextDisplay.TextAlignment.values(), (Enum)this.aligment)), event -> {
            this.aligment = event.isLeftClick() ? (this.aligment.ordinal() + 1 < TextDisplay.TextAlignment.values().length ? TextDisplay.TextAlignment.values()[this.aligment.ordinal() + 1] : TextDisplay.TextAlignment.CENTER) : (this.aligment.ordinal() > 0 ? TextDisplay.TextAlignment.values()[this.aligment.ordinal() - 1] : TextDisplay.TextAlignment.RIGHT);
            this.apply();
        }));
    }

    private void setBillboardButton() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.PAINTING).setName("\u00a77Billboard").setLore(this.getBillboardLore()), event -> {
            this.board = event.isLeftClick() ? (this.board.ordinal() + 1 < Display.Billboard.values().length ? Display.Billboard.values()[this.board.ordinal() + 1] : Display.Billboard.FIXED) : (this.board.ordinal() > 0 ? Display.Billboard.values()[this.board.ordinal() - 1] : Display.Billboard.CENTER);
            this.apply();
        }));
    }

    private List<String> getEnumLore(Enum[] enumArray, Enum selected) {
        ArrayList<String> loreList = new ArrayList<String>();
        Stream.of(enumArray).forEach(entry -> loreList.add(String.valueOf(entry == selected ? ChatColor.GREEN : ChatColor.GRAY) + "- " + entry.name()));
        return loreList;
    }

    private List<String> getBillboardLore() {
        return this.getEnumLore((Enum[])Display.Billboard.values(), (Enum)this.board);
    }

    private void setShadowStrenghtButton() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.COAL).setName("\u00a77Shadow Strength: \u00a7a" + this.shadowStrenght).setLore(new String[]{""}), event -> {
            float value = this.processFloatClick(this.shadowStrenght, 64.0f, 0.0f, event.isLeftClick(), event.isShiftClick());
            if (value != this.shadowStrenght) {
                this.shadowStrenght = value;
                this.apply();
            }
        }));
    }

    private void setShadowRadiusButton() {
        this.addButton(this.slotncounter.getAndIncrement(), new GuiButton(ItemStackBuilder.of((Material)Material.BLACK_WOOL).setName("\u00a77Shadow Radius: \u00a7e" + this.shadowRadius).setLore(new String[]{""}), event -> {
            float value = this.processFloatClick(this.shadowRadius, 64.0f, 0.0f, event.isLeftClick(), event.isShiftClick());
            if (value != this.shadowRadius) {
                this.shadowRadius = value;
                this.apply();
            }
        }));
    }

    public void apply() {
        this.getMaker().getEntityList().stream().filter(Objects::nonNull).filter(entry -> entry.getClass().equals(this.getMaker().getSelectedEntityType())).map(fDisplay.class::cast).forEach(entry -> {
            entry.setBillboard(this.board);
            entry.setShadowRadius(this.fixFloat(this.shadowRadius));
            entry.setShadowStrength(this.fixFloat(this.shadowStrenght));
            entry.setBrightness(new Display.Brightness(this.blockLight, this.skyLight));
            if (entry instanceof fText_display) {
                fText_display text_display = (fText_display)fText_display.class.cast(entry);
                text_display.setLineWidth(this.lineWidth);
                text_display.setAlignment(this.aligment);
                text_display.setSeeThrough(this.seeThrough);
                text_display.setShadowed(this.shadowed);
                text_display.setDefaultBackground(this.defaultBackground);
                text_display.setBackgroundColor(this.color);
            }
            if (entry instanceof fItem_display) {
                fItem_display itemDisplay = (fItem_display)entry;
                itemDisplay.setItemDisplay(this.itemDisplayTransform);
                entry.setCustomName(this.name);
            }
            entry.update(this.getPlayer());
        });
        new DisplaySettings(this.getPlayer());
    }

    public float fixFloat(float f) {
        return (float)((double)Math.round((double)f * 100.0) / 100.0);
    }

    private FurnitureMaker getMaker() {
        return FurnitureMakerPlugin.getInstance().getManager().getMaker(this.getPlayer());
    }
}

