/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main.entity;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.collect.Lists;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.DefaultKey;
import de.Ste3et_C0st.FurnitureLib.Utilitis.EntityID;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Wrapper.WrappedPostionMoveRotation;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public abstract class fEntity
extends fSerializer
implements Cloneable {
    private final int entityID = EntityID.nextEntityId();
    private final UUID entityUUID = UUID.randomUUID();
    private final PacketContainer mountPacketContainer = new PacketContainer(PacketType.Play.Server.MOUNT);
    private final PacketContainer destroy = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
    private static final BiFunction<PacketContainer, List<WrappedWatchableObject>, Void> metadataFunction = MinecraftVersion.getCurrentVersion().isAtLeast(new MinecraftVersion("1.19.3")) ? (container, list) -> {
        ArrayList wrappedDataValueList = Lists.newArrayList();
        list.forEach(entry -> {
            WrappedDataWatcher.WrappedDataWatcherObject dataWatcherObject = entry.getWatcherObject();
            wrappedDataValueList.add(new WrappedDataValue(dataWatcherObject.getIndex(), dataWatcherObject.getSerializer(), entry.getRawValue()));
        });
        container.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
        return null;
    } : (container, list) -> {
        container.getWatchableCollectionModifier().write(0, list);
        return null;
    };
    @Deprecated
    private int entityTypeID;
    private double positionX;
    private double positionY;
    private double positionZ;
    private byte yaw;
    private byte pitch;
    private Location location;
    private DefaultKey<String> customName = new DefaultKey<String>("");
    private NBTTagCompound customNBT = new NBTTagCompound();
    protected DefaultKey<Boolean> fire = new DefaultKey<Boolean>(false);
    protected DefaultKey<Boolean> nameVisible = new DefaultKey<Boolean>(false);
    protected DefaultKey<Boolean> isPlayed = new DefaultKey<Boolean>(false);
    protected DefaultKey<Boolean> glowing = new DefaultKey<Boolean>(false);
    protected DefaultKey<Boolean> invisible = new DefaultKey<Boolean>(false);
    protected DefaultKey<Boolean> gravity = new DefaultKey<Boolean>(false);
    private List<Integer> passengerIDs = new ArrayList<Integer>();

    public fEntity(Location loc, EntityType type, int entityID, ObjectID id) {
        super(type, id);
        this.entityTypeID = entityID;
        this.getHandle().getModifier().writeDefaults();
        this.getHandle().getIntegers().write(0, (Object)this.entityID).write(1, (Object)this.entityTypeID);
        if (FurnitureLib.getVersionInt() > 18) {
            this.getHandle().getEntityTypeModifier().writeSafely(0, (Object)type);
        }
        this.getHandle().getUUIDs().write(0, (Object)this.entityUUID);
        this.mountPacketContainer.getIntegers().write(0, (Object)this.entityID);
        this.setLocation(loc);
    }

    protected abstract Material getDestroyMaterial();

    protected abstract void readAdditionalSaveData(NBTTagCompound var1);

    protected abstract void writeAdditionalSaveData();

    public boolean isParticlePlayed() {
        return this.isPlayed.getOrDefault();
    }

    public int getEntityID() {
        return this.entityID;
    }

    public boolean isFire() {
        return this.fire.getOrDefault();
    }

    @Override
    public fEntity copyEntity(Entity entity) {
        this.setGravity(entity.hasGravity());
        this.setCustomName(entity.getCustomName());
        this.setNameVasibility(entity.isCustomNameVisible());
        this.setFire(entity.isVisualFire());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.setInvisible(livingEntity.isInvisible());
        }
        return this;
    }

    public fEntity setFire(boolean fire) {
        this.setBitMask(fire, 0, 0);
        if (!fire) {
            FurnitureLib.getInstance().getLightManager().removeLight(this.getLocation());
        } else {
            FurnitureLib.getInstance().getLightManager().addLight(this.getLocation(), 15);
        }
        this.fire.setValue(fire);
        return this;
    }

    public boolean hasGravity() {
        return this.gravity.getOrDefault();
    }

    public fEntity setNameVasibility(boolean b) {
        return this.setNameVisibility(b);
    }

    public boolean isCustomNameVisible() {
        return this.nameVisible.getOrDefault();
    }

    public boolean hasCustomName() {
        if (Objects.isNull(this.getCustomName())) {
            return false;
        }
        return !this.getCustomName().isEmpty();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location loc) {
        if (Objects.nonNull(loc)) {
            this.location = loc;
            this.positionX = loc.getX();
            this.positionY = loc.getY();
            this.positionZ = loc.getZ();
            this.yaw = (byte)(loc.getYaw() * 256.0f / 360.0f);
            this.pitch = (byte)(loc.getPitch() * 256.0f / 360.0f);
            this.getHandle().getDoubles().write(0, (Object)this.positionX).write(1, (Object)this.positionY).write(2, (Object)this.positionZ);
            if (FurnitureLib.getVersionInt() > 18) {
                this.getHandle().getBytes().write(0, (Object)this.pitch).write(1, (Object)this.yaw);
            } else {
                this.getHandle().getBytes().write(0, (Object)this.yaw).write(1, (Object)this.pitch);
            }
        }
    }

    public fEntity setGravity(boolean gravity) {
        this.gravity.setValue(gravity);
        return this;
    }

    public String getCustomName() {
        return this.customName.getOrDefault();
    }

    public fEntity setCustomName(String str) {
        return this.setName(str);
    }

    public String getName() {
        return this.getCustomName();
    }

    public fEntity setName(String str) {
        if (FurnitureLib.isNewVersion()) {
            if (str == null || str.isEmpty()) {
                this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.empty());
            } else {
                String workString = LanguageConverter.serializeLegacyColors(str);
                Object textComponent = MiniMessage.miniMessage().deserialize(workString);
                WrappedChatComponent wrappedChat = WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(textComponent)));
                this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.of(wrappedChat.getHandle()));
            }
        } else {
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.get(String.class)), (Object)str);
        }
        this.customName.setValue(str);
        return this;
    }

    public List<Integer> getPassenger() {
        return this.passengerIDs;
    }

    public void setPassenger(Entity e) {
        if (!FurnitureConfig.getFurnitureConfig().canSitting()) {
            return;
        }
        this.setPassenger(Collections.singletonList(e.getEntityId()));
        boolean rotate = FurnitureConfig.getFurnitureConfig().isRotateOnSitEnable();
        if (e.getType().equals((Object)EntityType.PLAYER)) {
            PacketContainer container = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
            container.getIntegers().write(0, (Object)e.getEntityId());
            container.getBytes().write(0, (Object)((byte)(this.getLocation().getYaw() * 256.0f / 360.0f)));
            try {
                for (Player p : this.getObjID().getPlayerList()) {
                    if (rotate) {
                        this.getManager().sendServerPacket(p, container);
                    }
                    this.getManager().sendServerPacket(p, this.mountPacketContainer);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setPassenger(Integer EntityID2) {
        this.setPassenger(Arrays.asList(EntityID2));
    }

    public void setPassenger(List<Integer> entityIDs) {
        if (!FurnitureConfig.getFurnitureConfig().canSitting()) {
            return;
        }
        if (entityIDs == null) {
            return;
        }
        this.passengerIDs.addAll(entityIDs);
        int[] passengerID = this.passengerIDs.stream().mapToInt(Integer::intValue).toArray();
        this.mountPacketContainer.getIntegerArrays().write(0, (Object)passengerID);
    }

    public Server getServer() {
        return Bukkit.getServer();
    }

    public boolean isInvisible() {
        return this.invisible.getOrDefault();
    }

    public fEntity setInvisible(boolean invisible) {
        this.setBitMask(invisible, 0, 5);
        this.invisible.setValue(invisible);
        return this;
    }

    public Boolean isGlowing() {
        return this.glowing.getOrDefault();
    }

    public fEntity setGlowing(boolean glowing) {
        if (!FurnitureConfig.getFurnitureConfig().isGlowing()) {
            glowing = false;
        }
        this.setBitMask(glowing, 0, 6);
        this.glowing.setValue(glowing);
        return this;
    }

    public FurnitureLib getPlugin() {
        return FurnitureLib.getInstance();
    }

    public UUID getUUID() {
        return this.entityUUID;
    }

    @Deprecated
    public void delete() {
        FurnitureLib.getInstance().getFurnitureManager().remove(this);
    }

    public void sendParticle() {
        Material material = this.getDestroyMaterial();
        this.getObjID().getWorld().playEffect(this.getObjID().getStartLocation().clone().add(0.0, 0.3, 0.0), Effect.STEP_SOUND, (Object)material);
    }

    public fEntity setNameVisibility(boolean nameVisibility) {
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, WrappedDataWatcher.Registry.get(Boolean.class)), (Object)nameVisibility);
        this.nameVisible.setValue(nameVisibility);
        return this;
    }

    private void saveLight(Location loc1, Location loc2) {
        if (Bukkit.getPluginManager().isPluginEnabled("LightAPI")) {
            FurnitureLib.getInstance().getLightManager().removeLight(loc1);
            if (loc2 != null) {
                FurnitureLib.getInstance().getLightManager().addLight(loc2, 15);
            }
        }
    }

    public void teleport(Location loc) {
        if (this.isFire()) {
            this.saveLight(this.getLocation(), loc);
        }
        this.setLocation(loc);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.getEntityID());
        if (MinecraftVersion.getCurrentVersion().isAtLeast(new MinecraftVersion("1.21.3"))) {
            packet.getIntegers().write(0, (Object)this.getEntityID());
            packet.getStructures().withType(WrappedPostionMoveRotation.getNMS()).write(0, new WrappedPostionMoveRotation(loc).build());
        } else {
            packet.getDoubles().write(0, (Object)this.positionX).write(1, (Object)this.positionY).write(2, (Object)this.positionZ);
            packet.getBytes().write(0, (Object)this.yaw).write(1, (Object)this.pitch);
        }
        for (Player p : this.getObjID().getPlayerList()) {
            try {
                this.getManager().sendServerPacket(p, packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void rotate(float yaw, float pitch) {
        Location loc = this.getLocation();
        loc.setYaw(loc.getYaw() + yaw);
        loc.setPitch(loc.getPitch() + pitch);
        this.setLocation(loc);
        PacketContainer c = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
        c.getIntegers().write(0, (Object)this.getEntityID());
        c.getBytes().write(0, (Object)this.yaw).write(1, (Object)this.pitch);
        for (Player p : this.getObjID().getPlayerList()) {
            try {
                this.getManager().sendServerPacket(p, c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void send(Player player) {
        try {
            this.getManager().sendServerPacket(player, this.getHandle());
            this.sendMetadata(player);
            if (!this.getPassenger().isEmpty()) {
                this.getManager().sendServerPacket(player, this.mountPacketContainer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract PacketContainer additionalData();

    private void sendMetadata(Player player) {
        PacketContainer update = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        update.getIntegers().write(0, (Object)this.getEntityID());
        metadataFunction.apply(update, this.getWatcher().getWatchableObjects());
        try {
            this.getManager().sendServerPacket(player, update);
            if (this.additionalData() != null) {
                this.getManager().sendServerPacket(player, this.additionalData());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public fEntity setHealth(float health) {
        if (health == 0.0f) {
            return this;
        }
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(Type.field.getHealth(), WrappedDataWatcher.Registry.get(Float.class)), (Object)Float.valueOf(health));
        return this;
    }

    public void send(Player[] player) {
        for (Player p : player) {
            this.send(p);
        }
    }

    public void send(List<Player> player) {
        for (Player p : player) {
            this.send(p);
        }
    }

    public void update() {
        for (Player p : this.getObjID().getPlayerList()) {
            this.update(p);
        }
    }

    public void update(Player p) {
        if (!this.getObjID().getPlayerList().contains(p)) {
            return;
        }
        try {
            this.sendMetadata(p);
            if (!this.getPassenger().isEmpty()) {
                this.getManager().sendServerPacket(p, this.mountPacketContainer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void kill(Player p, boolean b) {
        this.destroy.getIntegerArrays().writeSafely(0, (Object)new int[]{this.getEntityID()});
        if (FurnitureLib.getVersionInt() > 16) {
            this.destroy.getIntegers().writeSafely(0, (Object)this.getEntityID());
            this.destroy.getIntLists().writeSafely(0, Arrays.asList(this.getEntityID()));
        }
        try {
            this.getManager().sendServerPacket(p, this.destroy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void kill() {
        this.getObjID().getPlayerListWorld().forEach(p -> this.kill((Player)p, false));
        this.eject();
    }

    public fEntity setParticleColor(int i) {
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, WrappedDataWatcher.Registry.get(Integer.class)), (Object)i);
        return this;
    }

    public void eject(Integer i) {
        if (this.passengerIDs == null || this.passengerIDs.isEmpty()) {
            return;
        }
        if (this.removePassenger(i)) {
            int[] passengerID = this.passengerIDs.stream().mapToInt(Integer::intValue).toArray();
            PacketContainer container = new PacketContainer(PacketType.Play.Server.MOUNT);
            container.getIntegers().write(0, (Object)this.getEntityID());
            container.getIntegerArrays().write(0, (Object)passengerID);
            this.getObjID().getPlayerList().forEach(player -> {
                try {
                    this.getManager().sendServerPacket(player, container);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public boolean removePassenger(Integer i) {
        if (this.passengerIDs == null || this.passengerIDs.isEmpty()) {
            return false;
        }
        return this.passengerIDs.remove(i);
    }

    public void eject() {
        if (this.passengerIDs == null || this.passengerIDs.isEmpty()) {
            return;
        }
        int[] i = new int[]{};
        PacketContainer container = new PacketContainer(PacketType.Play.Server.MOUNT);
        container.getIntegers().write(0, (Object)this.getEntityID());
        container.getIntegerArrays().write(0, (Object)i);
        this.getObjID().getPlayerList().forEach(player -> {
            try {
                this.getManager().sendServerPacket(player, container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.passengerIDs.clear();
    }

    @Deprecated
    public void sendParticle(Location loc, int particleID, boolean repeat) {
    }

    public void loadMetadata(NBTTagCompound metadata) {
        this.setCustomName(metadata.getString("CustomName", metadata.getString("Name")));
        this.setNameVisibility(metadata.getInt("CustomNameVisible", metadata.getInt("NameVisible")) == 1);
        this.setFire(metadata.getInt("Fire") == 1);
        this.setGlowing(metadata.getInt("Glowing") == 1);
        this.setInvisible(metadata.getInt("Invisible") == 1);
        metadata.getCompound("Rotation", NBTTagList.class, list -> {
            Location location = this.getLocation();
            location.setYaw(list.getFloat(0, location.getYaw()));
            location.setPitch(list.getFloat(0, location.getPitch()));
            this.setLocation(location);
        });
        metadata.getCompound("customnbt", NBTTagCompound.class, compound -> this.customNBT.cloneFrom((NBTTagCompound)compound));
        this.readAdditionalSaveData(metadata);
    }

    public NBTTagCompound getMetaData() {
        this.setMetadata("EntityType", this.getEntityType().toString());
        if (!this.customName.isDefault()) {
            this.setMetadata("CustomName", this.getName());
        }
        if (!this.nameVisible.isDefault()) {
            this.setMetadata("CustomNameVisible", this.isCustomNameVisible());
        }
        if (!this.fire.isDefault()) {
            this.setMetadata("Fire", this.isFire());
        }
        if (!this.glowing.isDefault()) {
            this.setMetadata("Glowing", this.isGlowing());
        }
        if (!this.invisible.isDefault()) {
            this.setMetadata("Invisible", this.isInvisible());
        }
        if (!this.getCustomNBT().isEmpty()) {
            this.setMetadata("customnbt", this.getCustomNBT());
        }
        this.setMetadata(this.getLocation());
        this.writeAdditionalSaveData();
        return this.getNBTField();
    }

    public boolean haveDestroyMaterial() {
        Material material = this.getDestroyMaterial();
        boolean returnValue = material != null && material != Material.AIR && material.isBlock();
        return returnValue;
    }

    public fEntity clone() {
        return this.clone(this.getLocation());
    }

    public fEntity clone(Location location) {
        NBTTagCompound originalNBTagCompound = this.getMetaData();
        fEntity clone = FurnitureManager.getInstance().spawnEntity(this.getEntityType(), location, this.getObjID());
        clone.loadMetadata(originalNBTagCompound);
        return clone;
    }

    public void copyMetadata(fEntity toCopy) {
        if (toCopy != null && toCopy.getEntityType() == this.getEntityType()) {
            toCopy.loadMetadata(this.getMetaData());
        }
    }

    public NBTTagCompound getCustomNBT() {
        return this.customNBT;
    }
}

