/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main.entity;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.Utilitis.DefaultKey;
import de.Ste3et_C0st.FurnitureLib.Utilitis.EntitySize;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.SizeableEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fSize;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class fDisplay
extends fSize
implements SizeableEntity {
    private DefaultKey<Vector3f> translation = new DefaultKey<Vector3f>(new Vector3f());
    private DefaultKey<Vector3f> scale = new DefaultKey<Vector3f>(new Vector3f());
    private DefaultKey<Quaternionf> leftRotation = new DefaultKey<Quaternionf>(new Quaternionf());
    private DefaultKey<Quaternionf> rightRotation = new DefaultKey<Quaternionf>(new Quaternionf());
    private DefaultKey<Display.Billboard> billboard = new DefaultKey<Display.Billboard>(Display.Billboard.FIXED);
    private DefaultKey<Float> viewRange = new DefaultKey<Float>(Float.valueOf(1.0f));
    private DefaultKey<Float> shadowRadius = new DefaultKey<Float>(Float.valueOf(0.0f));
    private DefaultKey<Float> shadowStrength = new DefaultKey<Float>(Float.valueOf(1.0f));
    private DefaultKey<Integer> interpolationDelay = new DefaultKey<Integer>(0);
    private DefaultKey<Integer> interpolationDuration = new DefaultKey<Integer>(0);
    private DefaultKey<Integer> brightness = new DefaultKey<Integer>(-1);
    private DefaultKey<Integer> glow_override = new DefaultKey<Integer>(-1);
    public static final Type.ProtocolFieldsDisplay displayField = FurnitureLib.getVersion(new MinecraftVersion("1.20.2")) ? Type.ProtocolFieldsDisplay.Spigot120_2 : Type.ProtocolFieldsDisplay.Spgiot120;

    public fDisplay(Location loc, EntityType type, int entityID, ObjectID id) {
        super(loc, type, entityID, id, 0.0f, 0.0f);
        this.writeTransformation();
    }

    @Override
    public fDisplay copyEntity(Entity entity) {
        super.copyEntity(entity);
        if (entity instanceof Display) {
            Display display = (Display)Display.class.cast(entity);
            this.setBillboard(display.getBillboard());
            this.setViewRange(display.getViewRange());
            this.setShadowRadius(display.getShadowRadius());
            this.setShadowStrength(display.getShadowStrength());
            this.setBrightness(display.getBrightness());
            this.setGlowOverride(display.getGlowColorOverride().asRGB());
            this.setTransformation(display.getTransformation());
            this.setInterpolationDelay(display.getInterpolationDelay());
            this.setInterpolationDuration(display.getInterpolationDuration());
            this.setWidth((float)display.getWidth());
            this.setHeight((float)display.getHeight());
        }
        return this;
    }

    public fDisplay setBlockLight(int lightLevel) {
        Display.Brightness brightness = new Display.Brightness(lightLevel, this.getSkyLight());
        this.setBrightness(brightness);
        return this;
    }

    public fDisplay setSkyLight(int skyLight) {
        Display.Brightness brightness = new Display.Brightness(this.getBlockLight(), skyLight);
        this.setBrightness(brightness);
        return this;
    }

    public fDisplay setBrightness(Display.Brightness brightness) {
        if (brightness.getBlockLight() == 0 && brightness.getSkyLight() == 0) {
            return this.setBrightness(-1);
        }
        return this.setBrightness(brightness.getBlockLight() << 4 | brightness.getSkyLight() << 20);
    }

    public Display.Brightness getBrightnessObject() {
        int var1 = this.brightness.getOrDefault() >> 4 & 0xFFFF;
        int var2 = this.brightness.getOrDefault() >> 20 & 0xFFFF;
        return new Display.Brightness(0 <= var1 && var1 <= 15 ? var1 : 0, 0 <= var2 && var2 <= 15 ? var2 : 0);
    }

    public int getSkyLight() {
        return this.getBrightnessObject().getSkyLight();
    }

    public int getBlockLight() {
        return this.getBrightnessObject().getBlockLight();
    }

    public void setScale(Vector3f vector) {
        this.scale.setValue(vector);
        this.writeTransformation();
    }

    public void setTranslation(Vector3f vector) {
        this.translation.setValue(vector);
        this.writeTransformation();
    }

    public void setLeftRotation(AxisAngle4f rotAngle4f) {
        this.setLeftRotation(new Quaternionf(rotAngle4f));
    }

    public void setLeftRotation(Quaternionf quaternionf) {
        this.leftRotation.setValue(quaternionf);
        this.writeTransformation();
    }

    public void setRightRotation(AxisAngle4f rotAngle4f) {
        this.setRightRotation(new Quaternionf(rotAngle4f));
    }

    public void setRightRotation(Quaternionf quaternionf) {
        this.rightRotation.setValue(quaternionf);
        this.writeTransformation();
    }

    public int getInterpolationDelay() {
        return this.interpolationDelay.getOrDefault();
    }

    public Quaternionf getLeftRotationObj() {
        return this.leftRotation.getOrDefault();
    }

    public Quaternionf getRightRotationObj() {
        return this.rightRotation.getOrDefault();
    }

    public Vector3f getScale() {
        return this.scale.getOrDefault();
    }

    public Vector3f getTranslation() {
        return this.translation.getOrDefault();
    }

    public Quaternionf getLeftRotation() {
        return this.getTransformation().getLeftRotation();
    }

    public Quaternionf getRightRotation() {
        return this.getTransformation().getRightRotation();
    }

    public Transformation getTransformation() {
        return new Transformation(this.translation.getOrDefault(), this.leftRotation.getOrDefault(), this.scale.getOrDefault(), this.rightRotation.getOrDefault());
    }

    public int getInterpolationDuration() {
        return this.interpolationDuration.getOrDefault();
    }

    public Display.Billboard getBillboard() {
        return this.billboard.getOrDefault();
    }

    public int getBrightness() {
        return this.brightness.getOrDefault();
    }

    public float getViewRange() {
        return this.viewRange.getOrDefault().floatValue();
    }

    public float getShadowRadius() {
        return this.shadowRadius.getOrDefault().floatValue();
    }

    public float getShadowStrength() {
        return this.shadowStrength.getOrDefault().floatValue();
    }

    public int getGlowOverride() {
        return this.glow_override.getOrDefault();
    }

    public fDisplay setBillboard(int billboard) {
        Display.Billboard billEnum = Display.Billboard.values()[billboard];
        return this.setBillboard(billEnum);
    }

    public fDisplay setInterpolationDelay(int var0) {
        this.interpolationDelay.setValue(var0);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, WrappedDataWatcher.Registry.get(Integer.class)), (Object)this.getInterpolationDelay());
        return this;
    }

    public fDisplay setInterpolationDuration(int var0) {
        this.interpolationDuration.setValue(var0);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(8, WrappedDataWatcher.Registry.get(Integer.class)), (Object)this.getInterpolationDuration());
        return this;
    }

    private void writeTransformation() {
        Transformation transformation = this.getTransformation();
        ((EntitySize)this.entitySize.getOrDefault()).write(transformation.getScale());
        if (FurnitureLib.isVersionOrAbove("1.21.11")) {
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 10, WrappedDataWatcher.Registry.get(Vector3fc.class)), (Object)transformation.getTranslation());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 11, WrappedDataWatcher.Registry.get(Vector3fc.class)), (Object)transformation.getScale());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 12, WrappedDataWatcher.Registry.get(Quaternionfc.class)), (Object)transformation.getLeftRotation());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 13, WrappedDataWatcher.Registry.get(Quaternionfc.class)), (Object)transformation.getRightRotation());
        } else {
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 10, WrappedDataWatcher.Registry.get(Vector3f.class)), (Object)transformation.getTranslation());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 11, WrappedDataWatcher.Registry.get(Vector3f.class)), (Object)transformation.getScale());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 12, WrappedDataWatcher.Registry.get(Quaternionf.class)), (Object)transformation.getLeftRotation());
            this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 13, WrappedDataWatcher.Registry.get(Quaternionf.class)), (Object)transformation.getRightRotation());
        }
    }

    public fDisplay setTransformation(Transformation transformation) {
        this.translation.setValue(transformation.getTranslation());
        this.scale.setValue(transformation.getScale());
        this.leftRotation.setValue(transformation.getLeftRotation());
        this.rightRotation.setValue(transformation.getRightRotation());
        this.writeTransformation();
        return this;
    }

    public fDisplay setBillboard(Display.Billboard billboard) {
        this.billboard.setValue(billboard);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 14, WrappedDataWatcher.Registry.get(Byte.class)), (Object)((byte)this.getBillboard().ordinal()));
        return this;
    }

    public fDisplay setBrightness(int i) {
        this.brightness.setValue(i);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 15, WrappedDataWatcher.Registry.get(Integer.class)), (Object)this.getBrightness());
        return this;
    }

    public fDisplay setViewRange(float f) {
        this.viewRange.setValue(Float.valueOf(f));
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 16, WrappedDataWatcher.Registry.get(Float.class)), (Object)Float.valueOf(this.getViewRange()));
        return this;
    }

    public fDisplay setShadowRadius(float f) {
        this.shadowRadius.setValue(Float.valueOf(f));
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 17, WrappedDataWatcher.Registry.get(Float.class)), (Object)Float.valueOf(this.getShadowRadius()));
        return this;
    }

    public fDisplay setShadowStrength(float f) {
        this.shadowStrength.setValue(Float.valueOf(f));
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 18, WrappedDataWatcher.Registry.get(Float.class)), (Object)Float.valueOf(this.getShadowStrength()));
        return this;
    }

    public fDisplay setGlowOverride(int i) {
        this.glow_override.setValue(i);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(displayField.getVersionIndex() + 21, WrappedDataWatcher.Registry.get(Integer.class)), (Object)this.getGlowOverride());
        return this;
    }

    protected void writeDisplaySaveData() {
        super.writeSizeData();
        if (!this.viewRange.isDefault()) {
            this.setMetadata("view_range", Float.valueOf(this.getViewRange()));
        }
        if (!this.shadowRadius.isDefault()) {
            this.setMetadata("shadow_radius", Float.valueOf(this.getShadowRadius()));
        }
        if (!this.shadowStrength.isDefault()) {
            this.setMetadata("shadow_strength", Float.valueOf(this.getShadowStrength()));
        }
        if (!this.glow_override.isDefault()) {
            this.setMetadata("glow_color_override", this.getGlowOverride());
        }
        if (!this.interpolationDelay.isDefault()) {
            this.setMetadata("teleport_duration", this.getInterpolationDelay());
        }
        if (!this.interpolationDuration.isDefault()) {
            this.setMetadata("interpolation_duration", this.getInterpolationDuration());
        }
        if (!this.brightness.isDefault()) {
            this.setMetadata("brightness", this.getBrightness());
        }
        if (!this.billboard.isDefault()) {
            this.setMetadata("billboard", this.getBillboard().name());
        }
        NBTTagCompound transformation = new NBTTagCompound();
        if (!this.translation.isDefault()) {
            this.writeVector(this.translation.getOrDefault(), transformation, "translation");
        }
        if (!this.scale.isDefault()) {
            this.writeVector(this.scale.getOrDefault(), transformation, "scale");
        }
        if (!this.leftRotation.isDefault()) {
            this.writeRotation(this.getLeftRotationObj(), transformation, "left_Rotation");
        }
        if (!this.rightRotation.isDefault()) {
            this.writeRotation(this.getRightRotationObj(), transformation, "right_Rotation");
        }
        if (!transformation.isEmpty()) {
            this.set("transformation", transformation);
        }
    }

    private void writeVector(Vector3f vector, NBTTagCompound transformation, String name) {
        NBTTagCompound rotation = new NBTTagCompound();
        rotation.setFloat("x", vector.x);
        rotation.setFloat("y", vector.y);
        rotation.setFloat("z", vector.z);
        transformation.set(name, rotation);
    }

    private void writeRotation(Quaternionf quaternionf, NBTTagCompound transformation, String name) {
        NBTTagCompound rotation = new NBTTagCompound();
        AxisAngle4f axis = new AxisAngle4f((Quaternionfc)quaternionf);
        rotation.setFloat("angle", axis.angle);
        rotation.setFloat("x", axis.x);
        rotation.setFloat("y", axis.y);
        rotation.setFloat("z", axis.z);
        transformation.set(name, rotation);
    }

    protected void readDisplayData(NBTTagCompound metadata) {
        super.readSizeData(metadata);
        this.setBillboard(Stream.of(Display.Billboard.values()).filter(entry -> entry.name().equalsIgnoreCase(metadata.getString("billboard"))).findFirst().orElse(Display.Billboard.FIXED));
        this.setBrightness(metadata.getInt("brightness", -1));
        this.setGlowOverride(metadata.getInt("glow_color_override", metadata.getInt("glow_override", 0)));
        this.setViewRange(metadata.getFloat("view_range", metadata.getFloat("viewRange", 1.0f)));
        this.setInterpolationDuration(metadata.getInt("interpolation_duration", metadata.getInt("interpolationDuration", 0)));
        this.setInterpolationDelay(metadata.getInt("teleport_duration", metadata.getInt("interpolationDelay", 0)));
        this.setShadowRadius(metadata.getFloat("shadow_radius", metadata.getFloat("shadowRadius")));
        this.setShadowStrength(metadata.getFloat("shadow_strength", metadata.getFloat("shadowStrength")));
        if (metadata.hasKeyOfType("transformation", 10)) {
            Vector3f vector3f;
            NBTTagCompound transformation = metadata.getCompound("transformation");
            if (transformation.hasKeyOfType("translation", 10)) {
                NBTTagCompound translation = transformation.getCompound("translation");
                vector3f = new Vector3f(translation.getFloat("x"), translation.getFloat("y"), translation.getFloat("z"));
                this.translation.setValue(vector3f);
            }
            if (transformation.hasKeyOfType("scale", 10)) {
                NBTTagCompound scale = transformation.getCompound("scale");
                vector3f = new Vector3f(scale.getFloat("x"), scale.getFloat("y"), scale.getFloat("z"));
                this.scale.setValue(vector3f);
            }
            if (transformation.hasKeyOfType("leftRotation", 10)) {
                this.leftRotation.setValue(new Quaternionf(this.readRotation(transformation, "leftRotation")));
            } else if (transformation.hasKeyOfType("left_Rotation", 10)) {
                this.leftRotation.setValue(new Quaternionf(this.readRotation(transformation, "left_Rotation")));
            }
            if (transformation.hasKeyOfType("rightRotation", 10)) {
                this.rightRotation.setValue(new Quaternionf(this.readRotation(transformation, "rightRotation")));
            } else if (transformation.hasKeyOfType("right_Rotation", 10)) {
                this.rightRotation.setValue(new Quaternionf(this.readRotation(transformation, "right_Rotation")));
            }
            this.writeTransformation();
        }
    }

    private AxisAngle4f readRotation(NBTTagCompound transformation, String key) {
        return this.readRotation(transformation, key, new AxisAngle4f());
    }

    private AxisAngle4f readRotation(NBTTagCompound transformation, String key, AxisAngle4f defaultValue) {
        if (transformation.hasKeyOfType(key, 10)) {
            NBTTagCompound serializedAngle = transformation.getCompound(key);
            AxisAngle4f axisAngle4f = new AxisAngle4f(serializedAngle.getFloat("angle"), serializedAngle.getFloat("x"), serializedAngle.getFloat("y"), serializedAngle.getFloat("z"));
            return axisAngle4f;
        }
        return defaultValue;
    }

    @Override
    protected Material getDestroyMaterial() {
        return Material.AIR;
    }

    @Override
    protected int widthField() {
        return displayField.getVersionIndex() + 19;
    }

    @Override
    protected int heightField() {
        return displayField.getVersionIndex() + 20;
    }

    @Override
    public BoundingBox getBoundingBox() {
        Vector3f scale = this.getScale();
        return BoundingBox.of(new Vector(0, 0, 0), new Vector(scale.x, scale.y, scale.z));
    }

    @Override
    protected PacketContainer additionalData() {
        return null;
    }
}

