/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main.entity;

import com.comphenix.protocol.events.PacketContainer;
import de.Ste3et_C0st.FurnitureLib.NBT.CraftItemStack;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SkullMetaPatcher;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fInventory;
import java.util.List;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public abstract class fContainerEntity
extends fEntity {
    private fInventory entityInventory = new fInventory(this.getEntityID());

    public fContainerEntity(Location loc, EntityType type, int entityID, ObjectID id) {
        super(loc, type, entityID, id);
    }

    public void setEntityEquipment(EntityEquipment equipment) {
        this.setHelmet(equipment.getHelmet());
        this.setChestPlate(equipment.getChestplate());
        this.setLeggings(equipment.getLeggings());
        this.setBoots(equipment.getBoots());
        this.setItemInMainHand(equipment.getItemInMainHand());
        this.setItemInOffHand(equipment.getItemInOffHand());
    }

    public fInventory getEquipment() {
        return this.entityInventory;
    }

    public fInventory getInventory() {
        return this.entityInventory;
    }

    public fContainerEntity setInventory(fInventory inv) {
        this.entityInventory = inv;
        return this;
    }

    public ItemStack getBoots() {
        return this.getInventory().getBoots();
    }

    public fEntity setBoots(ItemStack is) {
        this.getInventory().setBoots(is);
        return this;
    }

    public ItemStack getHelmet() {
        return this.getInventory().getHelmet();
    }

    public fEntity setHelmet(ItemStack is) {
        this.getInventory().setHelmet(is);
        return this;
    }

    public ItemStack getChestPlate() {
        return this.getInventory().getChestPlate();
    }

    public fEntity setChestPlate(ItemStack is) {
        this.getInventory().setChestPlate(is);
        return this;
    }

    public ItemStack getLeggings() {
        return this.getInventory().getLeggings();
    }

    public fEntity setLeggings(ItemStack is) {
        this.getInventory().setLeggings(is);
        return this;
    }

    public ItemStack getItemInMainHand() {
        return this.getInventory().getItemInMainHand();
    }

    public fEntity setItemInMainHand(ItemStack is) {
        this.getInventory().setItemInMainHand(is);
        return this;
    }

    public ItemStack getItemInOffHand() {
        return this.getInventory().getItemInOffHand();
    }

    public fEntity setItemInOffHand(ItemStack is) {
        this.getInventory().setItemInOffHand(is);
        return this;
    }

    public void sendInventoryPacket(Player player) {
        List<PacketContainer> packets = this.entityInventory.createPackets();
        if (packets.isEmpty()) {
            return;
        }
        try {
            for (PacketContainer packet : packets) {
                if (player == null || packet == null || this.getManager() == null) {
                    return;
                }
                this.getManager().sendServerPacket(player, packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readInventorySaveData(NBTTagCompound metadata) {
        CraftItemStack craftItemStack = new CraftItemStack();
        metadata.getCompound("Inventory", NBTTagCompound.class, inventory -> inventory.c().stream().forEach(entry -> {
            NBTTagCompound compound;
            ItemStack is;
            String name = (String)entry;
            if (inventory.hasKey(name) && !inventory.getString(name).equalsIgnoreCase("NONE") && Objects.nonNull(is = craftItemStack.getItemStack(compound = inventory.getCompound(name)))) {
                if (is.getType().name().equalsIgnoreCase("PLAYER_HEAD") && SkullMetaPatcher.shouldPatch()) {
                    is = SkullMetaPatcher.patch(is, compound);
                }
                this.getInventory().setSlot(name, is);
            }
        }));
        metadata.getCompound("HandItems", NBTTagList.class, handItems -> {
            this.setItemInMainHand(craftItemStack.getItemStack(handItems.get(0)));
            this.setItemInOffHand(craftItemStack.getItemStack(handItems.get(1)));
        });
        metadata.getCompound("ArmorItems", NBTTagList.class, armorItems -> {
            this.setHelmet(craftItemStack.getItemStack(armorItems.get(3)));
            this.setChestPlate(craftItemStack.getItemStack(armorItems.get(2)));
            this.setLeggings(craftItemStack.getItemStack(armorItems.get(1)));
            this.setBoots(craftItemStack.getItemStack(armorItems.get(0)));
        });
    }

    protected void writeInventoryData() {
        if (!this.getInventory().isEmpty()) {
            this.setMetadata(this.getInventory());
        }
    }

    @Override
    public void send(Player player) {
        super.send(player);
        this.sendInventoryPacket(player);
    }

    @Override
    public void update(Player player) {
        super.update(player);
        this.sendInventoryPacket(player);
    }

    public boolean containMaterial(Material material) {
        if (Objects.isNull(material) || material.isAir()) {
            return false;
        }
        for (ItemStack stack : this.getInventory().getContents()) {
            if (!Objects.nonNull(stack) || stack.getType() != material) continue;
            return true;
        }
        return false;
    }
}

