/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main.entity;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.Utilitis.DefaultKey;
import de.Ste3et_C0st.FurnitureLib.Utilitis.EntitySize;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.Interactable;
import de.Ste3et_C0st.FurnitureLib.main.entity.SizeableEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fContainerEntity;
import de.Ste3et_C0st.FurnitureLib.main.interfaces.ScaleableEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.EulerAngle;

public class fArmorStand
extends fContainerEntity
implements SizeableEntity,
ScaleableEntity,
Interactable {
    public static EntityType type = EntityType.ARMOR_STAND;
    private int armorstandID;
    private final DefaultKey<Boolean> arms = new DefaultKey<Boolean>(false);
    private final DefaultKey<Boolean> small = new DefaultKey<Boolean>(false);
    private final DefaultKey<Boolean> marker = new DefaultKey<Boolean>(true);
    private final DefaultKey<Boolean> basePlate = new DefaultKey<Boolean>(true);
    private final PacketContainer attribute = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
    private final HashMap<Type.BodyPart, DefaultKey<EulerAngle>> angle = new HashMap();
    private final DefaultKey<EntitySize> entitySize = new DefaultKey<EntitySize>(new EntitySize(0.5, 1.975));
    private final WrappedAttribute.Builder scaleAttribute = FurnitureLib.isVersionOrAbove("1.20.5") ? (FurnitureLib.isVersionOrAbove("1.21.3") ? WrappedAttribute.newBuilder().attributeKey("scale").baseValue(1.0) : WrappedAttribute.newBuilder().attributeKey("generic.scale").baseValue(1.0)) : null;
    private final DefaultKey<Double> scaleValue = new DefaultKey<Double>(0.0);

    public fArmorStand(Location loc, ObjectID obj) {
        super(loc, type, FurnitureLib.isNewVersion() ? (short)1 : type.getTypeId(), obj);
        this.attribute.getIntegers().write(0, (Object)this.getEntityID());
        this.angle.put(Type.BodyPart.BODY, new DefaultKey<EulerAngle>(Type.BodyPart.BODY.getDefAngle()));
        this.angle.put(Type.BodyPart.HEAD, new DefaultKey<EulerAngle>(Type.BodyPart.HEAD.getDefAngle()));
        this.angle.put(Type.BodyPart.LEFT_ARM, new DefaultKey<EulerAngle>(Type.BodyPart.LEFT_ARM.getDefAngle()));
        this.angle.put(Type.BodyPart.RIGHT_ARM, new DefaultKey<EulerAngle>(Type.BodyPart.RIGHT_ARM.getDefAngle()));
        this.angle.put(Type.BodyPart.LEFT_LEG, new DefaultKey<EulerAngle>(Type.BodyPart.LEFT_LEG.getDefAngle()));
        this.angle.put(Type.BodyPart.RIGHT_LEG, new DefaultKey<EulerAngle>(Type.BodyPart.RIGHT_LEG.getDefAngle()));
    }

    public EulerAngle getBodyPose() {
        return this.getPose(Type.BodyPart.BODY);
    }

    public fArmorStand setBodyPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.BODY);
        return this;
    }

    public EulerAngle getLeftArmPose() {
        return this.getPose(Type.BodyPart.LEFT_ARM);
    }

    public fArmorStand setLeftArmPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.LEFT_ARM);
        return this;
    }

    public EulerAngle getRightArmPose() {
        return this.getPose(Type.BodyPart.RIGHT_ARM);
    }

    public fArmorStand setRightArmPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.RIGHT_ARM);
        return this;
    }

    public EulerAngle getLeftLegPose() {
        return this.getPose(Type.BodyPart.LEFT_LEG);
    }

    public fArmorStand setLeftLegPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.LEFT_LEG);
        return this;
    }

    public EulerAngle getRightLegPose() {
        return this.getPose(Type.BodyPart.RIGHT_LEG);
    }

    public fArmorStand setRightLegPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.RIGHT_LEG);
        return this;
    }

    public EulerAngle getHeadPose() {
        return this.getPose(Type.BodyPart.HEAD);
    }

    public fArmorStand setHeadPose(EulerAngle a) {
        this.setPose(a, Type.BodyPart.HEAD);
        return this;
    }

    public int getArmorID() {
        return this.armorstandID;
    }

    public boolean hasArms() {
        return this.arms.getOrDefault();
    }

    public boolean hasBasePlate() {
        return this.basePlate.getOrDefault();
    }

    public boolean isMarker() {
        return this.marker.getOrDefault();
    }

    public fArmorStand setMarker(boolean marker) {
        this.setBitMask(!marker, Type.field.getBitMask(), 4);
        this.marker.setValue(marker);
        return this;
    }

    public boolean isSmall() {
        return this.small.getOrDefault();
    }

    public fArmorStand setSmall(boolean small) {
        this.setBitMask(small, Type.field.getBitMask(), 0);
        this.small.setValue(small);
        if (small) {
            this.entitySize.setValue(new EntitySize(0.25, 0.9875));
        } else {
            this.entitySize.setValue(this.entitySize.getDefault());
        }
        return this;
    }

    public fArmorStand copyEntity(LivingEntity entity) {
        if (entity instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)ArmorStand.class.cast(entity);
            this.setSmall(stand.isSmall());
            this.setBasePlate(stand.hasBasePlate());
            this.setMarker(stand.isMarker());
            this.setArms(stand.hasArms());
            this.setHeadPose(stand.getHeadPose());
            this.setBodyPose(stand.getBodyPose());
            this.setLeftArmPose(stand.getLeftArmPose());
            this.setRightArmPose(stand.getRightArmPose());
            this.setLeftLegPose(stand.getLeftLegPose());
            this.setRightLegPose(stand.getRightLegPose());
            this.setEntityEquipment(stand.getEquipment());
        }
        return this;
    }

    public EulerAngle getPose(Type.BodyPart part) {
        if (!this.angle.containsKey((Object)part)) {
            return part.getDefAngle();
        }
        return this.angle.get((Object)part).getOrDefault();
    }

    public fArmorStand setPose(EulerAngle angle, Type.BodyPart part) {
        if (angle == null) {
            return this;
        }
        if (part == null) {
            return this;
        }
        DefaultKey<EulerAngle> defaultAngle = this.angle.get((Object)part);
        defaultAngle.setValue(angle);
        angle = FurnitureLib.getInstance().getLocationUtil().Radtodegress(angle);
        this.getWatcher().setObject(new WrappedDataWatcher.WrappedDataWatcherObject(part.getField(), WrappedDataWatcher.Registry.getVectorSerializer()), (Object)new Vector3F((float)angle.getX(), (float)angle.getY(), (float)angle.getZ()));
        return this;
    }

    public fArmorStand setArms(boolean arms) {
        this.setBitMask(arms, Type.field.getBitMask(), 2);
        this.arms.setValue(arms);
        return this;
    }

    public fArmorStand setBasePlate(boolean basePlate) {
        this.setBitMask(!basePlate, Type.field.getBitMask(), 3);
        this.basePlate.setValue(basePlate);
        return this;
    }

    @Override
    protected void writeAdditionalSaveData() {
        super.writeInventoryData();
        if (!this.scaleValue.isDefault()) {
            this.setMetadata("scaleAttribute", this.getScale());
        }
        if (!this.arms.isDefault()) {
            this.setMetadata("ShowArms", this.hasArms());
        }
        if (!this.basePlate.isDefault()) {
            this.setMetadata("NoBasePlate", this.hasBasePlate());
        }
        if (!this.gravity.isDefault()) {
            this.setMetadata("Gravity", this.hasGravity());
        }
        if (this.marker.isDefault()) {
            this.setMetadata("Marker", this.marker.getOrDefault());
        }
        if (!this.small.isDefault()) {
            this.setMetadata("Small", this.isSmall());
        }
        NBTTagCompound eulerAngle = new NBTTagCompound();
        this.angle.entrySet().stream().filter(entry -> !((DefaultKey)entry.getValue()).isDefault()).forEach(entry -> {
            EulerAngle angle = (EulerAngle)((DefaultKey)entry.getValue()).getValue();
            NBTTagCompound partAngle = new NBTTagCompound();
            partAngle.setDouble("X", angle.getX());
            partAngle.setDouble("Y", angle.getY());
            partAngle.setDouble("Z", angle.getZ());
            eulerAngle.set(((Type.BodyPart)((Object)((Object)entry.getKey()))).getMojangName(), partAngle);
        });
        if (!eulerAngle.isEmpty()) {
            this.set("Pose", eulerAngle);
        }
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound metadata) {
        super.readInventorySaveData(metadata);
        this.setScale(metadata.getDouble("scaleAttribute", 0.0));
        if (metadata.hasKeyOfType("EulerAngle", 10)) {
            NBTTagCompound euler = metadata.getCompound("EulerAngle");
            euler.c().stream().forEach(entry -> {
                String name = (String)entry;
                Type.BodyPart part = Type.BodyPart.valueOf(name.toUpperCase());
                this.setPose(this.eulerAngleFetcher(euler.getCompound(name)), part);
            });
        } else if (metadata.hasKeyOfType("Pose", 10)) {
            NBTTagCompound euler = metadata.getCompound("Pose");
            euler.c().stream().forEach(entry -> Type.BodyPart.match((String)entry).ifPresent(bodyPart -> {
                String key = (String)entry;
                euler.getCompound(key, NBTTagCompound.class, compound -> this.setPose(this.eulerAngleFetcher(euler.getCompound((String)entry)), (Type.BodyPart)((Object)((Object)bodyPart))));
                euler.getCompound(key, NBTTagList.class, tagList -> {
                    EulerAngle defEngle = bodyPart.getDefAngle();
                    double[] eulerAngles = new double[]{defEngle.getX(), defEngle.getY(), defEngle.getZ()};
                    for (int i = 0; i < 3 && i < tagList.size(); ++i) {
                        eulerAngles[i] = tagList.getFloat(i);
                    }
                    this.setPose(this.eulerAngleFetcher(eulerAngles), (Type.BodyPart)((Object)((Object)bodyPart)));
                });
            }));
        }
        this.setBasePlate(metadata.getInt("NoBasePlate", metadata.getInt("BasePlate")) == 1).setSmall(metadata.getInt("Small") == 1).setMarker(metadata.getInt("Marker") == 1).setArms(metadata.getInt("ShowArms", metadata.getInt("Arms")) == 1).setGravity(metadata.getInt("Gravity") == 1);
    }

    private EulerAngle eulerAngleFetcher(double[] eulerAngle) {
        EulerAngle eulerAngleReturn = FurnitureLib.getInstance().getLocationUtil().degresstoRad(new EulerAngle(eulerAngle[0], eulerAngle[1], eulerAngle[2]));
        return eulerAngleReturn;
    }

    private EulerAngle eulerAngleFetcher(NBTTagCompound eularAngle) {
        double X = eularAngle.getDouble("X");
        double Y = eularAngle.getDouble("Y");
        double Z = eularAngle.getDouble("Z");
        return new EulerAngle(X, Y, Z);
    }

    @Override
    public EntitySize getEntitySize() {
        return this.entitySize.getOrDefault();
    }

    @Override
    protected Material getDestroyMaterial() {
        if (Objects.nonNull(this.getHelmet())) {
            if (this.getHelmet().getType().isBlock()) {
                return this.getHelmet().getType();
            }
        } else if (Objects.nonNull(this.getItemInMainHand()) && this.getItemInMainHand().getType().isBlock()) {
            return this.getItemInMainHand().getType();
        }
        return Material.AIR;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.entitySize.getOrDefault().toBoundingBox();
    }

    @Override
    public boolean canInteractWith() {
        return this.isMarker();
    }

    private void sendMetadata(Player player) {
    }

    @Override
    public fArmorStand setScale(double scale) {
        this.scaleValue.setValue(scale);
        if (scale != 0.0) {
            this.scaleAttribute.baseValue(scale);
        }
        return this;
    }

    public boolean canWriteScale() {
        return this.scaleAttribute != null;
    }

    @Override
    public double getScale() {
        return this.canWriteScale() ? this.scaleAttribute.build().getFinalValue() : 0.0;
    }

    @Override
    protected PacketContainer additionalData() {
        if (this.scaleAttribute == null) {
            return null;
        }
        this.attribute.getAttributeCollectionModifier().write(0, Arrays.asList(this.scaleAttribute.build()));
        return this.attribute;
    }
}

