/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.entity.Player;

public class Updater {
    String currentVersion;
    String newVersion;
    Long updateTime;
    UpdatePriority priority1 = UpdatePriority.NO_UPDATE;
    CurrentPriority priority2 = CurrentPriority.NORMAL;

    public Updater() {
        this.updateTime = this.getTime();
        this.currentVersion = FurnitureLib.getInstance().getDescription().getVersion();
        this.newVersion = this.getLatestVersionOnSpigot();
    }

    public void update() {
        if (this.updateTime - System.currentTimeMillis() <= 0L) {
            this.updateTime = this.getTime();
            this.newVersion = this.getLatestVersionOnSpigot();
        }
    }

    public void sendPlayer(Player p) {
        if (this.isUpdateAvailable()) {
            p.sendMessage("\u00a77[\u00a76FurnitureLib\u00a77] \u00a76Update \u00a7e" + this.newVersion + " \u00a76is available");
            p.sendMessage("\u00a77[\u00a76FurnitureLib\u00a77] \u00a76Look at: \u00a7ehttp://goo.gl/L7w1QQ");
        }
    }

    private boolean isUpdateAvailable() {
        if (FurnitureConfig.getFurnitureConfig().isUpdate()) {
            return !this.currentVersion.equalsIgnoreCase(this.newVersion);
        }
        return false;
    }

    public String getLatestString() {
        String s = "";
        if (this.isUpdateAvailable()) {
            return this.newVersion;
        }
        return s;
    }

    public String getUpdate() {
        Object s = "";
        if (this.isUpdateAvailable()) {
            s = "\n\u00a7c\u00a7lUpdate Available \u00a72\u00a7lv" + this.newVersion;
        }
        return s;
    }

    public long getTime() {
        return System.currentTimeMillis() + 600000L;
    }

    private String getLatestVersionOnSpigot() {
        if (FurnitureConfig.getFurnitureConfig().isUpdate()) {
            try {
                String inputLine;
                URL website = new URL("https://api.spiget.org/v2/resources/9368/versions/latest");
                URLConnection connection = website.openConnection();
                connection.addRequestProperty("User-Agent", "FurnitureLib");
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JsonParser parser = new JsonParser();
                JsonObject o = parser.parse(response.toString()).getAsJsonObject();
                return o.get("name").getAsString();
            }
            catch (Exception ex) {
                System.err.println("Failed to check for an update on Spigot for FurnitureLib.");
                return null;
            }
        }
        return FurnitureLib.getInstance().getDescription().getVersion();
    }

    private static enum UpdatePriority {
        HIGH,
        NORMAL,
        NO_UPDATE;

    }

    private static enum CurrentPriority {
        NORMAL,
        SNAPSHOT;

    }
}

