/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main.Protection;

import com.google.gson.JsonObject;
import de.Ste3et_C0st.FurnitureLib.Events.FurnitureRegionClear;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlockAquaticUpdate;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.ProtectionLib.main.ProtectionLib;
import de.Ste3et_C0st.ProtectionLib.main.protectionObj;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtectionManager {
    public ProtectionManager(Plugin plugin) {
        if (Bukkit.getPluginManager().isPluginEnabled("ProtectionLib")) {
            new FurnitureRegionClear();
        }
    }

    public boolean isSolid(Material mat, Type.PlaceableSide side, Block block) {
        if (!this.checkPlaceable(mat, side, block)) {
            return false;
        }
        return mat.isSolid();
    }

    private boolean checkPlaceable(Material mat, Type.PlaceableSide side, Block block) {
        return mat.isBlock() && mat.isSolid() && (mat.isOccluding() || this.blockStateParser(block));
    }

    private boolean blockStateParser(Block block) {
        return !FurnitureLib.isNewVersion() || ModelBlockAquaticUpdate.isSolid(block);
    }

    public int getSize() {
        if (!this.isEnabled()) {
            return 0;
        }
        return ProtectionLib.getInstance().getWatchers().size();
    }

    public boolean isEnabled() {
        boolean enabled = Bukkit.getPluginManager().isPluginEnabled("ProtectionLib");
        FurnitureLib.debug("FurnitureLib -> ProtectionLib is hooked (" + enabled + ").");
        return enabled;
    }

    public boolean useProtectionLib() {
        return this.isEnabled();
    }

    public boolean canBuild(Player p, Location loc) {
        if (!this.isEnabled()) {
            return true;
        }
        return ProtectionLib.getInstance().canBuild(loc, p);
    }

    public Boolean isOwner(Player p, Location loc) {
        if (!this.isEnabled()) {
            return true;
        }
        return ProtectionLib.getInstance().isOwner(loc, p);
    }

    public List<JsonObject> getProtectionClazz() {
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<JsonObject> json = new ArrayList<JsonObject>();
        for (protectionObj protection : ProtectionLib.getInstance().getWatchers()) {
            JsonObject object = new JsonObject();
            object.addProperty("plugin", protection.getPlugin().getDescription().getName());
            object.addProperty("clazz", protection.getClass().getSimpleName());
            json.add(object);
        }
        return json;
    }

    public boolean canBuild(Player p, ObjectID id, Type.EventType type) {
        return this.canBuild(p, id, type, true);
    }

    public boolean canBuild(Player p, ObjectID id, Type.EventType type, boolean sendMessage) {
        if (p.isOp() || FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)p, "furniture.bypass.protection") || FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)p, "furniture.admin")) {
            FurnitureLib.debug("FurnitureLib -> canBuild check (bypassed).");
            return true;
        }
        Type.PublicMode publicMode = id.getPublicMode();
        UUID userID = p.getUniqueId();
        UUID ownerID = id.getUUID();
        Type.EventType eventType = id.getEventType();
        if (ownerID == null) {
            FurnitureLib.debug("FurnitureLib -> canBuild check (ownerID is null).");
            return true;
        }
        if (!this.isProtectedRegion(id)) {
            FurnitureLib.debug("FurnitureLib -> canBuild check (is not inside Protected Region).");
            if (id.getUUID().equals(userID)) {
                FurnitureLib.debug("FurnitureLib -> canBuild furnitureowner try to destroy");
                return true;
            }
            FurnitureLib.debug("FurnitureLib -> canBuild interactType: " + type.name());
            FurnitureLib.debug("FurnitureLib -> canBuild eventType: " + eventType.name());
            if (Type.EventType.INTERACT == type ? Type.EventType.INTERACT == eventType || Type.EventType.BREAK_INTERACT == eventType : Type.EventType.BREAK == type && id.getMemberList().contains(userID) && (Type.EventType.BREAK == id.getEventType() || Type.EventType.BREAK_INTERACT == id.getEventType())) {
                return true;
            }
            if (sendMessage) {
                FurnitureLib.debug("FurnitureLib -> canBuild check (Player has no Permission).");
                LanguageManager.getInstance().sendMessage((CommandSender)p, "message.NoPermissions", new StringTranslator[0]);
            }
            return false;
        }
        boolean b = this.canBuild(p, id);
        if (b) {
            return true;
        }
        if (publicMode.equals((Object)Type.PublicMode.PRIVATE)) {
            b = ownerID.equals(userID);
        } else if (publicMode.equals((Object)Type.PublicMode.MEMBERS)) {
            if (id.getMemberList().isEmpty()) {
                b = false;
            }
            if (id.getMemberList().contains(userID)) {
                b = this.isEventType(id, type);
            }
        } else if (publicMode.equals((Object)Type.PublicMode.PUBLIC)) {
            b = this.isEventType(id, type);
        }
        if (!b && sendMessage) {
            LanguageManager.getInstance().sendMessage((CommandSender)p, "message.NoPermissions", new StringTranslator[0]);
        }
        return b;
    }

    private boolean canBuild(Player p, ObjectID id) {
        if (p.getUniqueId().equals(id.getUUID())) {
            FurnitureLib.debug("FurnitureLib -> canBuild furnitureowner try to destroy");
            return true;
        }
        if (!this.isEnabled()) {
            FurnitureLib.debug("FurnitureLib -> ProtectionLib isn't enabled");
            return true;
        }
        if (this.getSize() == 0) {
            FurnitureLib.debug("FurnitureLib -> ProtectionLib didn't hook inside a watcher");
            return true;
        }
        boolean memberOfRegion = this.canBuild(p, id.getStartLocation());
        boolean ownerOfRegion = this.isOwner(p, id.getStartLocation());
        boolean isOwnerOfModel = p.getUniqueId().equals(id.getUUID());
        FurnitureLib.debug("FurnitureLib -> ProtectionLib memberOfRegion " + memberOfRegion);
        FurnitureLib.debug("FurnitureLib -> ProtectionLib ownerOfRegion " + ownerOfRegion);
        if (memberOfRegion && !ownerOfRegion) {
            return isOwnerOfModel;
        }
        if (ownerOfRegion && !isOwnerOfModel && FurnitureConfig.getFurnitureConfig().haveRegionMemberAccess()) {
            return true;
        }
        return isOwnerOfModel;
    }

    private boolean isProtectedRegion(ObjectID objectID) {
        if (!this.isEnabled()) {
            return false;
        }
        return ProtectionLib.getInstance().isProtectedRegion(objectID.getStartLocation());
    }

    private boolean isEventType(ObjectID objID, Type.EventType type) {
        boolean eventType = objID.getEventType().equals((Object)type) || objID.getEventType().equals((Object)Type.EventType.BREAK_INTERACT);
        FurnitureLib.debug("FurnitureLib -> isEventType Eventtype equals tpye or is BREAK_INTERACT" + eventType);
        return eventType;
    }
}

