/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.RandomStringGenerator;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Wrapper.packet.WrapperPlayServerEntityDestroy;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.main.Furniture;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.FurniturePlayer;
import de.Ste3et_C0st.FurnitureLib.main.ObjectData;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class ObjectID
extends ObjectData {
    public ObjectID(String name, String plugin, Location startLocation) {
        try {
            this.Project = name;
            this.plugin = plugin;
            this.serial = RandomStringGenerator.generateRandomString(10, RandomStringGenerator.Mode.ALPHANUMERIC);
            this.ObjectID = name + ":" + this.serial + ":" + plugin;
            if (Objects.nonNull(startLocation)) {
                this.setStartLocation(startLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectID(String name) {
        this.setID(name);
    }

    public HashSet<Player> getPlayerList() {
        HashSet<Player> playerSet = new HashSet<Player>();
        Bukkit.getOnlinePlayers().stream().filter(entry -> this.isInWorld((Player)entry)).filter(entry -> this.isInRange((Player)entry)).forEach(playerSet::add);
        return playerSet;
    }

    public HashSet<Player> getPlayerListWorld() {
        HashSet<Player> playerSet = new HashSet<Player>();
        Bukkit.getOnlinePlayers().stream().filter(entry -> this.isInWorld((Player)entry)).forEach(playerSet::add);
        return playerSet;
    }

    public boolean isMember(UUID uuid) {
        return this.uuidList.contains(uuid);
    }

    public boolean isFromDatabase() {
        return this.fromDatabase;
    }

    public void setFromDatabase(boolean b) {
        this.fromDatabase = b;
    }

    public boolean isPrivate() {
        return this.Private;
    }

    public void setPrivate(boolean b) {
        this.Private = b;
    }

    public void addMember(UUID uuid) {
        this.uuidList.add(uuid);
    }

    public void remMember(UUID uuid) {
        this.uuidList.remove(uuid);
    }

    public HashSet<fEntity> getPacketList() {
        return this.packetList;
    }

    public void setPacketList(HashSet<fEntity> packetList) {
        this.packetList = packetList;
    }

    public boolean containsEntity(int entityID) {
        return Objects.nonNull(this.getEntity(entityID));
    }

    public fEntity getEntity(int entityID) {
        return this.packetList.stream().filter(entry -> entry.getEntityID() == entityID).findFirst().orElse(null);
    }

    public boolean isInRange(Player player) {
        return this.isInRange(player.getLocation());
    }

    public boolean isInRange(Location location) {
        return this.distanceSquared(location) <= viewRange;
    }

    private int distanceSquared(Location location) {
        int x = location.getBlockX() >> 4;
        int z = location.getBlockZ() >> 4;
        return this.distanceSquared(x, z);
    }

    private int distanceSquared(int chunkX, int chunkZ) {
        return de.Ste3et_C0st.FurnitureLib.main.ObjectID.square(this.chunkX - chunkX) + de.Ste3et_C0st.FurnitureLib.main.ObjectID.square(this.chunkZ - chunkZ);
    }

    private static int square(int num) {
        return num * num;
    }

    public boolean canSee(Player player) {
        return this.isInWorld(player) ? this.isInRange(player) : false;
    }

    public boolean isInWorld(Player player) {
        if (Objects.isNull(this.getWorld())) {
            return false;
        }
        if (Objects.isNull(player.getWorld())) {
            return false;
        }
        return this.getWorldName().equalsIgnoreCase(player.getWorld().getName());
    }

    public void addEntity(fEntity packet) {
        this.packetList.add(packet);
    }

    public void addEntities(Collection<? extends fEntity> collection) {
        this.packetList.addAll(collection);
    }

    public void addArmorStand(fEntity packet) {
        this.packetList.add(packet);
    }

    public void updatePlayerView(FurniturePlayer player) {
        if (FurnitureManager.getInstance().getIgnoreList().contains(player.getUniqueId())) {
            return;
        }
        if (this.isPrivate()) {
            return;
        }
        if (this.getPacketList().isEmpty()) {
            return;
        }
        if (this.getSQLAction() == Type.SQLAction.REMOVE) {
            return;
        }
        if (!this.isInWorld(player.getPlayer())) {
            return;
        }
        this.sendArmorStands(player);
    }

    public void updatePlayerViewWithRange(FurniturePlayer player, Location location) {
        if (FurnitureManager.getInstance().getIgnoreList().contains(player.getUniqueId())) {
            return;
        }
        if (this.isPrivate()) {
            return;
        }
        if (this.getPacketList().isEmpty()) {
            return;
        }
        if (this.getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
            return;
        }
        if (!this.isInWorld(player.getPlayer())) {
            player.removeRender(this);
            return;
        }
        if (this.isInRange(location)) {
            if (player.containsObjectID(this)) {
                return;
            }
            if (!this.getFurnitureObjectOpt().isPresent()) {
                FurnitureLib.debug(this.getID() + " have no function object", 100);
                FurnitureLib.debug("Project: " + this.getProject(), 100);
            }
            this.getFurnitureObjectOpt().ifPresent(entry -> {
                this.sendArmorStands(player);
                entry.receive(player.getPlayer());
            });
        } else {
            if (!player.containsObjectID(this)) {
                return;
            }
            this.removeArmorStands(player);
        }
    }

    public void sendArmorStands(FurniturePlayer player) {
        this.packetList.forEach(stand -> stand.send(player.getPlayer()));
        player.addToRender(this);
    }

    public void removeArmorStands(FurniturePlayer player) {
        WrapperPlayServerEntityDestroy.destroyPackets(this, player.getPlayer());
        player.removeRender(this);
    }

    public fEntity getByID(int entityID) {
        return this.getPacketList().stream().filter(entry -> entityID == entry.getEntityID()).findFirst().orElse(null);
    }

    @Deprecated
    public void sendAllInView() {
    }

    public void removePacket(Player player) {
        if (this.isPrivate()) {
            return;
        }
        if (this.getPacketList().isEmpty()) {
            return;
        }
        if (this.getSQLAction() == Type.SQLAction.REMOVE) {
            return;
        }
        FurnitureManager.getInstance().killObject(this, player);
    }

    public void addBlock(List<Block> locationList) {
        if (locationList == null || locationList.isEmpty()) {
            return;
        }
        this.addBlockLocations(locationList.stream().map(Block::getLocation).collect(Collectors.toList()));
    }

    public void addBlockLocations(List<Location> bl) {
        if (bl.isEmpty()) {
            return;
        }
        this.locList.addAll(bl);
        FurnitureLib.getInstance().getBlockManager().getList().addAll(bl);
    }

    public void addBlock(Location loc) {
        FurnitureLib.getInstance().getBlockManager().addBlock(loc);
        this.locList.add(loc);
    }

    public void loadBlocks() {
        if (this.getBlockList().isEmpty()) {
            if (Objects.isNull(this.getProjectOBJ())) {
                return;
            }
            ModelHandler modelschematic = this.getProjectOBJ().getModelschematic();
            if (Objects.nonNull(modelschematic)) {
                BlockFace direction = LocationUtil.yawToFace(this.getStartLocation().getYaw()).getOppositeFace();
                this.addBlockLocations(modelschematic.addBlocks(this.getStartLocation(), direction));
            }
        }
    }

    public void registerBlocks() {
        if (this.getBlockList().isEmpty()) {
            if (Objects.isNull(this.getProjectOBJ())) {
                return;
            }
            ModelHandler modelschematic = this.getProjectOBJ().getModelschematic();
            if (Objects.nonNull(modelschematic)) {
                BlockFace direction = LocationUtil.yawToFace(this.getStartLocation().getYaw()).getOppositeFace();
                List<Location> locList = modelschematic.getBlockLocations(this.getStartLocation(), direction);
                this.addBlockLocations(locList);
            }
        }
        FurnitureLib.getInstance().getBlockManager().getList().addAll(this.locList);
    }

    public void remove(Player p) {
        this.remove(p, true, true);
    }

    public void remove() {
        this.remove(null, false, false);
    }

    public void remove(boolean effect) {
        this.remove(null, false, effect);
    }

    public void remove(Player p, boolean dropItem, boolean deleteEffect) {
        this.packetList.stream().filter(fEntity::isFire).forEach(entity -> entity.setFire(false));
        if (p != null && dropItem) {
            this.dropItem(p, this.loc.clone().add(0.0, 1.0, 0.0), this.getProjectOBJ());
        }
        if (deleteEffect) {
            this.deleteEffect(this.packetList);
        }
        FurnitureManager.getInstance().remove(this);
        this.removeAll();
        this.setFurnitureObject(null);
    }

    public void dropItem(Player p, Location loc, Project project) {
        if (FurnitureConfig.getFurnitureConfig().useGamemode() && p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        World w = loc.getWorld();
        w.dropItemNaturally(loc, project.getCraftingFile().getRecipe().getResult());
    }

    public void deleteEffect(HashSet<fEntity> asList) {
        if (this.getProjectOBJ().isSilent()) {
            return;
        }
        asList.stream().filter(entity -> entity.haveDestroyMaterial()).limit(6L).forEach(fEntity::sendParticle);
    }

    public String getPlayerName() {
        Optional<DiceOfflinePlayer> player;
        String name = "\u00a7cUNKNOWN";
        if (this.uuid != null && (player = FurnitureLib.getInstance().getPlayerCache().getPlayer(this.getUUID())).isPresent()) {
            name = player.get().getName();
        }
        return name;
    }

    public HashSet<Location> getBlockList() {
        return this.locList;
    }

    public boolean containsBlock(Location location) {
        return Objects.nonNull(this.getPresetLocation(location));
    }

    public Location getPresetLocation(Location location) {
        Predicate<Location> predicate = entry -> entry.getWorld().getName().equals(location.getWorld().getName()) && location.getBlockX() == entry.getBlockX() && location.getBlockY() == entry.getBlockY() && location.getBlockZ() == entry.getBlockZ();
        return this.locList.stream().filter(predicate).findFirst().orElse(null);
    }

    public void send(Player p) {
        this.updatePlayerView(FurniturePlayer.wrap(p));
    }

    public void send(FurniturePlayer p) {
        this.updatePlayerView(p);
    }

    public void send(Collection<Player> player) {
        player.stream().forEach(this::send);
    }

    public void sendAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.send(p);
        }
    }

    public void update() {
        if (this.isPrivate()) {
            return;
        }
        if (this.getPacketList().isEmpty()) {
            return;
        }
        if (this.getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
            return;
        }
        HashSet<Player> actuallyPlayers = this.getPlayerList();
        HashSet<Player> removePlayers = new HashSet<Player>(FurniturePlayer.getFurniturePlayerColection().stream().filter(entry -> !actuallyPlayers.contains(entry.getPlayer())).map(FurniturePlayer::getPlayer).collect(Collectors.toSet()));
        for (Player player2 : actuallyPlayers) {
            this.getPacketList().forEach(entity -> entity.update(player2));
        }
        WrapperPlayServerEntityDestroy.destroyPackets(this, removePlayers);
        actuallyPlayers.stream().map(FurniturePlayer::wrap).forEach(player -> player.addToRender(this));
        actuallyPlayers.stream().map(FurniturePlayer::wrap).forEach(player -> player.removeRender(this));
    }

    public void removeAll() {
        if (this.isPrivate()) {
            return;
        }
        if (this.getPacketList().isEmpty()) {
            return;
        }
        if (this.getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
            return;
        }
        FurnitureManager.getInstance().killObject(this);
    }

    public void sendLocation() {
        this.packetList.stream().forEach(entry -> entry.teleport(entry.getLocation()));
    }

    public String toString() {
        return this.getID();
    }

    @Deprecated
    public void setFunctionObject(Object obj) {
        if (Furniture.class.isInstance(obj)) {
            this.functionObject = (Furniture)Furniture.class.cast(obj);
        }
    }
}

