/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class FurniturePlugin {
    private Plugin pluginInstance;

    public FurniturePlugin(Plugin pluginInstance) {
        this.pluginInstance = pluginInstance;
    }

    public abstract void registerProjects();

    public abstract void applyPluginFunctions();

    public abstract void onFurnitureLateSpawn(ObjectID var1);

    public Plugin getPlugin() {
        return this.pluginInstance;
    }

    public InputStream getResource(String filename) throws NullPointerException {
        return Objects.nonNull(this.getPlugin()) ? this.getPlugin().getResource(filename) : null;
    }

    private BufferedReader readResource(String str) {
        if (!((String)str).startsWith("/")) {
            str = "/" + (String)str;
        }
        InputStream stream = this.getPlugin().getClass().getResourceAsStream((String)str);
        try {
            return new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public YamlConfiguration saveResource(String sourceName, String fileName) {
        File folder = new File("plugins/FurnitureLib/plugin");
        File file = new File(folder, (String)(fileName.endsWith(".yml") ? fileName : fileName + ".yml"));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            YamlConfiguration conf = file.exists() ? YamlConfiguration.loadConfiguration((File)file) : new YamlConfiguration();
            BufferedReader reader = this.readResource(sourceName);
            if (Objects.nonNull(reader)) {
                conf.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)reader));
            }
            conf.options().copyDefaults(true);
            conf.save(file);
            return conf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void register() {
        if (!FurnitureLib.getFurniturePlugins().contains(this)) {
            FurnitureLib.registerPlugin(this);
        }
    }
}

