/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import de.Ste3et_C0st.FurnitureLib.Utilitis.FloodgateManager;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class FurniturePlayer {
    private final Player player;
    private final UUID uuid;
    private HashSet<ObjectID> receivedObjects = new HashSet();
    private static final HashMap<UUID, FurniturePlayer> playerSet = new HashMap();
    private static Function<Player, FurniturePlayer> createNew = player -> {
        FurniturePlayer newPlayer = new FurniturePlayer((Player)player);
        playerSet.put(player.getUniqueId(), newPlayer);
        return newPlayer;
    };

    protected FurniturePlayer(Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
    }

    public Player getPlayer() {
        return this.player;
    }

    public CompletableFuture<Void> updatePlayerView(Location location) {
        String worldName = location.getWorld().getName();
        return this.makeFuture(() -> {
            HashSet receivedObjects = new HashSet();
            HashSet destroyedObjects = new HashSet();
            receivedObjects.stream().filter(entry -> !entry.isInRange(location)).forEach(entry -> destroyedObjects.add(entry));
            FurnitureManager.getInstance().getObjectStreamFromWorld(worldName).filter(entry -> entry.isInRange(location)).forEach(entry -> {
                if (!this.receivedObjects.contains(entry)) {
                    entry.sendArmorStands(this);
                    receivedObjects.add(entry);
                }
            });
            this.receivedObjects.removeAll(destroyedObjects);
            this.receivedObjects.addAll(receivedObjects);
        });
    }

    protected boolean addToRender(ObjectID objectID) {
        return this.receivedObjects.add(objectID);
    }

    protected boolean removeRender(ObjectID objectID) {
        return this.receivedObjects.remove(objectID);
    }

    public boolean isInWorld(World world) {
        return this.player.getWorld().equals((Object)world);
    }

    private CompletableFuture<Void> makeFuture(Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        });
    }

    public static HashMap<UUID, FurniturePlayer> getFurniturePlayersMap() {
        return playerSet;
    }

    public static Collection<FurniturePlayer> getFurniturePlayerColection() {
        return playerSet.values();
    }

    public static FurniturePlayer wrap(Player player) {
        return playerSet.containsKey(player.getUniqueId()) ? playerSet.get(player.getUniqueId()) : createNew.apply(player);
    }

    public boolean containsObjectID(ObjectID objectID) {
        return this.receivedObjects.contains(objectID);
    }

    public HashSet<ObjectID> getReceivedObjects() {
        return new HashSet<ObjectID>(this.receivedObjects);
    }

    public void clear() {
        this.receivedObjects.clear();
    }

    public boolean isBedrockPlayer() {
        FloodgateManager manager = FurnitureLib.getInstance().getFloodgateManager();
        if (Objects.nonNull(manager)) {
            manager.isBedrockPlayer(this.uuid);
        }
        return false;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }
}

