/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Wrapper.packet.WrapperPlayServerEntityDestroy;
import de.Ste3et_C0st.FurnitureLib.async.WorldData;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.ObjectIdManager;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fArmorStand;
import de.Ste3et_C0st.FurnitureLib.main.entity.fBlock_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.fCreeper;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fGiant;
import de.Ste3et_C0st.FurnitureLib.main.entity.fInteraction;
import de.Ste3et_C0st.FurnitureLib.main.entity.fItem_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.fPig;
import de.Ste3et_C0st.FurnitureLib.main.entity.fText_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.monster.fMagmaCube;
import de.Ste3et_C0st.FurnitureLib.main.entity.monster.fShulker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class FurnitureManager
extends ObjectIdManager {
    private static HashMap<EntityType, BiFunction<Location, ObjectID, fEntity>> packetClasses = new HashMap();
    private static FurnitureManager manager;
    public WrappedDataWatcher watcher = null;
    public HashMap<World, HashMap<EntityType, WrappedDataWatcher>> defaultWatchers = new HashMap();
    private HashMap<String, Project> projects = new HashMap();
    private static final List<UUID> ignoreList;
    private HashSet<WorldData> asyncWorldFiles = new HashSet();

    public FurnitureManager() {
        manager = this;
    }

    public static List<fArmorStand> cloneList(List<fArmorStand> list) {
        return new ArrayList<fArmorStand>(list);
    }

    public static FurnitureManager getInstance() {
        return manager;
    }

    public List<UUID> getIgnoreList() {
        return ignoreList;
    }

    public HashMap<String, Project> getProjectMap() {
        return this.projects;
    }

    public void addProject(Project project) {
        this.projects.put(project.getName().toLowerCase(), project);
    }

    public List<Project> getProjects() {
        return new ArrayList<Project>(this.projects.values());
    }

    public ObjectID getObjBySerial(String serial) {
        return this.getObjectList().stream().filter(obj -> obj.getSerial().equalsIgnoreCase(serial)).findFirst().filter(obj -> !obj.getSQLAction().equals((Object)Type.SQLAction.REMOVE)).orElse(null);
    }

    public void saveAsynchron(CommandSender sender) {
        SchedularHelper.runAsync(() -> {
            long count = this.getAllObjectIDs().filter(entry -> entry.getSQLAction().isImportant()).count();
            if (count > 0L) {
                long currentTime = System.currentTimeMillis();
                boolean force = Player.class.isInstance(sender);
                FurnitureConfig.getFurnitureConfig().sendDatabaseLog(sender, "\u00a7n\u00a77--------------------------------------", force);
                FurnitureConfig.getFurnitureConfig().sendDatabaseLog(sender, "\u00a77Furniture async saving started", force);
                FurnitureLib.getInstance().getSQLManager().save();
                long newTime = System.currentTimeMillis();
                long time = newTime - currentTime;
                SimpleDateFormat timeDate = new SimpleDateFormat("mm:ss.SSS");
                String timeStr = timeDate.format(time);
                FurnitureConfig.getFurnitureConfig().sendDatabaseLog(sender, "\u00a77Furniture saving finish : \u00a79" + timeStr, force);
                FurnitureConfig.getFurnitureConfig().sendDatabaseLog(sender, "\u00a7n\u00a77--------------------------------------", force);
            }
        });
    }

    public WrappedDataWatcher getDefaultWatcher(World w, EntityType type) {
        if (this.defaultWatchers.containsKey(w) && this.defaultWatchers.get(w).containsKey(type)) {
            return this.defaultWatchers.get(w).get(type).deepClone();
        }
        WrappedDataWatcher watcher = this.createNew(w, type);
        if (watcher == null) {
            return null;
        }
        HashMap<Object, Object> watcherMap = null;
        if (this.defaultWatchers.containsKey(w)) {
            watcherMap = this.defaultWatchers.get(w);
        }
        if (watcherMap == null) {
            watcherMap = new HashMap();
        }
        watcherMap.put(type, watcher);
        this.defaultWatchers.put(w, watcherMap);
        return watcher;
    }

    private WrappedDataWatcher createNew(World w, EntityType type) {
        Entity entity = w.spawnEntity(new Location(w, 0.0, 256.0, 0.0), type);
        WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)entity).deepClone();
        entity.remove();
        return watcher;
    }

    public boolean isArmorStand(Integer entityID) {
        return this.getfArmorStandByID(entityID) != null;
    }

    public fArmorStand createArmorStand(ObjectID id, Location loc) {
        return (fArmorStand)this.spawnEntity("armor_stand", loc, id);
    }

    public fPig createPig(ObjectID id, Location loc) {
        return (fPig)this.spawnEntity("pig", loc, id);
    }

    public fGiant createGiant(ObjectID id, Location loc) {
        return (fGiant)this.spawnEntity("giant", loc, id);
    }

    public fCreeper createCreeper(ObjectID id, Location loc) {
        return (fCreeper)this.spawnEntity("creeper", loc, id);
    }

    public fEntity spawnEntity(ObjectID id, Location location, EntityType type) {
        return this.spawnEntity(type.name().toLowerCase(), location, id);
    }

    public void addArmorStand(Object obj) {
        if (!(obj instanceof fArmorStand)) {
            return;
        }
        fArmorStand stand = (fArmorStand)obj;
        ObjectID id = stand.getObjID();
        id.addArmorStand(stand);
    }

    public Project getProject(String s) {
        if (Objects.isNull(s)) {
            return null;
        }
        return this.projects.getOrDefault(s.toLowerCase(), null);
    }

    public boolean isValid(ObjectID obj) {
        if (obj == null) {
            return false;
        }
        return Type.SQLAction.REMOVE != obj.getSQLAction();
    }

    public boolean isEntityTypeRegistred(EntityType type) {
        return Objects.nonNull(type) ? packetClasses.containsKey(type) : false;
    }

    public fEntity spawnEntity(EntityType type, Location loc, ObjectID obj) {
        return this.spawnEntity(type.name(), loc, obj);
    }

    public fEntity createFromType(String str, Location loc, ObjectID obj) {
        return this.spawnEntity(str, loc, obj);
    }

    public fEntity spawnEntity(String str, Location loc, ObjectID obj) {
        fEntity entity = this.readEntity(str, loc, obj);
        if (Objects.nonNull(entity) && Objects.nonNull(obj)) {
            obj.addEntity(entity);
        }
        return entity;
    }

    public fEntity readEntity(String str, Location loc, ObjectID obj) {
        Optional<EntityType> entityType = Stream.of(EntityType.values()).filter(entry -> entry.name().equalsIgnoreCase(str)).findFirst();
        if (entityType.isPresent()) {
            return this.readEntity(entityType.get(), loc, obj);
        }
        return null;
    }

    public fEntity readEntity(EntityType entityType, Location loc, ObjectID obj) {
        BiFunction<Location, ObjectID, fEntity> packetClass = packetClasses.get(entityType);
        return Objects.nonNull(packetClass) ? packetClass.apply(loc, obj) : null;
    }

    public boolean furnitureAlreadyExistOnBlock(Block block) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        World world = block.getWorld();
        return this.getInChunkByCoord(chunkX, chunkZ, world).stream().anyMatch(entry -> entry.getBlockX() == x && entry.getBlockY() == y && entry.getBlockZ() == z);
    }

    public void killObject(ObjectID objectID, Player player) {
        WrapperPlayServerEntityDestroy.destroyPackets(objectID, player);
    }

    public void killObject(ObjectID objectID) {
        WrapperPlayServerEntityDestroy.destroyPackets(objectID, objectID.getPlayerList());
    }

    public HashSet<WorldData> getAsyncWorldFiles() {
        return this.asyncWorldFiles;
    }

    static {
        packetClasses.put(EntityType.ARMOR_STAND, fArmorStand::new);
        packetClasses.put(EntityType.PIG, fPig::new);
        packetClasses.put(EntityType.CREEPER, fCreeper::new);
        packetClasses.put(EntityType.GIANT, fGiant::new);
        if (FurnitureLib.getVersion(new MinecraftVersion("1.19.4"))) {
            packetClasses.put(EntityType.BLOCK_DISPLAY, fBlock_display::new);
            packetClasses.put(EntityType.ITEM_DISPLAY, fItem_display::new);
            packetClasses.put(EntityType.TEXT_DISPLAY, fText_display::new);
            packetClasses.put(EntityType.INTERACTION, fInteraction::new);
        }
        if (FurnitureLib.getVersion(new MinecraftVersion("1.20.5"))) {
            packetClasses.put(EntityType.MAGMA_CUBE, fMagmaCube::new);
            packetClasses.put(EntityType.SHULKER, fShulker::new);
        }
        ignoreList = new ArrayList<UUID>();
    }
}

