/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.collect.Lists;
import de.Ste3et_C0st.FurnitureLib.Command.TabCompleterHandler;
import de.Ste3et_C0st.FurnitureLib.Command.command;
import de.Ste3et_C0st.FurnitureLib.Command.disabledCommand;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.Database.DeSerializer;
import de.Ste3et_C0st.FurnitureLib.Database.SQLManager;
import de.Ste3et_C0st.FurnitureLib.Database.Serializer;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.Limitation;
import de.Ste3et_C0st.FurnitureLib.Listener.ChunkOnLoad;
import de.Ste3et_C0st.FurnitureLib.Listener.FurnitureProtocolListener;
import de.Ste3et_C0st.FurnitureLib.Listener.onBlockDispense;
import de.Ste3et_C0st.FurnitureLib.Listener.onCrafting;
import de.Ste3et_C0st.FurnitureLib.Listener.onEntityExplode;
import de.Ste3et_C0st.FurnitureLib.Listener.player.onFurnitureLibDisabled;
import de.Ste3et_C0st.FurnitureLib.Listener.player.onPlayerDeath;
import de.Ste3et_C0st.FurnitureLib.Listener.player.onPlayerJoin;
import de.Ste3et_C0st.FurnitureLib.Listener.player.onPlayerQuit;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.ProjectManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ColorUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.CraftingInv;
import de.Ste3et_C0st.FurnitureLib.Utilitis.FloodgateManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ServerFunction;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SpigotFunctions;
import de.Ste3et_C0st.FurnitureLib.Utilitis.autoConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.OfflinePlayerCache;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryManager;
import de.Ste3et_C0st.FurnitureLib.async.listener.onChunkChange;
import de.Ste3et_C0st.FurnitureLib.main.BlockManager;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.FurniturePlugin;
import de.Ste3et_C0st.FurnitureLib.main.LightManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.PermissionHandler;
import de.Ste3et_C0st.FurnitureLib.main.Protection.ProtectionManager;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.Updater;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FurnitureLib
extends JavaPlugin {
    private static FurnitureLib instance;
    private static List<FurniturePlugin> furniturePlugins;
    private static int versionInt;
    private static boolean enableDebug;
    private static int debugLevel;
    private static Boolean newVersion;
    public boolean enabled = true;
    public HashMap<Project, Long> deleteMap = new HashMap();
    public HashMap<UUID, Long> timeStampPlace = new HashMap();
    public HashMap<UUID, Long> timeStampBreak = new HashMap();
    private LocationUtil lUtil;
    private FurnitureManager manager;
    private ProtectionManager Pmanager;
    private LightManager lightMgr;
    private HashMap<String, List<String>> permissionKit = new HashMap();
    private CraftingInv craftingInv;
    private SQLManager sqlManager;
    private ColorUtil colorManager;
    private Serializer serializeNew;
    private DeSerializer deSerializerNew;
    private Updater updater;
    private BlockManager bmanager;
    private InventoryManager inventoryManager;
    private Type.ProtocolFields field = Type.ProtocolFields.Spigot110;
    private ProjectManager pManager;
    private PermissionHandler permissionHandler;
    private Material defMaterial = Material.valueOf((String)(FurnitureLib.isNewVersion() ? "COW_SPAWN_EGG" : "MONSTER_EGG"));
    private OfflinePlayerCache cache;
    private boolean enabledPlugin = false;
    private FurnitureConfig furnitureConfig;
    private FurnitureProtocolListener furnitureProtocolListener;
    private FloodgateManager floodgateManager = null;
    private ServerFunction serverFunction = null;
    private static boolean folia;
    private static boolean paper;

    private static boolean containsClass(String string) {
        try {
            Class<?> foliaClass = Class.forName(string);
            return Objects.nonNull(foliaClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isFolia() {
        return folia;
    }

    public static boolean isPaper() {
        return paper;
    }

    public static String getBukkitVersion() {
        return Bukkit.getServer().getBukkitVersion().replace(".", ",").replace("-", ",").split(",")[1];
    }

    public static FurnitureLib getInstance() {
        return instance;
    }

    public static List<FurniturePlugin> getFurniturePlugins() {
        return furniturePlugins;
    }

    public static void registerPlugin(FurniturePlugin plugin) {
        furniturePlugins.add(plugin);
        plugin.registerProjects();
        plugin.applyPluginFunctions();
    }

    public static void debug(String str) {
        FurnitureLib.debug(str, 0);
    }

    public static void debug(String str, int level) {
        if (enableDebug || level > debugLevel) {
            FurnitureLib.getInstance().getLogger().log(Level.INFO, str);
        }
    }

    public static void debug(List<String> str, int level) {
        str.forEach(entry -> FurnitureLib.debug(entry, level));
    }

    public static int getVersionInt() {
        return versionInt;
    }

    public static boolean isNewVersion() {
        return newVersion;
    }

    public LightManager getLightManager() {
        return this.lightMgr;
    }

    public ProtectionManager getPermManager() {
        return this.Pmanager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public ColorUtil getColorManager() {
        return this.colorManager;
    }

    public CraftingInv getCraftingInv() {
        return this.craftingInv;
    }

    public String getTimeDif(long input, long dif, String pattern) {
        return new SimpleDateFormat(pattern).format(new Date(dif - (System.currentTimeMillis() - input)));
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public Material getDefaultSpawnMaterial() {
        return this.defMaterial;
    }

    public LocationUtil getLocationUtil() {
        return this.lUtil;
    }

    public FurnitureManager getFurnitureManager() {
        return this.manager;
    }

    public ObjectID getObjectID(String c, String plugin, Location loc) {
        return new ObjectID(c, plugin, loc);
    }

    public Serializer getSerializer() {
        return this.serializeNew;
    }

    public DeSerializer getDeSerializer() {
        return this.deSerializerNew;
    }

    public PluginManager getPluginManager() {
        return this.getServer().getPluginManager();
    }

    public BlockManager getBlockManager() {
        return this.bmanager;
    }

    public SQLManager getSQLManager() {
        return this.sqlManager;
    }

    public Type.ProtocolFields getField() {
        return this.field;
    }

    public HashMap<String, List<String>> getPermissionList() {
        return this.permissionKit;
    }

    public ProjectManager getProjectManager() {
        return this.pManager;
    }

    public HashMap<UUID, Long> getTimePlace() {
        return this.timeStampPlace;
    }

    public HashMap<UUID, Long> getTimeBreak() {
        return this.timeStampBreak;
    }

    public PermissionHandler getPermission() {
        return this.permissionHandler;
    }

    public void send(String s) {
        this.getLogger().info(s);
    }

    public boolean canBuild(Player p, ObjectID id, Type.EventType type, boolean sendMessage) {
        return this.Pmanager.canBuild(p, id, type, sendMessage);
    }

    public boolean canBuild(Player p, ObjectID id, Type.EventType type) {
        return this.canBuild(p, id, type, true);
    }

    public boolean isAutoFileUpdater() {
        return this.furnitureConfig.isAutoFileUpdater();
    }

    public boolean checkPurge(ObjectID obj, UUID uuid) {
        return this.checkPurge(obj, uuid, this.furnitureConfig.getPurgeTime());
    }

    public boolean checkPurge(ObjectID obj, OfflinePlayer player) {
        return this.checkPurge(obj, player.getUniqueId());
    }

    public boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isBoolean(String s) {
        try {
            Boolean.parseBoolean(s.toLowerCase());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isAfterDate(long time, int purgeTime) {
        return System.currentTimeMillis() - (time + this.furnitureConfig.getPurgeTimeDays()) > 0L;
    }

    public void onEnable() {
        instance = this;
        this.furnitureConfig = new FurnitureConfig(instance);
        this.furnitureConfig.initLanguage();
        if (FurnitureLib.getVersionInt() < 12 || FurnitureLib.getVersionInt() > 21) {
            this.disableFurnitureLib(Arrays.asList("<red>FurnitureLib only works on Spigot 1.12 - 1.21.10"));
            return;
        }
        if (!this.getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.disableFurnitureLib(Arrays.asList("<red>FurnitureLib <gray>can't be enabled", "<gray>Please <red>install <gray>the right <red>Protocollib version", "<click:open_url:'https://www.spigotmc.org/resources/protocollib.1997/'><red>https://www.spigotmc.org/resources/protocollib.1997/</click>", "<red>FurnitureLib is temporarily <dark_red>disabled"));
            this.send("==========================================");
            return;
        }
        if (this.getPluginManager().isPluginEnabled("Floodgate")) {
            this.floodgateManager = new FloodgateManager();
        }
        this.enabledPlugin = true;
        this.field = Type.ProtocolFields.getField(this.getServer().getBukkitVersion());
        this.lUtil = new LocationUtil();
        this.loadServerFunctions();
        this.manager = new FurnitureManager();
        this.furnitureConfig.loadPluginConfig();
        this.updater = new Updater();
        this.colorManager = new ColorUtil();
        this.serializeNew = new Serializer();
        this.deSerializerNew = new DeSerializer();
        this.lightMgr = new LightManager((Plugin)this);
        this.pManager = new ProjectManager();
        this.permissionHandler = new PermissionHandler();
        this.Pmanager = new ProtectionManager((Plugin)instance);
        this.cache = new OfflinePlayerCache();
        this.furnitureConfig.getLangManager().sendConsoleMessage("==========================================");
        this.furnitureConfig.getLangManager().sendConsoleMessage("FurnitureLib Version: <yellow>" + this.getDescription().getVersion());
        this.furnitureConfig.getLangManager().sendConsoleMessage("Furniture Author: <gold>Ste3et_C0st");
        this.furnitureConfig.getLangManager().sendConsoleMessage("Furniture Website: <yellow>" + this.getDescription().getWebsite());
        this.furnitureConfig.getLangManager().sendConsoleMessage("Furniture find ProtectionLib: " + (this.isEnable("ProtectionLib", false) ? "<green>true" : "<red>false"));
        this.bmanager = new BlockManager();
        this.craftingInv = new CraftingInv((Plugin)this);
        this.loadPermissionKit();
        autoConverter.modelConverter((CommandSender)this.getServer().getConsoleSender());
        this.sqlManager = new SQLManager(instance);
        this.sqlManager.saveInterval(FurnitureConfig.getFurnitureConfig().getSaveIntervall());
        this.inventoryManager = new InventoryManager();
        autoConverter.databaseConverter((CommandSender)this.getServer().getConsoleSender(), this.furnitureConfig.getDatabaseString());
        this.pManager.loadProjectFiles();
        this.getFurnitureManager().getObjectList().stream().forEach(ObjectID::registerBlocks);
        this.registerEvents();
        if (this.furnitureConfig.isAutoPurge()) {
            DeSerializer.autoPurge(this.furnitureConfig.getPurgeTime());
        }
        this.furnitureConfig.getLangManager().sendConsoleMessage("\u00a72Furniture load finish :)");
        this.furnitureConfig.getLangManager().sendConsoleMessage("==========================================");
        Bukkit.getOnlinePlayers().stream().filter(p -> p != null && p.isOp()).forEach(p -> this.getUpdater().sendPlayer((Player)p));
        PluginCommand c = this.getCommand("furniture");
        c.setExecutor((CommandExecutor)new command((Plugin)this));
        c.setTabCompleter((TabCompleter)new TabCompleterHandler());
    }

    private void loadServerFunctions() {
        try {
            if (FurnitureLib.isPaper()) {
                this.serverFunction = (ServerFunction)Class.forName("de.Ste3et_C0st.FurnitureLib.Paper.PaperFunctions").newInstance();
            } else if (FurnitureLib.isFolia()) {
                this.serverFunction = (ServerFunction)Class.forName("de.Ste3et_C0st.FurnitureLib.Folia.FoliaFunctions").newInstance();
            }
        }
        catch (Exception excpetion) {
            excpetion.printStackTrace();
        }
        if (this.serverFunction == null) {
            this.serverFunction = new SpigotFunctions();
        }
        this.serverFunction.onEnable();
    }

    private void registerEvents() {
        this.getPluginManager().registerEvents((Listener)new onPlayerJoin(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onCrafting(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onBlockDispense(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onEntityExplode(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onPlayerDeath(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onPlayerQuit(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new ChunkOnLoad(), (Plugin)FurnitureLib.getInstance());
        this.getPluginManager().registerEvents((Listener)new onChunkChange(), (Plugin)FurnitureLib.getInstance());
        this.furnitureProtocolListener = new FurnitureProtocolListener();
    }

    private void disableFurnitureLib(List<String> instructions) {
        this.furnitureConfig.getLangManager().sendConsoleMessage(instructions.toArray(new String[instructions.size()]));
        this.enabled = false;
        this.getCommand("furniture").setExecutor((CommandExecutor)new disabledCommand(this, instructions));
        Bukkit.getPluginManager().registerEvents((Listener)new onFurnitureLibDisabled(instructions), (Plugin)this);
    }

    public boolean isEnabledPlugin() {
        return this.enabledPlugin;
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.getFurnitureConfig().getLimitManager().getTypes().forEach(Limitation::reload);
        this.furnitureConfig.initLanguage();
        this.furnitureConfig.loadPluginConfig();
        FurnitureManager.getInstance().getProjects().forEach(Project::loadDefaults);
    }

    public BufferedReader loadStream(String internUri) {
        if (!((String)internUri).startsWith("/")) {
            internUri = "/" + (String)internUri;
        }
        InputStream stream = ((Object)((Object)FurnitureLib.getInstance())).getClass().getResourceAsStream((String)internUri);
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    private void loadPermissionKit() {
        try {
            File permissionFile = new File(this.getDataFolder(), "permissionKit.yml");
            YamlConfiguration permissionConfig = YamlConfiguration.loadConfiguration((File)permissionFile);
            if (Objects.isNull(permissionConfig)) {
                return;
            }
            permissionConfig.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)this.loadStream("permissionKit.yml")));
            permissionConfig.options().copyDefaults(true);
            permissionConfig.options().copyHeader(true);
            permissionConfig.save(permissionFile);
            if (!permissionConfig.contains("kit")) {
                return;
            }
            if (permissionConfig.isConfigurationSection("kit")) {
                permissionConfig.getConfigurationSection("kit").getKeys(false).forEach(letter -> {
                    String header = letter;
                    if (permissionConfig.isSet("kit." + header)) {
                        List projectList = new ArrayList();
                        if (permissionConfig.getStringList("kit." + header) != null) {
                            projectList = permissionConfig.getStringList("kit." + header);
                        }
                        this.permissionKit.put(header, projectList);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveIgnore() {
        try {
            File ignoredFile = new File(this.getDataFolder(), "ignoredPlayers.yml");
            YamlConfiguration configuration = new YamlConfiguration();
            ArrayList ignoreList = new ArrayList();
            this.getFurnitureManager().getIgnoreList().stream().map(UUID::toString).forEach(ignoreList::add);
            configuration.set("ignoreList", ignoreList);
            configuration.save(ignoredFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkPurge(ObjectID obj, UUID uuid, int purgeTime) {
        Optional<DiceOfflinePlayer> optional = this.getPlayerCache().getPlayer(uuid);
        if (optional.isPresent()) {
            long lastSeen = optional.get().getLastSeen();
            if (!this.isAfterDate(lastSeen, purgeTime)) {
                return false;
            }
            if (this.furnitureConfig.isPurgeRemove()) {
                this.getFurnitureManager().remove(obj);
                return false;
            }
            obj.setSQLAction(Type.SQLAction.REMOVE);
            return true;
        }
        return false;
    }

    public void registerPluginFurnitures(Plugin plugin) {
        if (!this.enabledPlugin) {
            return;
        }
        this.manager.getObjectList().stream().filter(obj -> obj != null && obj.getPlugin() != null).forEach(obj -> {
            if (!obj.getSQLAction().equals((Object)Type.SQLAction.REMOVE) && obj.getPlugin().equalsIgnoreCase(plugin.getName())) {
                this.spawn(obj.getProjectOBJ(), (ObjectID)obj);
            }
        });
    }

    private boolean isEnable(String plugin, boolean shutdown) {
        boolean b = this.getServer().getPluginManager().isPluginEnabled(plugin);
        if (!b && shutdown) {
            this.disableFurnitureLib(Arrays.asList("ProtocolLib is missing please install ProtocolLib", "You can it download at: \u00a76\u00a7lhttps://www.spigotmc.org/resources/protocollib.1997/"));
        }
        return b;
    }

    public void onDisable() {
        this.getLogger().info("==========================================");
        this.getLogger().info("Furniture shutdown started");
        this.furnitureConfig.getLangManager().close();
        if (Objects.nonNull(this.sqlManager)) {
            if (!this.getConfig().getBoolean("config.timer.Enable")) {
                this.sqlManager = new SQLManager(this);
            }
            this.sqlManager.save();
            this.sqlManager.stop();
        }
        instance = null;
        if (Objects.nonNull(this.getFurnitureManager())) {
            if (!this.getFurnitureManager().getObjectList().isEmpty()) {
                for (ObjectID obj : this.getFurnitureManager().getObjectList()) {
                    for (fEntity as : obj.getPacketList()) {
                        as.kill();
                    }
                }
            }
            this.saveIgnore();
        }
        this.getLogger().info("==========================================");
    }

    public ObjectID spawn(Project pro, Location l) {
        ObjectID objectID = pro.createObjectID(l);
        this.spawn(pro, objectID);
        return objectID;
    }

    public static boolean useDebugMode() {
        return enableDebug;
    }

    public void spawn(Project pro, ObjectID obj) {
        if (pro == null || obj == null) {
            return;
        }
        obj.getProjectOBJ().getModelschematic().spawn(obj);
        pro.applyFunction(obj);
        obj.setFinish();
    }

    public void spawnWithAnimation(Project pro, ObjectID objectID) {
        if (pro == null || objectID == null) {
            return;
        }
        objectID.getProjectOBJ().getModelschematic().spawnWithAnimation(objectID);
        pro.applyFunction(objectID);
        objectID.setFinish();
    }

    public FloodgateManager getFloodgateManager() {
        return this.floodgateManager;
    }

    public OfflinePlayerCache getPlayerCache() {
        return this.cache;
    }

    public static void setDebug(boolean bool) {
        enableDebug = bool;
    }

    public FurnitureConfig getFurnitureConfig() {
        return this.furnitureConfig;
    }

    public static boolean getVersion(MinecraftVersion minecraftVersion) {
        return minecraftVersion.atOrAbove();
    }

    public static boolean isVersionOrAbove(String string) {
        return FurnitureLib.getVersion(new MinecraftVersion(string));
    }

    public ServerFunction getServerFunction() {
        return this.serverFunction;
    }

    public static String getPacketVersion() {
        return "";
    }

    static {
        furniturePlugins = Lists.newArrayList();
        versionInt = 0;
        enableDebug = false;
        debugLevel = 0;
        newVersion = null;
        folia = false;
        paper = false;
        versionInt = Integer.parseInt(FurnitureLib.getBukkitVersion());
        newVersion = versionInt > 12;
        folia = FurnitureLib.containsClass("io.papermc.paper.threadedregions.RegionizedServer");
        paper = FurnitureLib.containsClass("com.destroystokyo.paper.event.block.BlockDestroyEvent");
    }
}

