/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fArmorStand;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class FurnitureHelper {
    private BlockFace b;
    private World w;
    private ObjectID obj;
    private FurnitureManager manager;
    private FurnitureLib lib;
    private LocationUtil lutil;
    private Plugin plugin;

    public FurnitureHelper(ObjectID id) {
        if (id == null) {
            return;
        }
        this.lib = FurnitureLib.getInstance();
        this.lutil = this.lib.getLocationUtil();
        this.manager = this.lib.getFurnitureManager();
        this.b = LocationUtil.yawToFace(id.getStartLocation().getYaw());
        this.w = id.getStartLocation().getWorld();
        this.plugin = id.getProjectOBJ().getPlugin();
        this.obj = id;
    }

    public fEntity spawnEntity(Location location, EntityType type) {
        return this.getManager().spawnEntity(type, location, this.obj);
    }

    @Deprecated
    public fArmorStand spawnArmorStand(Location loc) {
        return this.getManager().createArmorStand(this.getObjID(), loc);
    }

    public Location getLocation() {
        Location loc = this.obj.getStartLocation().getBlock().getLocation();
        loc.setYaw(this.obj.getStartLocation().getYaw());
        return loc;
    }

    public BlockFace getBlockFace() {
        return this.b;
    }

    public World getWorld() {
        return this.w;
    }

    public ObjectID getObjID() {
        return this.obj;
    }

    public FurnitureManager getManager() {
        return this.manager;
    }

    public FurnitureLib getLib() {
        return this.lib;
    }

    public LocationUtil getLutil() {
        return this.lutil;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public HashSet<fEntity> getfAsList() {
        return Objects.nonNull(this.getObjID()) ? this.getObjID().getPacketList() : null;
    }

    public HashSet<fEntity> getEntitySet() {
        return this.getfAsList();
    }

    public boolean isFinish() {
        return this.getObjID().isFinish();
    }

    public float getYaw() {
        return this.getLutil().FaceToYaw(this.getBlockFace());
    }

    public Location getRelative(Location loc, BlockFace face, double z, double x) {
        return this.getLutil().getRelative(loc, this.b, z, x);
    }

    public Location getRelative(Location loc, double z, double x) {
        return this.getLutil().getRelative(loc, this.getBlockFace(), z, x);
    }

    public void destroy(Player p) {
        this.getObjID().remove(p);
    }

    public void send() {
        this.getManager().send(this.obj);
    }

    public void update() {
        this.getManager().updateFurniture(this.obj);
    }

    public void delete() {
        this.obj = null;
    }

    public void consumeItem(Player p) {
        if (p.getGameMode().equals((Object)GameMode.CREATIVE) && FurnitureConfig.getFurnitureConfig().useGamemode()) {
            return;
        }
        ItemStack is = p.getInventory().getItemInMainHand();
        if (is.getAmount() - 1 <= 0) {
            is.setType(Material.AIR);
        } else {
            is.setAmount(is.getAmount() - 1);
        }
        p.getInventory().setItem(p.getInventory().getHeldItemSlot(), is);
        p.updateInventory();
    }

    public boolean canBuild(Player p, boolean echo) {
        return FurnitureLib.getInstance().canBuild(p, this.getObjID(), Type.EventType.BREAK, echo);
    }

    public boolean canBuild(Player p) {
        return this.canBuild(p, true);
    }

    public boolean canInteract(Player p) {
        return this.canInteract(p, true);
    }

    public boolean canInteract(Player p, boolean echo) {
        return FurnitureLib.getInstance().canBuild(p, this.getObjID(), Type.EventType.INTERACT, echo);
    }

    public Location getCenter() {
        Location loc = this.getLutil().getCenter(this.getLocation());
        loc.setYaw((float)this.getLutil().FaceToYaw(this.getBlockFace()));
        return loc;
    }

    public fEntity entityByCustomName(String str) {
        for (fEntity entity : this.getfAsList()) {
            if (!entity.getCustomName().equalsIgnoreCase(str)) continue;
            return entity;
        }
        return null;
    }

    public List<fEntity> entitiesByCustomName(String str) {
        return this.getfAsList().stream().filter(e -> e.getCustomName().equalsIgnoreCase(str)).collect(Collectors.toList());
    }

    public void toggleLight(boolean change) {
        Collection fEntities = this.getfAsList().stream().filter(fEntity::hasCustomName).filter(entry -> entry.getName().toUpperCase().startsWith("#FIRE:")).collect(Collectors.toList());
        if (!fEntities.isEmpty()) {
            this.toggleLight(fEntities, change);
        }
    }

    public void toggleLight(Collection<fEntity> fEntityCollection, boolean change) {
        AtomicBoolean needUpdate = new AtomicBoolean(false);
        fEntityCollection.forEach(entity -> {
            if (this.changeLight((fEntity)entity, change)) {
                needUpdate.set(true);
            }
        });
        if (needUpdate.get()) {
            this.update();
            this.getObjID().setSQLAction(Type.SQLAction.UPDATE);
        }
    }

    private boolean changeLight(fEntity entity, boolean change) {
        if (entity.getName().contains(":")) {
            String[] str = entity.getName().split(":");
            String lightBool = str[2];
            if (Objects.nonNull(change) && change) {
                if (lightBool.equalsIgnoreCase("off#")) {
                    entity.setName(entity.getName().replace("off#", "on#"));
                    if (!entity.isFire()) {
                        entity.setFire(true);
                        return true;
                    }
                } else if (lightBool.equalsIgnoreCase("on#")) {
                    entity.setName(entity.getName().replace("on#", "off#"));
                    if (entity.isFire()) {
                        entity.setFire(false);
                        return true;
                    }
                }
            } else if (lightBool.equalsIgnoreCase("on#") && !entity.isFire()) {
                entity.setFire(true);
                return true;
            }
        }
        return false;
    }

    private boolean switchLight(fEntity entity) {
        if (entity.getName().contains(":")) {
            String[] str = entity.getName().split(":");
            String lightBool = str[2];
            if (lightBool.equalsIgnoreCase("off#")) {
                entity.setName(entity.getName().replace("off#", "on#"));
                if (!entity.isFire()) {
                    entity.setFire(true);
                    return true;
                }
            } else if (lightBool.equalsIgnoreCase("on#")) {
                entity.setName(entity.getName().replace("on#", "off#"));
                if (entity.isFire()) {
                    entity.setFire(false);
                    return true;
                }
            }
        }
        return false;
    }

    public void toggleLight() {
        HashSet updateSet = new HashSet();
        this.getfAsList().stream().filter(fEntity::hasCustomName).filter(entry -> entry.getName().toUpperCase().startsWith("#LIGHT:")).forEach(fentity -> {
            if (this.switchLight((fEntity)fentity)) {
                updateSet.add(fentity);
            }
        });
        if (!updateSet.isEmpty()) {
            updateSet.stream().forEach(fEntity::update);
            this.getObjID().setSQLAction(Type.SQLAction.UPDATE);
        }
    }

    public abstract void onClick(Player var1);

    public abstract void onBreak(Player var1);
}

