/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import de.Ste3et_C0st.FurnitureLib.Database.com.zaxxer.hikari.HikariConfig;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.LimitationManager;
import de.Ste3et_C0st.FurnitureLib.Listener.render.RenderEventHandler;
import de.Ste3et_C0st.FurnitureLib.Listener.render.RenderWithBukkit;
import de.Ste3et_C0st.FurnitureLib.Listener.render.RenderWithProtocols;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Metrics;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FurnitureConfig {
    private LanguageManager lmanager;
    private boolean useGamemode = true;
    private boolean canSit = true;
    private boolean update = true;
    private boolean useParticle = true;
    private boolean useRegionMemberAccess = false;
    private boolean autoPurge = false;
    private boolean removePurge = false;
    private boolean creativeInteract = true;
    private boolean creativePlace = true;
    private boolean glowing = true;
    private boolean spamBreak = true;
    private boolean spamPlace = true;
    private boolean rotateOnSit = true;
    private boolean useSSL = false;
    private boolean sync = true;
    private boolean packetRenderMethode = false;
    private boolean hideBedrockPlayers = true;
    private boolean whitelist = false;
    private boolean autoFileUpdater = false;
    private boolean importCheck = false;
    private boolean autoSaveConsoleMessage = true;
    private Type.StorageType storageType = Type.StorageType.LEGACY;
    private int purgeTime = 30;
    private int viewDistance = 100;
    private int limitGlobal = -1;
    private int saveIntervall;
    private long purgeTimeMS = 0L;
    private long spamBreakTime = 5000L;
    private long spamPlaceTime = 5000L;
    private List<String> worlds = new ArrayList<String>();
    private final FurnitureLib instance;
    private String timePattern = "mm:ss:SSS";
    private String databaseTableString = "FurnitureLib_Objects";
    private Type.PublicMode mode;
    private Type.EventType type;
    private LimitationManager limitManager;
    private static FurnitureConfig furnitureConfig = null;
    private RenderEventHandler renderEventHandler;
    private static final int BSTATS_ID = 454;
    private Type.DataBaseType databaseType = Type.DataBaseType.SQLite;
    private BiConsumer<CommandSender, String> databaseOutput = (sender, message) -> sender.sendMessage(message);

    public FurnitureConfig(FurnitureLib instance) {
        this.instance = instance;
        furnitureConfig = this;
        FurnitureLib.getInstance().saveDefaultConfig();
        this.initStaticConfigs();
    }

    private void initStaticConfigs() {
        if (this.isNewVersion()) {
            this.updateConfig();
            String key = "storage-options.";
            this.storageType = Type.StorageType.valueOf(this.getConfig().getString("storage-options.storage-methode", "LEGACY").toUpperCase());
            this.autoFileUpdater = this.getConfig().getBoolean("storage-options.auto_convert", false);
            this.databaseTableString = this.getConfig().getString("storage-options.database-table-old", "FurnitureLib_Objects");
            this.importCheck = this.getConfig().getBoolean("storage-options.importCheck", false);
            this.saveIntervall = this.getConfig().getInt("storage-options.auto-save-interval", 300);
            this.sync = this.getConfig().getBoolean("sync", true);
        } else {
            this.useSSL = this.getConfig().getBoolean("config.Database.useSSL");
            this.sync = this.getConfig().getBoolean("config.sync", true);
            this.databaseTableString = this.getConfig().getString("config.fileConverter.database_table", "FurnitureLib_Objects");
            this.autoFileUpdater = this.getConfig().getBoolean("config.fileConverter.auto_mode", false);
            this.importCheck = this.getConfig().getBoolean("config.Database.importCheck", false);
            this.saveIntervall = this.getConfig().getInt("config.timer.time", 300);
            if (this.getConfig().getBoolean("config.UseMetrics")) {
                new Metrics((Plugin)this.instance, 454);
            }
        }
    }

    public HikariConfig loadDatabaseAsset() {
        HikariConfig config = new HikariConfig();
        config.getDataSourceProperties().put("dataSource.logWriter", new PrintWriter(System.out));
        if (this.isNewVersion()) {
            String key = "storage-options.";
            if (this.getConfig().getString("storage-options.storage-type").equalsIgnoreCase("SQLite")) {
                String database = this.getConfig().getString("storage-options.database");
                config.setJdbcUrl("jdbc:sqlite:plugins/FurnitureLib/" + database + ".db");
                config.setDriverClassName("org.sqlite.JDBC");
                config.setPoolName("FurnitureLib");
                config.setConnectionTestQuery("SELECT 1");
                config.setMaximumPoolSize(10);
                this.databaseType = Type.DataBaseType.SQLite;
            } else if (this.getConfig().getString("storage-options.storage-type").equalsIgnoreCase("Mysql")) {
                String database = this.getConfig().getString("storage-options.database");
                String user = this.getConfig().getString("storage-options.user");
                String password = this.getConfig().getString("storage-options.password");
                String port = this.getConfig().getString("storage-options.port", "3306");
                String host = this.getConfig().getString("storage-options.adress");
                boolean allowPublicKeyRetrieval = this.getConfig().getBoolean("storage-options.connection-properties.allowPublicKeyRetrieval", false);
                boolean useSSL = this.getConfig().getBoolean("storage-options.connection-properties.useSSL", true);
                config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSSL + "&allowPublicKeyRetrieval=" + allowPublicKeyRetrieval);
                config.setUsername(user);
                config.setPassword(password);
                config.setPoolName("FurnitureLib");
                config.setMaximumPoolSize(this.getConfig().getInt("storage-options.database-pool-settings.maximum-pool-size", 10));
                config.setIdleTimeout(this.getConfig().getInt("storage-options.database-pool-settings.idleTimeout", 10));
                config.setMinimumIdle(this.getConfig().getInt("storage-options.database-pool-settings.minimum-idle", 10));
                config.setMaxLifetime(this.getConfig().getInt("storage-options.database-pool-settings.maximum-lifetime", 10));
                config.setConnectionTimeout(this.getConfig().getInt("storage-options.database-pool-settings.connection-timeout", 10));
                this.databaseType = Type.DataBaseType.MySQL;
            }
        } else if (this.getConfig().getString("config.Database.type").equalsIgnoreCase("SQLite")) {
            String database = this.getConfig().getString("config.Database.database");
            config.setJdbcUrl("jdbc:sqlite:plugins/FurnitureLib/" + database + ".db");
            config.setDriverClassName("org.sqlite.JDBC");
            config.setPoolName("FurnitureLib");
            config.setConnectionTestQuery("SELECT 1");
            config.setMaximumPoolSize(10);
            config.setIdleTimeout(15L);
            this.databaseType = Type.DataBaseType.SQLite;
        } else if (this.getConfig().getString("config.Database.type").equalsIgnoreCase("Mysql")) {
            String database = this.getConfig().getString("config.Database.database");
            String user = this.getConfig().getString("config.Database.user");
            String password = this.getConfig().getString("config.Database.password");
            String port = this.getConfig().getString("config.Database.port", "3306");
            String host = this.getConfig().getString("config.Database.host");
            boolean allowPublicKeyRetrieval = this.getConfig().getBoolean("config.Database.allowPublicKeyRetrieval", false);
            boolean useSSL = this.getConfig().getBoolean("config.Database.useSSL", true);
            config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSSL + "&allowPublicKeyRetrieval=" + allowPublicKeyRetrieval);
            config.setUsername(user);
            config.setPassword(password);
            config.setPoolName("FurnitureLib");
            config.setMaximumPoolSize(10);
            config.setIdleTimeout(15L);
            config.setMinimumIdle(10);
            config.setMaxLifetime(1800000L);
            config.setConnectionTimeout(5000L);
            this.databaseType = Type.DataBaseType.MySQL;
        }
        return config;
    }

    public void loadPluginConfig() {
        if (this.isNewVersion()) {
            this.loadNewConfig();
        } else {
            this.loadLegacyConfig();
        }
    }

    private boolean isNewVersion() {
        if (!this.getConfig().contains("config-version")) {
            return false;
        }
        return this.getConfig().getInt("config-version", 1) > 1;
    }

    public void initLanguage() {
        this.lmanager = this.isNewVersion() ? new LanguageManager((Plugin)this.instance, this.getConfig().getString("general-options.language")) : new LanguageManager((Plugin)this.instance, this.getConfig().getString("config.Language"));
    }

    private void loadNewConfig() {
        FurnitureLib.setDebug(this.getConfig().getBoolean("general-options.debugMode", false));
        this.canSit = !this.getConfig().getBoolean("general-options.DisableSitting");
        this.useParticle = this.getConfig().getBoolean("general-options.useParticles");
        this.glowing = this.getConfig().getBoolean("general-options.glowing");
        this.rotateOnSit = this.getConfig().getBoolean("general-options.rotateOnSit");
        this.update = this.getConfig().getBoolean("general-options.checkForUpdate");
        this.autoSaveConsoleMessage = this.getConfig().getBoolean("storage-options.auto-save-console-message", true);
        this.databaseOutput = this.autoSaveConsoleMessage ? (sender, message) -> sender.sendMessage(message) : (sender, message) -> {};
        this.useGamemode = !this.getConfig().getBoolean("creative-options.removeItems");
        this.creativeInteract = this.getConfig().getBoolean("creative-options.interact-with-models");
        this.creativePlace = this.getConfig().getBoolean("creative-options.place-models");
        this.purgeTime = this.getConfig().getInt("purge-options.time");
        this.autoPurge = this.getConfig().getBoolean("purge-options.enable");
        this.purgeTimeMS = TimeUnit.DAYS.toMillis(this.purgeTime);
        this.removePurge = this.getConfig().getBoolean("purge-options.removePurge");
        this.viewDistance = Bukkit.getViewDistance();
        this.worlds = this.getConfig().getStringList("world-options.worlds");
        this.packetRenderMethode = this.getConfig().getBoolean("world-options.packetRenderMethode");
        this.viewDistance = this.getConfig().getInt("world-options.viewRange", 10);
        this.whitelist = this.getConfig().getBoolean("world-options.whitelist", false);
        ObjectID.setRange(this.viewDistance);
        this.useRegionMemberAccess = this.getConfig().getBoolean("hook.ProtectionLib.RegionMemberAccess", this.getConfig().getBoolean("hook.ProtectionLib.RegeionMemberAccess"));
        this.hideBedrockPlayers = this.getConfig().getBoolean("hook.Floodgate.hideModelsForBedrockClients", true);
        this.spamBreak = this.getConfig().getBoolean("antispam-options.break-delay.enable");
        this.spamPlace = this.getConfig().getBoolean("antispam-options.place-delay.enable");
        this.spamBreakTime = this.getConfig().getLong("antispam-options.break-delay.time");
        this.spamPlaceTime = this.getConfig().getLong("antispam-options.place-delay.time");
        this.timePattern = this.getConfig().getString("antispam-options.timeDisplay");
        String limitConfig = this.getConfig().getString("limit-options.limitConfig", "PLAYER").toUpperCase();
        ArrayList<Type.LimitationType> type = new ArrayList<Type.LimitationType>();
        if (limitConfig.contains(",")) {
            String[] arrays;
            for (String str : arrays = limitConfig.split(",")) {
                try {
                    type.add(Type.LimitationType.valueOf(str.toUpperCase()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            type.add(Type.LimitationType.valueOf(limitConfig));
        }
        this.limitManager = new LimitationManager(this.instance, type.toArray(new Type.LimitationType[type.size()]));
        this.limitGlobal = this.getConfig().getInt("limit-options.limitGlobal", -1);
        this.type = Type.EventType.valueOf(this.getConfig().getString("model-protection.action", "INTERACT").toUpperCase());
        this.mode = Type.PublicMode.valueOf(this.getConfig().getString("model-protection.place-models-in-mode", "PRIVATE").toUpperCase());
        this.loadIgnore();
        this.debug("Config->useGamemode:" + this.useGamemode);
        this.debug("Config->creativeInteract:" + this.creativeInteract);
        this.debug("Config->creativePlace:" + this.creativePlace);
        this.debug("Config->useRegionMemberAccess:" + this.useRegionMemberAccess);
        this.debug("Config->canSit:" + this.canSit);
        this.debug("Config->useParticle:" + this.useParticle);
        this.debug("Config->purgeTime" + this.purgeTime);
        this.debug("Config->autoPurge:" + this.autoPurge);
        this.debug("Config->removePurge:" + this.removePurge);
        this.debug("Config->viewDistance:" + this.viewDistance);
        this.debug("Config->glowing:" + this.glowing);
        this.debug("Config->spamBreak:" + this.spamBreak);
        this.debug("Config->spamPlace:" + this.spamPlace);
        this.debug("Config->spamBreakTime:" + this.spamBreakTime);
        this.debug("Config->spamPlaceTime:" + this.spamPlaceTime);
        this.debug("Config->timePattern:" + this.timePattern);
        this.debug("Config->rotateOnSit:" + this.rotateOnSit);
        this.debug("Config->limitConfig:" + limitConfig);
        this.debug("Config->limitGlobal:" + this.limitGlobal);
        this.debug("Config->PlaceMode.Access:" + this.type.name);
        this.debug("Config->PlaceMode.Mode:" + this.mode.name);
        this.debug("Config->update:" + this.update);
        this.registerRenderEvents();
    }

    private void updateConfig() {
        try (InputStream stream = ((Object)((Object)FurnitureLib.getInstance())).getClass().getResourceAsStream("/config.yml");
             InputStreamReader reader = new InputStreamReader(stream);){
            YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)reader);
            FileConfiguration furnitureConfig = this.getConfig();
            if (furnitureConfig.getInt("config-version", 2) != defaults.getInt("config-version", 3)) {
                boolean change = false;
                for (String defaultKey : defaults.getKeys(true)) {
                    if (furnitureConfig.contains(defaultKey, true)) continue;
                    furnitureConfig.set(defaultKey, defaults.get(defaultKey));
                    change = true;
                }
                if (change) {
                    furnitureConfig.set("config-version", (Object)defaults.getInt("config-version"));
                    FurnitureLib.getInstance().saveConfig();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadLegacyConfig() {
        FurnitureLib.setDebug(this.getConfig().getBoolean("config.debugMode", false));
        this.useGamemode = !this.getConfig().getBoolean("config.Creative.RemoveItems");
        this.creativeInteract = this.getConfig().getBoolean("config.Creative.Interact");
        this.creativePlace = this.getConfig().getBoolean("config.Creative.Place");
        this.useRegionMemberAccess = this.getConfig().getBoolean("config.ProtectionLib.RegeionMemberAccess");
        this.canSit = !this.getConfig().getBoolean("config.DisableSitting");
        this.useParticle = this.getConfig().getBoolean("config.useParticles");
        this.purgeTime = this.getConfig().getInt("config.Purge.time");
        this.autoPurge = this.getConfig().getBoolean("config.Purge.autoPurge");
        this.purgeTimeMS = TimeUnit.DAYS.toMillis(this.purgeTime);
        this.removePurge = this.getConfig().getBoolean("config.Purge.removePurge");
        this.viewDistance = Bukkit.getViewDistance();
        this.worlds = this.getConfig().getStringList("config.ignoredWorlds");
        this.packetRenderMethode = this.getConfig().getBoolean("config.packetRenderMethode");
        this.viewDistance = this.getConfig().getInt("config.viewRange", 10);
        this.hideBedrockPlayers = this.getConfig().getBoolean("config.autoHideBedrockPlayers", true);
        ObjectID.setRange(this.viewDistance);
        this.glowing = this.getConfig().getBoolean("config.glowing");
        this.spamBreak = this.getConfig().getBoolean("config.spamBlock.Break.Enable");
        this.spamPlace = this.getConfig().getBoolean("config.spamBlock.Place.Enable");
        this.spamBreakTime = this.getConfig().getLong("config.spamBlock.Break.time");
        this.spamPlaceTime = this.getConfig().getLong("config.spamBlock.Place.time");
        this.timePattern = this.getConfig().getString("config.spamBlock.timeDisplay");
        this.rotateOnSit = this.getConfig().getBoolean("config.rotateOnSit");
        String limitConfig = this.getConfig().getString("limit-options.limitConfig", "PLAYER").toUpperCase();
        ArrayList<Type.LimitationType> type = new ArrayList<Type.LimitationType>();
        if (limitConfig.contains(",")) {
            String[] arrays;
            for (String str : arrays = limitConfig.split(",")) {
                try {
                    type.add(Type.LimitationType.valueOf(str.toUpperCase()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            type.add(Type.LimitationType.valueOf(limitConfig));
        }
        this.limitManager = new LimitationManager(this.instance, type.toArray(new Type.LimitationType[type.size()]));
        this.limitGlobal = this.getConfig().getInt("config.limit.limitGlobal", -1);
        this.type = Type.EventType.valueOf(this.getConfig().getString("config.PlaceMode.Access", "INTERACT"));
        this.mode = Type.PublicMode.valueOf(this.getConfig().getString("config.PlaceMode.Mode", "PRIVATE"));
        this.update = this.getConfig().getBoolean("config.CheckUpdate");
        this.loadIgnore();
        this.debug("Config->useGamemode:" + this.useGamemode);
        this.debug("Config->creativeInteract:" + this.creativeInteract);
        this.debug("Config->creativePlace:" + this.creativePlace);
        this.debug("Config->useRegionMemberAccess:" + this.useRegionMemberAccess);
        this.debug("Config->canSit:" + this.canSit);
        this.debug("Config->useParticle:" + this.useParticle);
        this.debug("Config->purgeTime" + this.purgeTime);
        this.debug("Config->autoPurge:" + this.autoPurge);
        this.debug("Config->removePurge:" + this.removePurge);
        this.debug("Config->viewDistance:" + this.viewDistance);
        this.debug("Config->glowing:" + this.glowing);
        this.debug("Config->spamBreak:" + this.spamBreak);
        this.debug("Config->spamPlace:" + this.spamPlace);
        this.debug("Config->spamBreakTime:" + this.spamBreakTime);
        this.debug("Config->spamPlaceTime:" + this.spamPlaceTime);
        this.debug("Config->timePattern:" + this.timePattern);
        this.debug("Config->rotateOnSit:" + this.rotateOnSit);
        this.debug("Config->limitConfig:" + limitConfig);
        this.debug("Config->limitGlobal:" + this.limitGlobal);
        this.debug("Config->PlaceMode.Access:" + this.type.name);
        this.debug("Config->PlaceMode.Mode:" + this.mode.name);
        this.debug("Config->update:" + this.update);
        this.registerRenderEvents();
    }

    private void registerRenderEvents() {
        if (Objects.nonNull(this.renderEventHandler)) {
            this.renderEventHandler.remove();
        }
        this.renderEventHandler = this.packetRenderMethode ? new RenderWithProtocols() : new RenderWithBukkit();
        this.renderEventHandler.register();
    }

    public List<String> getIgnoredWorldList() {
        return this.worlds;
    }

    public boolean isWorldIgnored(String worldName) {
        boolean contains = this.worlds.contains(worldName.toLowerCase());
        return this.whitelist ? !contains : contains;
    }

    public boolean useGamemode() {
        return this.useGamemode;
    }

    public boolean shouldAutoSaveConsoleMessage() {
        return this.autoSaveConsoleMessage;
    }

    public boolean canSitting() {
        return this.canSit;
    }

    public boolean creativeInteract() {
        return this.creativeInteract;
    }

    public boolean creativePlace() {
        return this.creativePlace;
    }

    public boolean haveRegionMemberAccess() {
        return this.useRegionMemberAccess;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public boolean isAutoPurge() {
        return this.autoPurge;
    }

    public boolean isPurgeRemove() {
        return this.removePurge;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isParticleEnable() {
        return this.useParticle;
    }

    public boolean isSpamPlace() {
        return this.spamPlace;
    }

    public boolean isSpamBreak() {
        return this.spamBreak;
    }

    public boolean isRotateOnSitEnable() {
        return this.rotateOnSit;
    }

    public LanguageManager getLangManager() {
        return this.lmanager;
    }

    public int getPurgeTime() {
        return this.purgeTime;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getLimitGlobal() {
        return this.limitGlobal;
    }

    public long getBreakTime() {
        return this.spamBreakTime;
    }

    public long getPlaceTime() {
        return this.spamPlaceTime;
    }

    private void debug(String text) {
        FurnitureLib.debug(text);
    }

    public boolean isSync() {
        return this.sync;
    }

    private FileConfiguration getConfig() {
        return FurnitureLib.getInstance().getConfig();
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    private void loadIgnore() {
        File file = new File(FurnitureLib.getInstance().getDataFolder(), "ignoredPlayers.yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        if (configuration.isSet("ignoreList")) {
            configuration.getStringList("ignoreList").forEach(letter -> this.instance.getFurnitureManager().getIgnoreList().add(UUID.fromString(letter)));
        }
    }

    public long getPurgeTimeDays() {
        return this.purgeTimeMS;
    }

    public Type.EventType getDefaultEventType() {
        return this.type;
    }

    public Type.PublicMode getDefaultPublicType() {
        return this.mode;
    }

    public static FurnitureConfig getFurnitureConfig() {
        return furnitureConfig;
    }

    public LimitationManager getLimitManager() {
        return this.limitManager;
    }

    public boolean isRenderPacketMethode() {
        return this.packetRenderMethode;
    }

    public boolean isHideBedrockPlayers() {
        return this.hideBedrockPlayers;
    }

    public boolean isAutoFileUpdater() {
        return this.autoFileUpdater;
    }

    public String getDatabaseString() {
        return this.databaseTableString;
    }

    public Type.DataBaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean isImportCheck() {
        return this.importCheck;
    }

    public void setFileUpdater(boolean bool) {
        this.autoFileUpdater = bool;
        if (this.isNewVersion()) {
            this.getConfig().set("storage-options.auto_convert", (Object)bool);
        } else {
            this.getConfig().set("config.fileConverter.auto_mode", (Object)bool);
        }
    }

    public int getSaveIntervall() {
        return this.saveIntervall;
    }

    public void sendDatabaseLog(CommandSender sender, String string) {
        this.sendDatabaseLog(null, string, false);
    }

    public void sendDatabaseLog(CommandSender sender, String string, boolean force) {
        if (force) {
            sender.sendMessage(string);
        } else {
            this.databaseOutput.accept(sender, string);
        }
    }
}

