/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.main;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.Ste3et_C0st.FurnitureLib.Database.Database;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.Limitation;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SkullMetaPatcher;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.LightAPI.iLightAPI;
import de.Ste3et_C0st.FurnitureLib.main.LightManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DumpHandler {
    private static long latestDump = 0L;
    private static final long time = 60000L;

    public DumpHandler(CommandSender sender) {
        long dif;
        if (BlockCommandSender.class.isInstance(sender)) {
            sender.sendMessage("You can't create dump from command blocks !");
            return;
        }
        if (latestDump > 0L && (dif = System.currentTimeMillis() - latestDump) < 60000L) {
            sender.sendMessage("\u00a7cYou can't upload the furniture dump yet");
            sender.sendMessage("\u00a7cPlease wait \u00a7e" + (60000L - dif) / 1000L + " \u00a7csecounds.");
            return;
        }
        JsonObject coreObject = new JsonObject();
        JsonObject spigotObject = new JsonObject();
        spigotObject.addProperty("serverVersion", Bukkit.getVersion());
        spigotObject.addProperty("platformName", Bukkit.getServer().getName());
        spigotObject.addProperty("platformVersion", Type.version);
        spigotObject.addProperty("javaVersion", System.getProperty("java.version"));
        spigotObject.addProperty("operatingSystem", System.getProperty("os.name"));
        AtomicInteger armorStands = new AtomicInteger(0);
        Predicate<ObjectID> filter = entry -> Objects.nonNull(entry) && Type.SQLAction.REMOVE != entry.getSQLAction();
        FurnitureManager.getInstance().getObjectList().stream().filter(filter).forEach(obj -> armorStands.addAndGet(obj.getPacketList().size()));
        JsonObject packetInfos = new JsonObject();
        packetInfos.addProperty("pluginVersion", FurnitureLib.getInstance().getDescription().getVersion());
        packetInfos.addProperty("furnitureModels", (Number)FurnitureManager.getInstance().getProjects().size());
        packetInfos.addProperty("furnitureObjects", (Number)FurnitureManager.getInstance().getObjectList().size());
        packetInfos.addProperty("entities", "" + armorStands.get());
        packetInfos.addProperty("viewDistanceFurniture", (Number)FurnitureConfig.getFurnitureConfig().getViewDistance());
        packetInfos.addProperty("viewDistanceServer", (Number)Bukkit.getServer().getViewDistance());
        packetInfos.addProperty("syncLoading", Boolean.valueOf(FurnitureConfig.getFurnitureConfig().isSync()));
        packetInfos.addProperty("PacketRenderMethod", Boolean.valueOf(FurnitureConfig.getFurnitureConfig().isRenderPacketMethode()));
        packetInfos.addProperty("purgeTime", (Number)FurnitureConfig.getFurnitureConfig().getPurgeTime());
        packetInfos.addProperty("autoPure", Boolean.valueOf(FurnitureConfig.getFurnitureConfig().isAutoPurge()));
        packetInfos.addProperty("useGamemode", Boolean.valueOf(FurnitureConfig.getFurnitureConfig().useGamemode()));
        packetInfos.addProperty("language", LanguageManager.getInstance().getLanguage());
        packetInfos.addProperty("limitConfig", FurnitureConfig.getFurnitureConfig().getLimitManager().getTypes().stream().map(Limitation::getEnum).map(Enum::toString).collect(Collectors.joining(",")));
        packetInfos.addProperty("regionMemberAccess", Boolean.valueOf(FurnitureConfig.getFurnitureConfig().haveRegionMemberAccess()));
        packetInfos.addProperty("eventType", FurnitureConfig.getFurnitureConfig().getDefaultEventType().name());
        packetInfos.addProperty("publicType", FurnitureConfig.getFurnitureConfig().getDefaultPublicType().name());
        packetInfos.addProperty("databaseType", FurnitureLib.getInstance().getSQLManager().getDatabase().getType().name());
        packetInfos.addProperty("protectionLib-hook", Boolean.valueOf(FurnitureLib.getInstance().getPermManager().useProtectionLib()));
        packetInfos.addProperty("skullPatcher", Boolean.valueOf(SkullMetaPatcher.shouldPatch()));
        LightManager manager = FurnitureLib.getInstance().getLightManager();
        if (Objects.nonNull(manager)) {
            iLightAPI lightAPI = manager.getLightAPI();
            if (Objects.nonNull(lightAPI)) {
                packetInfos.addProperty("lightAPI-hook", Boolean.valueOf(true));
                packetInfos.addProperty("lightAPI-Interface", lightAPI.getClass().getSimpleName());
            } else {
                packetInfos.addProperty("lightAPI-hook", Boolean.valueOf(false));
            }
        }
        JsonObject packetInformations = new JsonObject();
        try {
            Type.ProtocolFields projectFields = FurnitureLib.getInstance().getField();
            packetInformations.addProperty("bitMask", (Number)projectFields.bitMask);
            packetInformations.addProperty("wrapperBit", (Number)projectFields.wrapperBit);
            packetInformations.addProperty("healthField", (Number)projectFields.healthField);
            packetInformations.addProperty("headRotation", (Number)projectFields.HeadRotation);
            packetInformations.addProperty("bodyRotation", (Number)projectFields.BodyRotation);
            packetInformations.addProperty("leftArmRotation", (Number)projectFields.LeftArmRotation);
            packetInformations.addProperty("rightArmRotation", (Number)projectFields.RightArmRotation);
            packetInformations.addProperty("leftLegRotation", (Number)projectFields.LeftLegRotation);
            packetInformations.addProperty("rightLegRotation", (Number)projectFields.RightLegRotation);
            packetInformations.addProperty("field", projectFields.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonObject databaseInformations = new JsonObject();
        AtomicInteger openConnections = new AtomicInteger(0);
        AtomicInteger closedConnections = new AtomicInteger(0);
        Database.getConnections().stream().forEach(entry -> {
            try {
                if (entry.isClosed()) {
                    closedConnections.incrementAndGet();
                } else {
                    openConnections.incrementAndGet();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        databaseInformations.addProperty("OpenConnections", (Number)openConnections.get());
        databaseInformations.addProperty("ClosedConnections", (Number)closedConnections.get());
        ArrayList<JsonObject> pluginList = new ArrayList<JsonObject>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (plugin.getName().equalsIgnoreCase("FurnitureLib")) continue;
            JsonObject pluginInformation = new JsonObject();
            pluginInformation.addProperty("pluginName", plugin.getName());
            pluginInformation.addProperty("enabled", Boolean.valueOf(plugin.isEnabled()));
            pluginInformation.addProperty("version", plugin.getDescription().getVersion());
            pluginInformation.addProperty("mainClass", plugin.getDescription().getMain());
            pluginInformation.add("authors", new Gson().toJsonTree((Object)plugin.getDescription().getAuthors()));
            pluginList.add(pluginInformation);
        }
        JsonObject senderObject = new JsonObject();
        senderObject.addProperty("senderName", sender.getName());
        if (sender instanceof Player) {
            Player player = (Player)Player.class.cast(sender);
            senderObject.addProperty("uuid", player.getUniqueId().toString());
        }
        coreObject.add("server", (JsonElement)spigotObject);
        coreObject.add("furnitureLib", (JsonElement)packetInfos);
        coreObject.add("packets", (JsonElement)packetInformations);
        coreObject.add("databaseInformations", (JsonElement)databaseInformations);
        if (FurnitureLib.getInstance().getPermManager().useProtectionLib()) {
            coreObject.add("protectionLib", new Gson().toJsonTree(FurnitureLib.getInstance().getPermManager().getProtectionClazz()));
        }
        coreObject.add("sender", (JsonElement)senderObject);
        coreObject.add("plugins", new Gson().toJsonTree(pluginList));
        this.sendToHost(coreObject, sender);
    }

    private void sendToHost(JsonObject dump, CommandSender sender) {
        try {
            URL url = new URL("http://api.dicecraft.de/furniture/dump.php");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json; utf-8");
            con.setRequestProperty("Accept", "application/json");
            con.setDoOutput(true);
            try (OutputStream os = con.getOutputStream();){
                byte[] input = dump.toString().getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));){
                StringBuilder response = new StringBuilder();
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                if (Objects.nonNull(response)) {
                    latestDump = System.currentTimeMillis();
                    if (response.toString().equalsIgnoreCase("#insertException#")) {
                        sender.sendMessage("\u00a7cThe dump can't be handeld");
                    } else {
                        sender.sendMessage("\u00a77FurnitureLib dump file upload \u00a72\u00a7lSuccess");
                        if (sender instanceof Player) {
                            LanguageManager.sendChatMessage(sender, MiniMessage.miniMessage().deserialize("<gray>You can find it here: <yellow><click:open_url:'" + response.toString().replace("#URL:", "") + "'>Click</click>"));
                        } else {
                            response.toString().replace("#URL:", "");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

