/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.async;

import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ChunkData {
    private final int chunkX;
    private final int chunkZ;
    private String world;
    private boolean loaded = false;
    private final ReentrantLock lock = new ReentrantLock();

    public ChunkData(Chunk chunk) {
        this(chunk.getX(), chunk.getZ(), chunk.getWorld().getName());
    }

    public ChunkData(Location location) {
        this(location.getBlockX() >> 4, location.getBlockZ() >> 4, location.getWorld().getName());
    }

    public ChunkData(int x, int z, String world) {
        this.chunkX = x;
        this.chunkZ = z;
        this.world = world;
    }

    public ChunkData load(World world) {
        if (!this.loaded && !this.lock.isLocked()) {
            FurnitureLib.getInstance().getSQLManager().loadAsynchron(this, world).thenAccept(idList -> {
                if (!idList.isEmpty()) {
                    idList.forEach(obj -> {
                        try {
                            obj.setFinish();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        obj.setFinish();
                        obj.sendAll();
                    });
                    this.loaded = true;
                    FurnitureManager.getInstance().addObjectID((Collection<ObjectID>)idList);
                    this.lock.unlock();
                } else {
                    this.lock.unlock();
                }
            });
        }
        return this;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public String getWorld() {
        return this.world;
    }

    public boolean equals(Chunk c) {
        return c.getX() == this.getX() && c.getZ() == this.getZ() && this.world == c.getWorld().getName();
    }
}

