/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage;

import de.Ste3et_C0st.FurnitureLib.Utilitis.ItemStackBuilder;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.callbacks.CallbackGUI;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryManager;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerManageInventoryCombat
extends InventoryHandler {
    private int side = 0;
    private int maxPages = 0;
    private final int maxItems = 45;
    private final ItemStack filler = new ItemStackBuilder(Material.valueOf((String)"STAINED_GLASS_PANE")).setDurability((short)15).setName("\u00a7c").build();
    private final ObjectID objectID;
    private final InventoryManager.InventoryMode inventoryMode;

    public PlayerManageInventoryCombat(Player player, final ObjectID objectID, final InventoryManager.InventoryMode inventoryMode) {
        super(player, 54, PlayerManageInventoryCombat.getLangManager().getName(inventoryMode.getInvTitle()));
        this.inventoryMode = inventoryMode;
        this.objectID = objectID;
        this.maxPages = (int)Math.floor((double)Bukkit.getOnlinePlayers().stream().filter(p -> !p.getUniqueId().equals(objectID.getUUID())).count() / 45.0);
        this.update();
        this.open(this.getPlayer());
        super.onClick(new CallbackGUI(){

            @Override
            public void onResult(ItemStack stack, Integer slot) {
                if (this.getInventoryPos() == InventoryHandler.ClickedInventory.TOP) {
                    if (Objects.isNull(stack)) {
                        return;
                    }
                    if (stack.getType().equals((Object)Material.valueOf((String)"SKULL_ITEM"))) {
                        SkullMeta skull = (SkullMeta)stack.getItemMeta();
                        if (inventoryMode == InventoryManager.InventoryMode.SETOWNER) {
                            OfflinePlayer skullOwner = Bukkit.getOfflinePlayer((String)skull.getOwner());
                            objectID.setUUID(skullOwner.getUniqueId());
                        } else if (inventoryMode == InventoryManager.InventoryMode.ADDFRIEND) {
                            OfflinePlayer skullOwner = Bukkit.getOfflinePlayer((String)skull.getOwner());
                            objectID.addMember(skullOwner.getUniqueId());
                        } else if (inventoryMode == InventoryManager.InventoryMode.REMOVEFRIEND && skull.hasDisplayName()) {
                            String playerName = ChatColor.stripColor((String)skull.getDisplayName());
                            Optional<DiceOfflinePlayer> offlinePlayer = FurnitureLib.getInstance().getPlayerCache().getPlayer(playerName);
                            if (offlinePlayer.isPresent()) {
                                objectID.remMember(offlinePlayer.get().getUuid());
                            }
                        }
                        objectID.setSQLAction(Type.SQLAction.UPDATE);
                        PlayerManageInventoryCombat.this.update();
                    }
                }
            }
        });
    }

    public void update() {
        this.getInventory().clear();
        this.setContent();
        this.setButtons();
    }

    @Override
    public void setButtons() {
        super.addItemStack(47, this.getItemStack("PrevPage"));
        super.addItemStack(49, this.getItemStack("PageItem"));
        super.addItemStack(51, this.getItemStack("NextPage"));
        AtomicInteger slot = new AtomicInteger(0);
        int skipPlayer = this.side * 45;
        if (this.inventoryMode == InventoryManager.InventoryMode.SETOWNER) {
            Bukkit.getOnlinePlayers().stream().filter(player -> !this.getObjectID().getUUID().equals(player.getUniqueId())).sorted((k1, k2) -> k1.getName().compareTo(k2.getName())).skip(skipPlayer).forEach(player -> {
                ItemStack itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
                SkullMeta skull = (SkullMeta)itemStack.getItemMeta();
                skull.setOwner(player.getName());
                skull.setDisplayName(player.getName());
                itemStack.setItemMeta((ItemMeta)skull);
                this.addItemStack(slot.getAndIncrement(), itemStack);
            });
        } else if (this.inventoryMode == InventoryManager.InventoryMode.ADDFRIEND) {
            Bukkit.getOnlinePlayers().stream().filter(player -> !this.getObjectID().getUUID().equals(player.getUniqueId())).filter(player -> !this.getObjectID().getMemberList().contains(player.getUniqueId())).sorted((k1, k2) -> k1.getName().compareTo(k2.getName())).skip(skipPlayer).forEach(player -> {
                ItemStack itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
                SkullMeta skull = (SkullMeta)itemStack.getItemMeta();
                skull.setOwner(player.getName());
                skull.setDisplayName(player.getName());
                itemStack.setItemMeta((ItemMeta)skull);
                this.addItemStack(slot.getAndIncrement(), itemStack);
            });
        } else if (this.inventoryMode == InventoryManager.InventoryMode.REMOVEFRIEND) {
            this.getObjectID().getMemberList().stream().forEach(member -> {
                Optional<DiceOfflinePlayer> offlinePlayer = FurnitureLib.getInstance().getPlayerCache().getPlayer((UUID)member);
                if (offlinePlayer.isPresent()) {
                    ItemStack itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
                    SkullMeta skull = (SkullMeta)itemStack.getItemMeta();
                    skull.setDisplayName(offlinePlayer.get().getName());
                    itemStack.setItemMeta((ItemMeta)skull);
                    this.addItemStack(slot.getAndIncrement(), itemStack);
                }
            });
        }
    }

    @Override
    public void setContent() {
        for (int i = 0; i < this.getInventory().getSize(); ++i) {
            super.addItemStack(i, this.filler);
        }
    }

    public ItemStack getItemStack(String s) {
        ItemStackBuilder builder = new ItemStackBuilder(PlayerManageInventoryCombat.getLangManager().getMaterial(s)).setAmount(1).setName(PlayerManageInventoryCombat.getLangManager().getName(s).replace("#CURPAGE#", "" + (this.side + 1)).replace("#MAXPAGE#", "" + (this.maxPages + 1)));
        if (Objects.nonNull(PlayerManageInventoryCombat.getLangManager().getStringList(s))) {
            ArrayList<String> lore = new ArrayList<String>();
            PlayerManageInventoryCombat.getLangManager().getStringList(s).stream().forEach(entry -> {
                String string = entry.replaceAll("#OWNER#", this.getObjectID().getPlayerName());
                lore.add(string);
            });
            builder.setLore(lore);
        }
        return builder.build();
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }
}

