/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage;

import de.Ste3et_C0st.FurnitureLib.Utilitis.ItemStackBuilder;
import de.Ste3et_C0st.FurnitureLib.Utilitis.callbacks.CallbackGUI;
import de.Ste3et_C0st.FurnitureLib.Utilitis.callbacks.CallbackGUIClose;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.PlayerManageInventoryAqua;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;

public class ManageInventoryAqua
extends InventoryHandler {
    private Type.PublicMode publicMode;
    private Type.EventType eventType;
    private final ObjectID objectID;
    private final ItemStack filler = new ItemStackBuilder(Material.BLACK_STAINED_GLASS_PANE).setName("\u00a7c").build();
    private int enumCounterPublicMode;
    private int enumCounterEventType;

    public ManageInventoryAqua(Player player, final ObjectID objectID) {
        super(player, 27, ManageInventoryAqua.getLangManager().getName("manageInvName"));
        this.objectID = objectID;
        this.publicMode = this.getObjectID().getPublicMode();
        this.eventType = this.getObjectID().getEventType();
        this.enumCounterEventType = this.eventType.ordinal();
        this.enumCounterPublicMode = this.publicMode.ordinal();
        super.onClick(new CallbackGUI(){

            @Override
            public void onResult(ItemStack stack, Integer slot) {
                if (Objects.isNull(stack)) {
                    return;
                }
                if (stack.equals((Object)ManageInventoryAqua.this.filler)) {
                    return;
                }
                if (this.getInventoryPos() == InventoryHandler.ClickedInventory.TOP) {
                    ManageInventoryAqua.this.getPlayer().playSound(ManageInventoryAqua.this.getPlayer().getLocation(), Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
                    if (this.getAction().equals((Object)InventoryAction.PICKUP_ALL)) {
                        if (slot == 10) {
                            ManageInventoryAqua.this.enumCounterPublicMode = ManageInventoryAqua.this.enumCounterPublicMode < Type.PublicMode.values().length - 1 ? ++ManageInventoryAqua.this.enumCounterPublicMode : 0;
                            ManageInventoryAqua.this.publicMode = Type.PublicMode.values()[ManageInventoryAqua.this.enumCounterPublicMode];
                        } else if (slot == 11) {
                            ManageInventoryAqua.this.enumCounterEventType = ManageInventoryAqua.this.enumCounterEventType < Type.EventType.values().length - 1 ? ++ManageInventoryAqua.this.enumCounterEventType : 1;
                            ManageInventoryAqua.this.eventType = Type.EventType.values()[ManageInventoryAqua.this.enumCounterEventType];
                        }
                        ManageInventoryAqua.this.setButtons();
                        ManageInventoryAqua.this.getPlayer().updateInventory();
                    } else if (this.getAction().equals((Object)InventoryAction.PICKUP_HALF)) {
                        if (slot == 10) {
                            ManageInventoryAqua.this.enumCounterPublicMode = ManageInventoryAqua.this.enumCounterPublicMode > 0 ? --ManageInventoryAqua.this.enumCounterPublicMode : Type.PublicMode.values().length - 1;
                            ManageInventoryAqua.this.publicMode = Type.PublicMode.values()[ManageInventoryAqua.this.enumCounterPublicMode];
                        } else if (slot == 11) {
                            ManageInventoryAqua.this.enumCounterEventType = ManageInventoryAqua.this.enumCounterEventType > 1 ? --ManageInventoryAqua.this.enumCounterEventType : Type.EventType.values().length - 1;
                            ManageInventoryAqua.this.eventType = Type.EventType.values()[ManageInventoryAqua.this.enumCounterEventType];
                        }
                        ManageInventoryAqua.this.setButtons();
                        ManageInventoryAqua.this.getPlayer().updateInventory();
                    }
                    if (slot == 12) {
                        new PlayerManageInventoryAqua(ManageInventoryAqua.this.getPlayer(), ManageInventoryAqua.this.getObjectID(), InventoryManager.InventoryMode.SETOWNER);
                    } else if (slot == 14) {
                        new PlayerManageInventoryAqua(ManageInventoryAqua.this.getPlayer(), ManageInventoryAqua.this.getObjectID(), InventoryManager.InventoryMode.ADDFRIEND);
                    } else if (slot == 16) {
                        new PlayerManageInventoryAqua(ManageInventoryAqua.this.getPlayer(), ManageInventoryAqua.this.getObjectID(), InventoryManager.InventoryMode.REMOVEFRIEND);
                    }
                }
            }
        });
        this.update();
        this.open(this.getPlayer());
        super.onClose(new CallbackGUIClose(){

            @Override
            public void onResult(InventoryHandler gui) {
                objectID.setEventTypeAccess(ManageInventoryAqua.this.eventType);
                objectID.setPublicMode(ManageInventoryAqua.this.publicMode);
                objectID.setSQLAction(Type.SQLAction.UPDATE);
            }
        });
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }

    public void update() {
        this.setContent();
        this.setButtons();
    }

    @Override
    public void setButtons() {
        super.addItemStack(10, this.publicMode.getItemStack());
        super.addItemStack(11, this.eventType.getItemStack());
        if (FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)this.getPlayer(), "furniture.setOwner") || FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)this.getPlayer(), "furniture.admin")) {
            super.addItemStack(12, this.getItemStack("setOwner"));
        }
        super.addItemStack(14, this.getItemStack("add"));
        super.addItemStack(16, this.getItemStack("remove"));
    }

    @Override
    public void setContent() {
        for (int i = 0; i < this.getInventory().getSize(); ++i) {
            super.addItemStack(i, this.filler);
        }
    }

    public ItemStack getItemStack(String s) {
        ItemStackBuilder builder = new ItemStackBuilder(ManageInventoryAqua.getLangManager().getMaterial(s)).setAmount(1).setName(ManageInventoryAqua.getLangManager().getName(s));
        if (Objects.nonNull(ManageInventoryAqua.getLangManager().getStringList(s))) {
            ArrayList<String> lore = new ArrayList<String>();
            ManageInventoryAqua.getLangManager().getStringList(s).stream().forEach(entry -> lore.add(entry.replaceAll("#OWNER#", this.getObjectID().getPlayerName())));
            builder.setLore(lore);
        }
        return builder.build();
    }
}

