/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage;

import de.Ste3et_C0st.FurnitureLib.Utilitis.ItemStackBuilder;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.UUIDTagType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class GuiButton {
    public static final NamespacedKey KEY_UUID = new NamespacedKey((Plugin)JavaPlugin.getProvidingPlugin(GuiButton.class), "IF-uuid");
    private Consumer<InventoryClickEvent> action;
    private boolean visible = true;
    private UUID uuid = UUID.randomUUID();
    private List<Object> properties;
    private ItemStack item = new ItemStack(Material.AIR);

    public GuiButton(ItemStackBuilder builder, Consumer<InventoryClickEvent> action) {
        this(builder.build(), action);
    }

    public GuiButton(ItemStack item, Consumer<InventoryClickEvent> action) {
        this.action = action;
        this.setVisible(true);
        this.properties = new ArrayList<Object>();
        this.setItem(item);
    }

    public GuiButton copy() {
        GuiButton guiItem = new GuiButton(this.item.clone(), this.action);
        guiItem.visible = this.visible;
        guiItem.uuid = this.uuid;
        guiItem.properties = new ArrayList<Object>(this.properties);
        ItemMeta meta = guiItem.item.getItemMeta();
        if (meta == null) {
            throw new IllegalArgumentException("item must be able to have ItemMeta (it mustn't be AIR)");
        }
        meta.getPersistentDataContainer().set(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)guiItem.uuid);
        guiItem.item.setItemMeta(meta);
        return guiItem;
    }

    public void callAction(InventoryClickEvent event) {
        if (this.action == null) {
            return;
        }
        try {
            this.action.accept((Object)event);
        }
        catch (Throwable t) {
            Logger logger = JavaPlugin.getProvidingPlugin(this.getClass()).getLogger();
            logger.log(Level.SEVERE, "Exception while handling click event in inventory '" + event.getView().getTitle() + "', slot=" + event.getSlot() + ", item=" + String.valueOf(this.item.getType()), t);
        }
    }

    public void setAction(Consumer<InventoryClickEvent> action) {
        this.action = action;
    }

    public List<Object> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Object> properties) {
        this.properties = properties;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)this.uuid);
            item.setItemMeta(meta);
        }
        this.item = item;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isStack(ItemStack stack) {
        ItemMeta meta;
        if (stack.hasItemMeta() && (meta = stack.getItemMeta()).getPersistentDataContainer().has(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE)) {
            return ((UUID)meta.getPersistentDataContainer().get(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE)).equals(this.getUUID());
        }
        return false;
    }
}

