/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis.inventory;

import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.InventoryHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.ManageInventoryAqua;
import de.Ste3et_C0st.FurnitureLib.Utilitis.inventory.manage.ManageInventoryCombat;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Objects;

public class InventoryManager {
    private HashMap<String, Class<? extends InventoryHandler>> inventoryMap = new HashMap();

    public InventoryManager() {
        this.inventoryMap.put("manage", FurnitureLib.isNewVersion() ? ManageInventoryAqua.class : ManageInventoryCombat.class);
    }

    public Class<? extends InventoryHandler> getInventory(String key) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.inventoryMap.getOrDefault(key.toLowerCase(), null);
    }

    public boolean isInventoryPresent(String key) {
        return this.getInventory(key) != null;
    }

    public InventoryHandler openInventory(String key, Object ... objects) {
        Class<? extends InventoryHandler> inventoryClazz = this.getInventory(key);
        try {
            Constructor<?> constructor;
            if (Objects.nonNull(inventoryClazz) && Objects.nonNull(constructor = inventoryClazz.getConstructors()[0])) {
                Object returnValue = constructor.newInstance(objects);
                return Objects.nonNull(returnValue) ? (InventoryHandler)InventoryHandler.class.cast(returnValue) : null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum InventoryMode {
        ADDFRIEND("playerAddInvName"),
        REMOVEFRIEND("playerRemoveInvName"),
        SETOWNER("playerSetInvName");

        String titleName;

        private InventoryMode(String titleName) {
            this.titleName = titleName;
        }

        public String getInvTitle() {
            return this.titleName;
        }
    }
}

