/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis.cache;

import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class OfflinePlayerCache {
    private HashMap<UUID, DiceOfflinePlayer> offlinePlayerCache = new HashMap();
    private Function<UUID, OfflinePlayer> offlinePlayerFunction = uuid -> {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        return player != null && player.hasPlayedBefore() ? player : null;
    };

    public boolean contains(UUID uuid) {
        return this.offlinePlayerCache.containsKey(uuid);
    }

    public void addPlayer(OfflinePlayer offlinePlayer) {
        if (!this.contains(offlinePlayer.getUniqueId())) {
            this.offlinePlayerCache.put(offlinePlayer.getUniqueId(), new DiceOfflinePlayer(offlinePlayer));
        }
    }

    public Optional<DiceOfflinePlayer> getPlayer(UUID uuid) {
        if (this.contains(uuid)) {
            return Optional.of(this.offlinePlayerCache.get(uuid));
        }
        OfflinePlayer player = this.offlinePlayerFunction.apply(uuid);
        if (player != null) {
            DiceOfflinePlayer offlinePlayer = new DiceOfflinePlayer(player);
            this.offlinePlayerCache.put(uuid, offlinePlayer);
            return Optional.ofNullable(offlinePlayer);
        }
        return Optional.empty();
    }

    public Optional<DiceOfflinePlayer> getPlayer(String userName) {
        return this.offlinePlayerCache.values().stream().filter(entry -> entry.getName().equalsIgnoreCase(userName)).findFirst();
    }
}

