/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.Component;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTranslator {
    private String key;
    private String value;
    private Component component;
    private static final Pattern VARIABLE_PATTERN_OLD = Pattern.compile("#[a-zA-Z0-9_]+#", 2);
    private static final Pattern VARIABLE_PATTERN_NEW = Pattern.compile("<[a-zA-Z0-9_]+>", 2);

    public StringTranslator(String key, String value) {
        this.key = key.toLowerCase().replaceFirst("#", "").replace("#", "");
        this.value = LanguageManager.serializeLegacyColors(value);
    }

    public StringTranslator(String key, Component component) {
        this.key = key.toLowerCase().replaceFirst("#", "").replace("#", "");
        this.component = component;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static Pattern getOldPattern() {
        return VARIABLE_PATTERN_OLD;
    }

    public static Pattern getNewPattern() {
        return VARIABLE_PATTERN_NEW;
    }

    public String oldKey() {
        return "#" + this.key + "#";
    }

    public String newKey() {
        return "<" + this.key + ">";
    }

    public static String transfareVariable(String name) {
        String copyString = name;
        Matcher matcher = VARIABLE_PATTERN_OLD.matcher(name);
        while (matcher.find()) {
            String match = matcher.group();
            String replace = match.toLowerCase().replaceFirst("#", "<").replace("#", ">").toLowerCase();
            copyString = copyString.replace(match, replace);
        }
        return copyString;
    }

    public TagResolver getPlaceHolder() {
        return Placeholder.component(this.key, this.getComponent());
    }

    public Component getComponent() {
        return Objects.nonNull(this.component) ? this.component : MiniMessage.miniMessage().deserialize(this.value);
    }
}

