/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullMetaPatcher {
    private static boolean needPatcher = FurnitureLib.isVersionOrAbove("1.20.4") ? true : !FurnitureLib.isPaper();

    public static ItemStack patchStack(ItemStack stack) {
        if (!needPatcher) {
            return stack;
        }
        if (Objects.isNull(stack)) {
            return stack;
        }
        if (stack.getItemMeta() instanceof SkullMeta) {
            try {
                Object craftBukkitMeta = MinecraftReflection.getCraftBukkitClass((String)"inventory.CraftMetaSkull").cast(stack.getItemMeta());
                Field profileField = MinecraftReflection.getCraftBukkitClass((String)"inventory.CraftMetaSkull").getDeclaredField("profile");
                profileField.setAccessible(true);
                Object savedObject = profileField.get(craftBukkitMeta);
                WrappedGameProfile wrappedGameProfile = WrappedGameProfile.fromHandle((Object)savedObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    public static ItemStack patch(ItemStack stack, NBTTagCompound compound) {
        NBTTagCompound propertiesCompound;
        NBTTagCompound skullCompound;
        NBTTagCompound tagCompound;
        if (needPatcher && compound.hasKeyOfType("tag", 10) && (tagCompound = compound.getCompound("tag")).hasKeyOfType("SkullOwner", 10) && (skullCompound = tagCompound.getCompound("SkullOwner")).hasKeyOfType("Properties", 10) && (propertiesCompound = skullCompound.getCompound("Properties")).hasKeyOfType("textures", 9)) {
            NBTTagList textureCompound = propertiesCompound.getList("textures");
            NBTTagCompound texturestring = textureCompound.get(0);
            String base64String = texturestring.getString("Value");
            WrappedGameProfile gameProfile = SkullMetaPatcher.makeProfile(base64String);
            SkullMetaPatcher.patch(stack, gameProfile);
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack patch(ItemStack stack, WrappedGameProfile gameProfile) {
        ItemMeta headMeta = stack.getItemMeta();
        try {
            Field field = headMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            if (field.getType().getSimpleName().contains("ResolvableProfile")) {
                if (FurnitureLib.isVersionOrAbove("1.21.9")) {
                    Object object = Class.forName("net.minecraft.world.item.component.ResolvableProfile").getDeclaredMethod("a", gameProfile.getHandleType()).invoke(null, gameProfile.getHandle());
                    field.set(headMeta, object);
                } else {
                    Object object = Class.forName("net.minecraft.world.item.component.ResolvableProfile").getConstructor(gameProfile.getHandleType()).newInstance(gameProfile.getHandle());
                    field.set(headMeta, object);
                }
            } else {
                field.set(headMeta, gameProfile.getHandle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            stack.setItemMeta(headMeta);
        }
        return stack;
    }

    public static boolean shouldPatch() {
        return needPatcher;
    }

    public static WrappedGameProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        WrappedGameProfile profile = new WrappedGameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new WrappedSignedProperty("textures", b64, "furniture"));
        return profile;
    }

    public static ItemStack createStack(String b64) {
        ItemStack stack = new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        SkullMetaPatcher.patch(stack, SkullMetaPatcher.makeProfile(b64));
        return stack;
    }
}

