/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularInterface;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Task;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class SchedularHelper
implements SchedularInterface {
    private static Optional<SchedularInterface> folia = Optional.empty();

    @Override
    public Task newTask(Runnable runnable, boolean sync) {
        if (FurnitureLib.isFolia()) {
            if (folia.isPresent()) {
                return folia.get().newTask(runnable, sync);
            }
            return null;
        }
        if (sync) {
            return Task.wrapBukkitTask(Bukkit.getScheduler().runTask((Plugin)FurnitureLib.getInstance(), runnable));
        }
        return Task.wrapBukkitTask(Bukkit.getScheduler().runTaskAsynchronously((Plugin)FurnitureLib.getInstance(), runnable));
    }

    @Override
    public Task newTimer(Runnable runnable, int ticks, int delayed, boolean sync) {
        if (FurnitureLib.isFolia()) {
            if (folia.isPresent()) {
                return folia.get().newTimer(runnable, ticks, delayed, sync);
            }
            return null;
        }
        if (sync) {
            return Task.wrapBukkitTask(Bukkit.getScheduler().runTaskTimer((Plugin)FurnitureLib.getInstance(), runnable, (long)delayed, (long)ticks));
        }
        return Task.wrapBukkitTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)FurnitureLib.getInstance(), runnable, (long)delayed, (long)ticks));
    }

    @Override
    public Task newLater(Runnable runnable, int ticks, boolean sync) {
        if (FurnitureLib.isFolia()) {
            if (folia.isPresent()) {
                return folia.get().newLater(runnable, ticks, sync);
            }
            return null;
        }
        if (sync) {
            return Task.wrapBukkitTask(Bukkit.getScheduler().runTaskLater((Plugin)FurnitureLib.getInstance(), runnable, (long)ticks));
        }
        return Task.wrapBukkitTask(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)FurnitureLib.getInstance(), runnable, (long)ticks));
    }

    @Override
    public Task newRegionTask(Runnable runbable, Location location, boolean sync) {
        if (FurnitureLib.isFolia()) {
            if (folia.isPresent()) {
                return folia.get().newRegionTask(runbable, location, sync);
            }
            return null;
        }
        return Task.wrapBukkitTask(Bukkit.getScheduler().runTask((Plugin)FurnitureLib.getInstance(), runbable));
    }

    public static Task runAsync(Runnable runnable) {
        return new SchedularHelper().newTask(runnable, false);
    }

    public static Task runTask(Runnable runnable, boolean sync) {
        return new SchedularHelper().newTask(runnable, sync);
    }

    public static Task runTimer(Runnable runnable, int ticks, int delayed, boolean sync) {
        return new SchedularHelper().newTimer(runnable, ticks, delayed, sync);
    }

    public static Task runLater(Runnable runnable, int ticks, boolean sync) {
        return new SchedularHelper().newLater(runnable, ticks, sync);
    }

    public static Task regionTask(Runnable runbable, Location location, boolean sync) {
        return new SchedularHelper().newRegionTask(runbable, location, sync);
    }

    static {
        if (FurnitureLib.isFolia()) {
            try {
                Class<?> foliaSchedulerClazz = Class.forName("de.Ste3et_C0st.FurnitureLib.Folia.FoliaScheduler");
                folia = Optional.ofNullable((SchedularInterface)foliaSchedulerClazz.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            folia = Optional.empty();
        }
    }
}

