/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class Relative {
    private final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private BlockFace face;
    private Location firstLocation;
    private Location secondLocation;

    public Relative(Location loc, double offsetX, double offsetY, double offsetZ, BlockFace face) {
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setOffsetZ(offsetZ);
        this.setFace(face);
        this.setFirstLocation(loc);
        this.setSecondLocation(this.getRelative(this.getFirstLocation(), this.getFace(), this.getOffsetX(), this.getOffsetZ()).add(0.0, this.getOffsetY(), 0.0));
    }

    public Relative(Location loc, Location loc2) {
        Vector v1 = loc.toVector();
        Vector v2 = loc2.toVector();
        this.setOffsetX(v1.getX() - v2.getX());
        this.setOffsetY(v1.getY() - v2.getY());
        this.setOffsetZ(v1.getZ() - v2.getZ());
        this.setFirstLocation(loc);
        this.setFace(this.yawToFace(loc.getYaw()));
        this.setSecondLocation(loc2);
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }

    public void setOffsetZ(double offsetZ) {
        this.offsetZ = offsetZ;
    }

    public BlockFace getFace() {
        return this.face;
    }

    public void setFace(BlockFace face) {
        this.face = face;
    }

    public Location getFirstLocation() {
        return this.firstLocation;
    }

    public void setFirstLocation(Location firstLocation) {
        this.firstLocation = firstLocation;
    }

    public Location getSecondLocation() {
        return this.secondLocation;
    }

    private void setSecondLocation(Location secondLocation) {
        this.secondLocation = secondLocation;
    }

    public BlockFace yawToFaceRadial(float yaw) {
        return this.radial[Math.round(yaw / 45.0f) & 7];
    }

    public BlockFace yawToFace(float yaw) {
        return this.axis[Math.round(yaw / 90.0f) & 3];
    }

    public BlockFace yawToFace(float yaw, float pitch) {
        if (pitch < -80.0f) {
            return BlockFace.UP;
        }
        if (pitch > 80.0f) {
            return BlockFace.DOWN;
        }
        return this.axis[Math.round(yaw / 90.0f) & 3];
    }

    public int FaceToYaw(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_EAST: {
                return 45;
            }
            case EAST: {
                return 90;
            }
            case SOUTH_EAST: {
                return 135;
            }
            case SOUTH: {
                return 180;
            }
            case SOUTH_WEST: {
                return 225;
            }
            case WEST: {
                return 270;
            }
            case NORTH_WEST: {
                return 315;
            }
        }
        return 0;
    }

    private Location getRelative(Location loc, BlockFace b, double z, double x) {
        Location l = loc.clone();
        l.setYaw((float)this.FaceToYaw(b));
        switch (b) {
            case NORTH: {
                l.add(x, 0.0, z);
                break;
            }
            case SOUTH: {
                l.add(-x, 0.0, -z);
                break;
            }
            case WEST: {
                l.add(z, 0.0, -x);
                break;
            }
            case EAST: {
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_EAST: {
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_NORTH_EAST: {
                l.add(x, 0.0, z);
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_NORTH_WEST: {
                l.add(x, 0.0, z);
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case NORTH_WEST: {
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case EAST_NORTH_EAST: {
                l.add(-z, 0.0, x);
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case EAST_SOUTH_EAST: {
                l.add(-z, 0.0, x);
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_EAST: {
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_SOUTH_EAST: {
                l.add(-x, 0.0, -z);
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_SOUTH_WEST: {
                l.add(-x, 0.0, -z);
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case SOUTH_WEST: {
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case WEST_NORTH_WEST: {
                l.add(z, 0.0, -x);
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case WEST_SOUTH_WEST: {
                l.add(z, 0.0, -x);
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case DOWN: {
                l.add(0.0, -z, 0.0);
                break;
            }
            case UP: {
                l.add(0.0, z, 0.0);
            }
            default: {
                l.add(x, 0.0, z);
            }
        }
        return l;
    }
}

