/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import com.comphenix.protocol.utility.MinecraftVersion;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.util.EulerAngle;

public class LocationUtil {
    public static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    public static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    public static List<BlockFace> axisList = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    private static Particle restoneParticle = FurnitureLib.getVersion(new MinecraftVersion("1.20.5")) ? Particle.valueOf((String)"DUST") : Particle.valueOf((String)"REDSTONE");

    public static void particleBlock(Block b) {
        LocationUtil.particleBlock(b, restoneParticle, 1.0f);
    }

    public static void particleBlock(Block b, Particle particleData, float value) {
        if (!FurnitureConfig.getFurnitureConfig().isParticleEnable()) {
            return;
        }
        try {
            Location loc = b.getLocation();
            World world = loc.getWorld();
            for (double x = 0.0; x < 1.0; x += 0.3) {
                for (double y = 0.0; y < 1.0; y += 0.3) {
                    for (double z = 0.0; z < 1.0; z += 0.3) {
                        Location location = loc.clone();
                        location = location.add(x, y, z);
                        if (FurnitureLib.getVersionInt() > 12) {
                            world.spawnParticle(particleData, location, 1, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                            continue;
                        }
                        world.spawnParticle(particleData, location, 1);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static double getRelativeCoord(int i) {
        double d = i;
        d = d < 0.0 ? (d += 0.5) : (d += 0.5);
        return d;
    }

    public short getFromDey(short s) {
        return (short)(15 - s);
    }

    public static BlockFace yawToFaceRadial(float yaw) {
        return radial[Math.round(yaw / 45.0f) & 7];
    }

    public static BlockFace yawToFace(float yaw) {
        return axis[Math.round(yaw / 90.0f) & 3];
    }

    public static BlockFace yawToFace(float yaw, float pitch) {
        if (pitch < -80.0f) {
            return BlockFace.UP;
        }
        if (pitch > 80.0f) {
            return BlockFace.DOWN;
        }
        return axis[Math.round(yaw / 90.0f) & 3];
    }

    public EulerAngle degresstoRad(EulerAngle degressAngle) {
        return new EulerAngle(degressAngle.getX() * Math.PI / 180.0, degressAngle.getY() * Math.PI / 180.0, degressAngle.getZ() * Math.PI / 180.0);
    }

    public EulerAngle Radtodegress(EulerAngle degressAngle) {
        return new EulerAngle(degressAngle.getX() * 180.0 / Math.PI, degressAngle.getY() * 180.0 / Math.PI, degressAngle.getZ() * 180.0 / Math.PI);
    }

    public int FaceToYaw(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_EAST: {
                return 45;
            }
            case EAST: {
                return 90;
            }
            case SOUTH_EAST: {
                return 135;
            }
            case SOUTH: {
                return 180;
            }
            case SOUTH_WEST: {
                return 225;
            }
            case WEST: {
                return 270;
            }
            case NORTH_WEST: {
                return 315;
            }
        }
        return 0;
    }

    public boolean isDay(World w) {
        long time = w.getTime();
        return time > 0L && time < 12300L;
    }

    public BlockFace StringToFace(String face) {
        switch (face) {
            case "NORTH": {
                return BlockFace.NORTH;
            }
            case "EAST": {
                return BlockFace.EAST;
            }
            case "SOUTH": {
                return BlockFace.SOUTH;
            }
            case "WEST": {
                return BlockFace.WEST;
            }
            case "UP": {
                return BlockFace.UP;
            }
            case "DOWN": {
                return BlockFace.DOWN;
            }
            case "NORTH_NORTH_EAST": {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case "NORTH_NORTH_WEST": {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case "NORTH_WEST": {
                return BlockFace.NORTH_WEST;
            }
            case "EAST_NORTH_EAST": {
                return BlockFace.EAST_NORTH_EAST;
            }
            case "EAST_SOUTH_EAST": {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case "SOUTH_EAST": {
                return BlockFace.SOUTH_EAST;
            }
            case "SOUTH_SOUTH_EAST": {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case "SOUTH_SOUTH_WEST": {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case "SOUTH_WEST": {
                return BlockFace.SOUTH_WEST;
            }
            case "WEST_NORTH_WEST": {
                return BlockFace.WEST_NORTH_WEST;
            }
            case "WEST_SOUTH_WEST": {
                return BlockFace.WEST_SOUTH_WEST;
            }
        }
        return BlockFace.NORTH;
    }

    public Block setSign(BlockFace face, Location l) {
        return this.setSign(face, l, Material.valueOf((String)(Type.version.equalsIgnoreCase("1.13") ? "SIGN" : "OAK_SIGN")));
    }

    public Block setSign(BlockFace face, Location l, Material material) {
        l.getBlock().setType(Material.AIR);
        l.getBlock().setType(material);
        Block block = l.getBlock();
        BlockState state = l.getBlock().getState();
        state.setRawData(this.getFacebyte(LocationUtil.yawToFace(this.FaceToYaw(face.getOppositeFace()) - 90)));
        state.update(false);
        return block;
    }

    public byte getFacebyte(BlockFace b) {
        switch (b) {
            case NORTH: {
                return 4;
            }
            case EAST: {
                return 2;
            }
            case SOUTH: {
                return 5;
            }
            case WEST: {
                return 3;
            }
        }
        return 5;
    }

    public Location setBed(BlockFace face, Location l, Material mat) {
        return l;
    }

    public Block setHalfBed(BlockFace face, Location l, Material mat) {
        return null;
    }

    private Double round(Double d) {
        BigDecimal b = new BigDecimal(d);
        b = b.setScale(2, 4);
        return b.doubleValue();
    }

    @Deprecated
    public Location getRelativ(Location loc, BlockFace b, double z, double x) {
        return this.getRelative(loc, b, z, x);
    }

    public Location getRelative(Location loc, BlockFace b, double z, double x) {
        Location l = loc.clone();
        l.setYaw((float)this.FaceToYaw(b));
        x = this.round(x);
        z = this.round(z);
        switch (b) {
            case NORTH: {
                l.add(x, 0.0, z);
                break;
            }
            case SOUTH: {
                l.add(-x, 0.0, -z);
                break;
            }
            case WEST: {
                l.add(z, 0.0, -x);
                break;
            }
            case EAST: {
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_EAST: {
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_NORTH_EAST: {
                l.add(x, 0.0, z);
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case NORTH_NORTH_WEST: {
                l.add(x, 0.0, z);
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case NORTH_WEST: {
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case EAST_NORTH_EAST: {
                l.add(-z, 0.0, x);
                l.add(x, 0.0, z);
                l.add(-z, 0.0, x);
                break;
            }
            case EAST_SOUTH_EAST: {
                l.add(-z, 0.0, x);
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_EAST: {
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_SOUTH_EAST: {
                l.add(-x, 0.0, -z);
                l.add(-x, 0.0, -z);
                l.add(-z, 0.0, x);
                break;
            }
            case SOUTH_SOUTH_WEST: {
                l.add(-x, 0.0, -z);
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case SOUTH_WEST: {
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case WEST_NORTH_WEST: {
                l.add(z, 0.0, -x);
                l.add(x, 0.0, z);
                l.add(z, 0.0, -x);
                break;
            }
            case WEST_SOUTH_WEST: {
                l.add(z, 0.0, -x);
                l.add(-x, 0.0, -z);
                l.add(z, 0.0, -x);
                break;
            }
            case DOWN: {
                l.add(0.0, -z, 0.0);
                break;
            }
            case UP: {
                l.add(0.0, z, 0.0);
            }
            default: {
                l.add(x, 0.0, z);
            }
        }
        return l;
    }

    public int randInt(int min, int max) {
        Random rand = new Random();
        return rand.nextInt(max - min + 1) + min;
    }

    public Location getCenter(Location loc) {
        return new Location(loc.getWorld(), LocationUtil.getRelativeCoord(loc.getBlockX()), LocationUtil.getRelativeCoord(loc.getBlockY()), LocationUtil.getRelativeCoord(loc.getBlockZ()));
    }

    @Deprecated
    public short getfromDyeColor(DyeColor c) {
        switch (c) {
            case BLACK: {
                return 0;
            }
            case BLUE: {
                return 4;
            }
            case BROWN: {
                return 3;
            }
            case CYAN: {
                return 6;
            }
            case GRAY: {
                return 8;
            }
            case LIGHT_GRAY: {
                return 7;
            }
            case WHITE: {
                return 15;
            }
            case GREEN: {
                return 2;
            }
            case LIGHT_BLUE: {
                return 12;
            }
            case LIME: {
                return 10;
            }
            case MAGENTA: {
                return 13;
            }
            case ORANGE: {
                return 14;
            }
            case PINK: {
                return 9;
            }
            case PURPLE: {
                return 5;
            }
            case RED: {
                return 1;
            }
            case YELLOW: {
                return 11;
            }
        }
        return 15;
    }
}

