/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.Component;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.MiniMessage;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import de.Ste3et_C0st.FurnitureLib.Paper.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.AdventureHandling;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.PlaceHolderHandling;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LanguageManager {
    private static LanguageManager instance;
    private String lang;
    private Plugin plugin;
    private HashMap<String, String> hash = new HashMap();
    private HashMap<String, List<String>> invHashList = new HashMap();
    private HashMap<String, Material> invMatList = new HashMap();
    private HashMap<String, String> invStringList = new HashMap();
    private HashMap<String, Short> invShortList = new HashMap();
    private AdventureHandling handling = null;
    private final PlaceHolderHandling placeholderAPI;
    public static final char COLOR_CHAR = '\u00a7';
    public static final Pattern STRIP_COLOR_PATTERN;

    public LanguageManager(Plugin plugin, String lang) {
        instance = this;
        this.lang = lang;
        this.plugin = plugin;
        this.loadLanguageConfig();
        if (FurnitureLib.isNewVersion()) {
            this.loadNewManageInv();
        } else {
            this.oldManageInv();
        }
        this.handling = new AdventureHandling(plugin);
        this.placeholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") ? new PlaceHolderHandling() : null;
    }

    public File getLangFolder() {
        File folder = new File(FurnitureLib.getInstance().getDataFolder(), "/language/");
        if (folder.exists() == Boolean.FALSE.booleanValue()) {
            folder.mkdirs();
        }
        return folder;
    }

    private void loadLanguageConfig() {
        try {
            if (this.lang == null || this.lang.isEmpty()) {
                this.lang = "EN_en";
            }
            String selectetLanguage = Objects.nonNull(this.plugin.getResource("language/" + this.lang + ".yml")) ? this.lang : "EN_en";
            File languageFile = new File(this.getLangFolder(), selectetLanguage + ".yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)languageFile);
            config.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)FurnitureLib.getInstance().loadStream("language/" + selectetLanguage + ".yml")));
            config.options().copyDefaults(true);
            config.options().copyHeader(true);
            config.getConfigurationSection("").getKeys(true).forEach(key -> {
                if (key.startsWith(".")) {
                    key = key.replaceFirst(".", "");
                }
                if (config.isString(key)) {
                    String value = config.getString(key);
                    this.hash.put(key.toLowerCase(), StringTranslator.transfareVariable(value));
                } else if (config.isList(key)) {
                    StringBuilder value = new StringBuilder();
                    List stringList = config.getStringList(key);
                    int end = stringList.size() - 1;
                    for (String a : stringList) {
                        if (stringList.indexOf(a) != end) {
                            value.append(StringTranslator.transfareVariable(a)).append("\n");
                            continue;
                        }
                        value.append(StringTranslator.transfareVariable(a));
                    }
                    this.hash.put(key.toLowerCase(), StringTranslator.transfareVariable(value.toString()));
                } else {
                    this.hash.put(key.toLowerCase(), key.toLowerCase() + " is Missing");
                }
            });
            config.save(languageFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private void loadNewManageInv() {
        try {
            File inventoryFile = new File(FurnitureLib.getInstance().getDataFolder(), "manageInv.yml");
            YamlConfiguration inventory = YamlConfiguration.loadConfiguration((File)inventoryFile);
            inventory.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)FurnitureLib.getInstance().loadStream("manageInv.yml")));
            inventory.options().copyDefaults(true);
            inventory.save(inventoryFile);
            for (String str : inventory.getConfigurationSection("inv.mode").getKeys(false)) {
                this.invHashList.put(str, inventory.getStringList("inv.mode." + str + ".Text"));
                this.invMatList.put(str, Material.valueOf((String)inventory.getString("inv.mode." + str + ".Material").toUpperCase()));
                this.invStringList.put(str, inventory.getString("inv.mode." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.mode." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.event").getKeys(false)) {
                this.invMatList.put(str, Material.valueOf((String)inventory.getString("inv.event." + str + ".Material").toUpperCase()));
                this.invStringList.put(str, inventory.getString("inv.event." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.event." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.player").getKeys(false)) {
                this.invMatList.put(str, Material.valueOf((String)inventory.getString("inv.player." + str + ".Material").toUpperCase()));
                this.invStringList.put(str, inventory.getString("inv.player." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.player." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.controller").getKeys(false)) {
                this.invMatList.put(str, Material.valueOf((String)inventory.getString("inv.controller." + str + ".Material").toUpperCase()));
                this.invStringList.put(str, inventory.getString("inv.controller." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.controller." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.admin").getKeys(false)) {
                this.invMatList.put(str, Material.valueOf((String)inventory.getString("inv.admin." + str + ".Material").toUpperCase()));
                this.invStringList.put(str, inventory.getString("inv.admin." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.admin." + str + ".SubID"));
                this.invHashList.put(str, inventory.getStringList("inv.admin." + str + ".Text"));
            }
            this.invStringList.put("manageInvName", inventory.getString("inv.manageInvName"));
            this.invStringList.put("playerAddInvName", inventory.getString("inv.playerAddInvName"));
            this.invStringList.put("playerRemoveInvName", inventory.getString("inv.playerRemoveInvName"));
            this.invStringList.put("playerSetInvName", inventory.getString("inv.playerSetInvName"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void oldManageInv() {
        try {
            File inventoryFile = new File(FurnitureLib.getInstance().getDataFolder(), "manageInv.yml");
            YamlConfiguration inventory = YamlConfiguration.loadConfiguration((File)inventoryFile);
            inventory.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)FurnitureLib.getInstance().loadStream("manageInvOld.yml")));
            inventory.options().copyDefaults(true);
            inventory.save(inventoryFile);
            for (String str : inventory.getConfigurationSection("inv.mode").getKeys(false)) {
                this.invHashList.put(str, inventory.getStringList("inv.mode." + str + ".Text"));
                this.invMatList.put(str, MaterialConverter.convertMaterial(inventory.getInt("inv.mode." + str + ".Material"), (byte)0));
                this.invStringList.put(str, inventory.getString("inv.mode." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.mode." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.event").getKeys(false)) {
                this.invMatList.put(str, MaterialConverter.convertMaterial(inventory.getInt("inv.event." + str + ".Material"), (byte)0));
                this.invStringList.put(str, inventory.getString("inv.event." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.event." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.player").getKeys(false)) {
                this.invMatList.put(str, MaterialConverter.convertMaterial(inventory.getInt("inv.player." + str + ".Material"), (byte)0));
                this.invStringList.put(str, inventory.getString("inv.player." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.player." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.controller").getKeys(false)) {
                this.invMatList.put(str, MaterialConverter.convertMaterial(inventory.getInt("inv.controller." + str + ".Material"), (byte)0));
                this.invStringList.put(str, inventory.getString("inv.controller." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.controller." + str + ".SubID"));
            }
            for (String str : inventory.getConfigurationSection("inv.admin").getKeys(false)) {
                this.invMatList.put(str, MaterialConverter.convertMaterial(inventory.getInt("inv.admin." + str + ".Material"), (byte)0));
                this.invStringList.put(str, inventory.getString("inv.admin." + str + ".String"));
                this.invShortList.put(str, (short)inventory.getInt("inv.admin." + str + ".SubID"));
                this.invHashList.put(str, inventory.getStringList("inv.admin." + str + ".Text"));
            }
            this.invStringList.put("manageInvName", inventory.getString("inv.manageInvName"));
            this.invStringList.put("playerAddInvName", inventory.getString("inv.playerAddInvName"));
            this.invStringList.put("playerRemoveInvName", inventory.getString("inv.playerRemoveInvName"));
            this.invStringList.put("playerSetInvName", inventory.getString("inv.playerSetInvName"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString(String a) {
        a = a.toLowerCase();
        if (this.hash.isEmpty()) {
            return "\u00a7cHash is empty";
        }
        if (!this.hash.containsKey(a)) {
            return "\u00a7fkey not found: \u00a75" + a;
        }
        String b = this.hash.get(a);
        return FurnitureLib.getVersionInt() > 15 ? this.applyHexColors(this.hash.get(a)) : ChatColor.translateAlternateColorCodes((char)'&', (String)b);
    }

    public String applyHexColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Deprecated
    public String getString(String key, StringTranslator ... stringTranslators) {
        String a = this.getString(key);
        if (stringTranslators != null) {
            for (StringTranslator trans : stringTranslators) {
                if (trans.getKey() == null || trans.getValue() == null) continue;
                a = a.replaceAll(trans.oldKey(), trans.getValue());
                a = a.replaceAll(trans.newKey(), trans.getValue());
            }
        }
        return a;
    }

    public List<String> getStringList(String a) {
        if (!this.invHashList.containsKey(a)) {
            return null;
        }
        List<String> b = this.invHashList.get(a);
        int i = 0;
        for (String str : b) {
            b.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)str));
            ++i;
        }
        return b;
    }

    public void addText(YamlConfiguration configuration) {
        try {
            File lang = new File(this.getLangFolder(), this.lang + ".yml");
            YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
            conf.addDefaults((Configuration)configuration);
            conf.options().copyDefaults(true);
            conf.save(lang);
            this.loadLanguageConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendString(CommandSender sender, String key, StringTranslator ... stringTranslators) {
        sender.sendMessage(this.getString(key, stringTranslators));
    }

    public static void send(CommandSender sender, String key, StringTranslator ... stringTranslators) {
        LanguageManager.getInstance().sendMessage(sender, key, stringTranslators);
    }

    public Component stringConvert(String value, StringTranslator ... stringTranslators) {
        return this.stringConvert(value, Arrays.asList(stringTranslators));
    }

    public Component stringConvert(String value, List<StringTranslator> stringTranslaters) {
        TagResolver[] tags = this.getTagsArray(stringTranslaters);
        if (Objects.nonNull(tags)) {
            return MiniMessage.miniMessage().deserialize(LanguageManager.serializeLegacyColors(value), this.getTagsArray(stringTranslaters));
        }
        return MiniMessage.miniMessage().deserialize(LanguageManager.serializeLegacyColors(value));
    }

    public static String serializeLegacyColors(String input) {
        if (Objects.isNull(input)) {
            return "";
        }
        if (input.isEmpty()) {
            return "";
        }
        String output = ChatColor.translateAlternateColorCodes((char)'&', (String)input).replaceAll("\u00a7r", "<reset>").replaceAll("\u00a7m", "<st>").replaceAll("\u00a7o", "<i>").replaceAll("\u00a7n", "<u>").replaceAll("\u00a7l", "<b>").replaceAll("\u00a7k", "<obf>");
        Matcher matcher = STRIP_COLOR_PATTERN.matcher(output);
        while (matcher.find()) {
            String color = output.substring(matcher.start(), matcher.end());
            ChatColor chatColor = ChatColor.getByChar((char)color.charAt(1));
            if (Objects.isNull(chatColor)) continue;
            String colorCode = "<" + chatColor.name().toLowerCase() + ">";
            output = output.replaceAll(color, colorCode);
            matcher = STRIP_COLOR_PATTERN.matcher(output);
        }
        return output;
    }

    public void sendMessage(CommandSender sender, String key, StringTranslator ... stringTranslators) {
        String rawString = this.placeholderAPI != null ? this.placeholderAPI.parsePlaceholders(LanguageConverter.serializeLegacyColors(this.getString(key, stringTranslators)), sender) : LanguageConverter.serializeLegacyColors(this.getString(key, stringTranslators));
        TagResolver[] tags = this.getTagsArray(Arrays.asList(stringTranslators));
        Component returnMessage = MiniMessage.miniMessage().deserialize(rawString, tags);
        if (FurnitureLib.getVersionInt() < 16) {
            String legacyString = LegacyComponentSerializer.legacySection().serialize(returnMessage);
            sender.sendMessage(legacyString);
            return;
        }
        this.handling.sendMessage(sender, returnMessage);
    }

    public void sendChatMessage(Component component, CommandSender sender) {
        if (Objects.isNull(component) || Objects.isNull(sender)) {
            return;
        }
        this.handling.sendMessage(sender, component);
    }

    public void sendActionBarMessage(Component component, CommandSender sender) {
        if (Objects.isNull(component) || Objects.isNull(sender)) {
            return;
        }
        this.handling.sendActionBar(sender, component);
    }

    public Component getComponent(String key, StringTranslator ... stringTranslators) {
        String rawString = LanguageConverter.serializeLegacyColors(this.getString(key, stringTranslators));
        TagResolver[] tags = this.getTagsArray(Arrays.asList(stringTranslators));
        Component returnMessage = MiniMessage.miniMessage().deserialize(rawString, tags);
        return returnMessage;
    }

    public TagResolver[] getTagsArray(List<StringTranslator> stringTranslaters) {
        HashSet<TagResolver> tags = this.getTags(stringTranslaters);
        return tags.toArray(new TagResolver[tags.size()]);
    }

    public HashSet<TagResolver> getTags(List<StringTranslator> stringTranslaters) {
        HashSet<TagResolver> hashSet = new HashSet<TagResolver>();
        stringTranslaters.stream().filter(Objects::nonNull).forEach(entry -> hashSet.add(entry.getPlaceHolder()));
        return hashSet;
    }

    public String getName(String a) {
        String b = this.invStringList.get(a);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)b);
    }

    public Short getShort(String a) {
        return this.invShortList.get(a);
    }

    public Material getMaterial(String a) {
        return this.invMatList.get(a);
    }

    public String getLanguage() {
        return this.lang;
    }

    public static LanguageManager getInstance() {
        return instance;
    }

    public void close() {
        if (this.handling != null) {
            this.handling.close();
        }
    }

    public static void sendChatMessage(CommandSender sender, Component jsonText) {
        LanguageManager.getInstance().sendChatMessage(jsonText, sender);
    }

    public static void sendActionBarMessage(CommandSender sender, Component jsonText) {
        LanguageManager.getInstance().sendActionBarMessage(jsonText, sender);
    }

    public void sendConsoleMessage(String ... string) {
        Arrays.asList(string).forEach(this::sendConsoleMessage);
    }

    public void sendConsoleMessage(String string) {
        String rawString = LanguageConverter.serializeLegacyColors(string);
        this.sendConsoleMessage((Component)MiniMessage.miniMessage().deserialize(rawString));
    }

    public void sendConsoleMessage(Component component) {
        if (Objects.nonNull(this.handling)) {
            this.handling.sendConsoleMessage(component);
        }
    }

    static {
        STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-ORX]");
    }
}

