/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackBuilder {
    private ItemStack stack = null;

    public ItemStackBuilder(Material mat) {
        this.stack = new ItemStack(mat);
    }

    public ItemStackBuilder setName(String str) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setDisplayName(str);
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder setLore(String ... str) {
        return this.setLore(Arrays.asList(str));
    }

    public ItemStackBuilder setLore(List<String> loreList) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setLore(loreList);
        this.stack.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder setAmount(int amount) {
        this.stack.setAmount(amount);
        return this;
    }

    public ItemStackBuilder setDurability(short durability) {
        this.stack.setDurability(durability);
        return this;
    }

    public ItemStackBuilder setType(Material mat) {
        this.stack.setType(mat);
        return this;
    }

    public ItemMeta getMeta() {
        return this.stack.getItemMeta();
    }

    public ItemStackBuilder setMeta(ItemMeta itemMeta) {
        this.stack.setItemMeta(itemMeta);
        return this;
    }

    public ItemStack build() {
        return this.stack;
    }

    public static ItemStackBuilder of(Material material) {
        return ItemStackBuilder.of(new ItemStack(material));
    }

    public static ItemStackBuilder of(String string) {
        return ItemStackBuilder.of(Material.valueOf((String)string));
    }

    public static ItemStackBuilder of(ItemStack stack) {
        ItemStackBuilder builder = new ItemStackBuilder(stack.getType());
        builder.setMeta(stack.getItemMeta());
        return builder;
    }
}

