/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import de.Ste3et_C0st.FurnitureLib.Crafting.CraftingFile;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.Utilitis.HiddenStringUtils;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CraftingInv
implements Listener {
    public Plugin plugin;
    public List<Player> playerList = new ArrayList<Player>();
    public boolean editable = false;
    public Project project = null;
    List<String> stringList = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "X");
    private List<Integer> slots = new ArrayList<Integer>();

    public CraftingInv(Plugin pl) {
        Bukkit.getPluginManager().registerEvents((Listener)this, pl);
        this.plugin = pl;
    }

    public void openCrafting(Player p, Project project, boolean editable) {
        if (!editable && project.getCraftingFile().isEnable()) {
            p.sendMessage("This Furniture has not recipe.");
            return;
        }
        this.project = project;
        this.editable = editable;
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)project.getName());
        ShapedRecipe recipe = project.getCraftingFile().getRecipe();
        ItemStack is = recipe.getResult();
        is.setAmount(1);
        ItemStack stack = FurnitureLib.isNewVersion() ? new ItemStack(Material.valueOf((String)"GRAY_STAINED_GLASS_PANE")) : new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, 15);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName("\u00a7c");
        stack.setItemMeta(meta);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, stack);
        }
        inv.setItem(25, is);
        this.slots.add(25);
        String[] recipeShape = recipe.getShape();
        Map ingredientMap = recipe.getIngredientMap();
        for (int j = 0; j < recipeShape.length; ++j) {
            for (int k = 0; k < recipeShape[j].length(); ++k) {
                ItemStack item = (ItemStack)ingredientMap.get(Character.valueOf(recipeShape[j].toCharArray()[k]));
                int i = 9 + (9 * j + k) + 1;
                this.slots.add(i);
                if (item == null) {
                    inv.setItem(i, new ItemStack(Material.AIR));
                    continue;
                }
                item.setAmount(1);
                inv.setItem(i, item);
            }
        }
        p.openInventory(inv);
        this.playerList.add(p);
    }

    @EventHandler
    private void onClick(InventoryClickEvent e) {
        if (this.playerList.contains(e.getWhoClicked())) {
            if (!this.editable) {
                e.setCancelled(true);
                return;
            }
            if (!this.slots.contains(e.getRawSlot())) {
                InventoryView view = e.getView();
                if (e.getClickedInventory() == null) {
                    e.setCancelled(true);
                    return;
                }
                if (e.getClickedInventory().equals((Object)view.getTopInventory())) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent e) {
        if (this.playerList.contains(e.getPlayer())) {
            if (this.editable) {
                StringBuilder s = new StringBuilder();
                HashMap<String, Material> materialList = new HashMap<String, Material>();
                ItemStack result = e.getInventory().getItem(25);
                int l = 0;
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        int i = 9 + (9 * j + k) + 1;
                        ItemStack stack = e.getInventory().getItem(i);
                        if (stack != null) {
                            s.append(this.stringList.get(l));
                            materialList.put(this.stringList.get(l), stack.getType());
                        } else {
                            s.append(this.stringList.get(10));
                            materialList.put(this.stringList.get(10), Material.AIR);
                        }
                        ++l;
                    }
                    s.append(",");
                }
                CraftingFile file = this.project.getCraftingFile();
                if (s.toString().equalsIgnoreCase("xxx,xxx,xxx")) {
                    file.removeCrafting(file.getItemstack());
                    YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file.getFilePath());
                    conf.set(file.getFileHeader() + ".crafting.disable", (Object)true);
                    this.setItem(result, conf, file.getFileHeader());
                    this.save(conf, file.getFilePath());
                } else {
                    file.removeCrafting(file.getItemstack());
                    YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file.getFilePath());
                    conf.set(file.getFileHeader() + ".crafting.recipe", (Object)"");
                    conf.set(file.getFileHeader() + ".crafting.index", (Object)"");
                    this.save(conf, file.getFilePath());
                    this.setItem(result, conf, file.getFileHeader());
                    conf.set(file.getFileHeader() + ".crafting.recipe", (Object)s.toString());
                    conf.set(file.getFileHeader() + ".crafting.disable", (Object)false);
                    for (String str : materialList.keySet()) {
                        conf.set(file.getFileHeader() + ".crafting.index." + str, (Object)((Material)materialList.get(str)).name());
                    }
                    this.save(conf, file.getFilePath());
                    file.loadCrafting(file.getFileName(), conf);
                }
                LanguageManager.send((CommandSender)e.getPlayer(), "message.CraftingEdit", new StringTranslator[0]);
            }
            e.getInventory().clear();
            this.playerList.remove(e.getPlayer());
        }
    }

    public void save(YamlConfiguration yml, File file) {
        try {
            yml.save(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void setItem(ItemStack stack, YamlConfiguration conf, String header) {
        if (stack != null && !stack.getType().equals((Object)Material.AIR)) {
            ItemMeta meta;
            String name = "";
            ArrayList<String> lore = new ArrayList<String>();
            Material material = stack.getType();
            if (stack.hasItemMeta()) {
                meta = stack.getItemMeta();
                name = meta.getDisplayName();
                if (meta.hasLore()) {
                    for (String s : meta.getLore()) {
                        if (HiddenStringUtils.hasHiddenString(s)) continue;
                        lore.add(s);
                    }
                }
                if (FurnitureLib.getVersionInt() > 13 && meta.hasCustomModelData()) {
                    conf.set(header + ".custommodeldata", (Object)meta.getCustomModelData());
                }
            }
            conf.set(header + ".displayName", (Object)name);
            conf.set(header + ".spawnMaterial", (Object)material.name());
            conf.set(header + ".itemLore", lore);
            if (FurnitureLib.isNewVersion()) {
                meta = stack.getItemMeta();
                meta.setLore(lore);
                stack.setItemMeta(meta);
                stack.setAmount(1);
                conf.set(header + ".spawnItemStack", (Object)stack);
            }
        }
    }
}

