/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Utilitis;

import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Task;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatInputHandler
implements Listener {
    private final Player player;
    private final Predicate<String> inputFilter;
    private final Consumer<ReturnValue> supplier;
    private final Task task;

    public ChatInputHandler(Player player, Predicate<String> inputFilter, Consumer<ReturnValue> supplier, Consumer<Player> openSupplier, Duration timeDuration) {
        this.player = player;
        this.inputFilter = inputFilter;
        this.supplier = supplier;
        this.task = SchedularHelper.runLater(() -> {
            this.stop();
            supplier.accept(ReturnValue.of(ReturnState.TIMEOUT));
        }, (int)(timeDuration.toMillis() * 1000L * 20L), false);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FurnitureLib.getInstance());
        openSupplier.accept(player);
    }

    private void stop() {
        if (Objects.nonNull(this.task)) {
            this.task.cancel();
        }
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void AsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (Objects.isNull(this.player)) {
            return;
        }
        if (event.getPlayer().equals((Object)this.player)) {
            this.supplier.accept(this.inputFilter.test(event.getMessage()) ? ReturnValue.of(ReturnState.SUCCESS, event.getMessage()) : ReturnValue.of(ReturnState.WRONG, event.getMessage()));
            this.stop();
            event.setCancelled(true);
            event.getRecipients().clear();
        }
    }

    public static enum ReturnState {
        TIMEOUT,
        SUCCESS,
        WRONG;

    }

    public static class ReturnValue {
        private final ReturnState state;
        private final String string;

        public ReturnValue(ReturnState returnState, String string) {
            this.state = returnState;
            this.string = string;
        }

        public ReturnState getState() {
            return this.state;
        }

        public String getInput() {
            return this.string;
        }

        public static ReturnValue of(ReturnState state) {
            return ReturnValue.of(state, new String());
        }

        public static ReturnValue of(ReturnState state, String string) {
            return new ReturnValue(state, string);
        }
    }
}

