/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.SchematicLoader;

import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelHandler;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.ProjectInventory;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.Furniture;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fContainerEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ProjectLoader
extends Furniture {
    public String header;
    private ProjectInventory inv = null;

    public ProjectLoader(ObjectID id) {
        this(id, true);
    }

    public ProjectLoader(ObjectID id, boolean rotate) {
        super(id);
        try {
            ModelHandler schematic = this.getProject().getModelschematic();
            if (Objects.nonNull(schematic) && id.isFromDatabase()) {
                BlockFace direction = LocationUtil.yawToFace(id.getStartLocation().getYaw()).getOppositeFace();
                HashMap<Location, ModelBlock> locationMap = schematic.getBlockData(id.getStartLocation(), direction);
                this.getObjID().getBlockList().addAll(locationMap.keySet());
                FurnitureLib.getInstance().getBlockManager().getList().addAll(locationMap.keySet());
            }
            this.registerInventory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerInventory() {
        for (fEntity stand : this.getfAsList()) {
            String[] split;
            if (!stand.getName().startsWith("#Inventory:") || this.inv != null || (split = stand.getName().split(":")).length <= 1) continue;
            int i = Integer.parseInt(split[2].replace("#", ""));
            this.inv = new ProjectInventory(i, this.getObjID());
            this.inv.load();
        }
    }

    @Override
    public void spawn(Location arg0) {
    }

    @Override
    public void onClick(Player player) {
        if (this.getObjID() == null) {
            return;
        }
        if (this.getObjID().getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
            return;
        }
        if (player == null) {
            return;
        }
        boolean canInteract = this.canInteract(player, false);
        boolean function = this.hasFunction();
        FurnitureLib.debug("ProjectLoader -> onClick[project:" + this.getObjID().getProject() + "]");
        FurnitureLib.debug("ProjectLoader -> onClick[hasFunction:" + function + "]");
        FurnitureLib.debug("ProjectLoader -> onClick[canInteract:" + canInteract + "]");
        if ((function || Objects.nonNull(this.inv)) && canInteract) {
            if (Objects.nonNull(this.inv)) {
                if (FurnitureLib.getVersionInt() > 16) {
                    player.swingMainHand();
                }
                this.inv.openInventory(player);
                return;
            }
            if (this.runFunction(player)) {
                if (FurnitureLib.getVersionInt() > 16) {
                    player.swingMainHand();
                }
                this.update();
                return;
            }
        } else if (function) {
            if (!this.runPublicFunctions(player)) {
                LanguageManager.send((CommandSender)player, "message.NoPermissions", new StringTranslator[0]);
            }
            return;
        }
        this.runPublicFunctions(player);
    }

    @Override
    public void onBreak(Player player) {
        if (this.getObjID() == null) {
            return;
        }
        if (this.getObjID().getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
            return;
        }
        if (player == null) {
            return;
        }
        if (this.canBuild(player)) {
            Location dropLocation = this.getLocation().clone().add(0.0, 0.5, 0.0);
            if (Objects.nonNull(this.inv)) {
                Stream.of(this.inv.getInv().getContents()).filter(Objects::nonNull).forEach(entry -> this.getWorld().dropItemNaturally(dropLocation, entry));
            }
            this.getfAsList().stream().filter(entity -> entity.getName().equalsIgnoreCase("#ITEM#") || entity.getName().equalsIgnoreCase("#BLOCK#")).filter(fContainerEntity.class::isInstance).map(fContainerEntity.class::cast).forEach(entity -> Stream.of(entity.getInventory().getContents()).filter(Objects::nonNull).forEach(stack -> this.getWorld().dropItemNaturally(dropLocation, stack)));
            if (Objects.nonNull(this.inv)) {
                this.inv.getViewers().stream().forEach(HumanEntity::closeInventory);
            }
            this.destroy(player);
        }
    }
}

