/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.SchematicLoader;

import de.Ste3et_C0st.FurnitureLib.NBT.CraftItemStack;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.entity.fContainerEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ProjectInventory
implements Listener {
    private Inventory inv;
    private Player player;
    private ObjectID id;
    private List<fEntity> entityList = new ArrayList<fEntity>();

    public ProjectInventory(int slots, ObjectID id) {
        this.inv = Bukkit.createInventory(null, (int)slots, (String)id.getProjectOBJ().getCraftingFile().getRecipe().getResult().getItemMeta().getDisplayName());
        this.id = id;
        Bukkit.getPluginManager().registerEvents((Listener)this, id.getProjectOBJ().getPlugin());
    }

    public Player getPlayer() {
        return this.player;
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (this.getPlayer() == null) {
            return;
        }
        if (this.getInv() == null) {
            return;
        }
        if (e.getInventory().equals((Object)this.inv) && e.getPlayer().equals((Object)this.getPlayer())) {
            this.player = null;
            try {
                File inventoryFile = new File(FurnitureLib.getInstance().getDataFolder(), "metadata/" + this.id.getSerial() + ".yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)inventoryFile);
                config.set("inventory", (Object)this.toString());
                config.save(inventoryFile);
                if (!this.entityList.isEmpty()) {
                    for (fEntity entity : this.entityList) {
                        String name = entity.getName();
                        name = name.replace("OnInventoryCloseDisplayItem(", "");
                        name = name.replace(")", "");
                        String[] args = name.split(",");
                        int slot = Integer.parseInt(args[1]);
                        int entitySlot = Integer.parseInt(args[0]);
                        if (!(entity instanceof fContainerEntity)) continue;
                        ((fContainerEntity)fContainerEntity.class.cast(entity)).getInventory().setSlot(entitySlot, this.inv.getItem(slot));
                    }
                    this.id.update();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void openInventory(Player player) {
        if (this.inv == null) {
            return;
        }
        this.player = player;
        this.getPlayer().openInventory(this.inv);
    }

    public Inventory getInv() {
        return this.inv;
    }

    public List<HumanEntity> getViewers() {
        ArrayList<HumanEntity> humans = new ArrayList<HumanEntity>();
        if (Objects.nonNull(this.inv)) {
            humans.addAll(this.inv.getViewers());
        }
        return humans;
    }

    public void load() {
        try {
            File inventoryFile = new File(FurnitureLib.getInstance().getDataFolder(), "metadata/" + this.id.getSerial() + ".yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)inventoryFile);
            if (config.isSet("inventory")) {
                this.setItems(config.getString("inventory"));
            }
            this.id.getPacketList().stream().filter(entry -> entry.getName().startsWith("OnInventoryCloseDisplayItem")).forEach(this.entityList::add);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        if (this.inv == null) {
            return "";
        }
        NBTTagCompound inventory = new NBTTagCompound();
        NBTTagCompound items = new NBTTagCompound();
        for (int i = 0; i < this.inv.getContents().length; ++i) {
            if (this.inv.getContents()[i] == null || this.inv.getContents()[i].getType() == null || this.inv.getContents()[i].getType().equals((Object)Material.AIR)) {
                items.setString("" + i, "NONE");
                continue;
            }
            try {
                items.set("" + i, new CraftItemStack().getNBTTag(this.inv.getContents()[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        inventory.setInt("size", this.getInv().getSize());
        inventory.set("inventory", items);
        return Base64.getEncoder().encodeToString(this.armorStandtoBytes(inventory));
    }

    public void setItems(String string) {
        byte[] by = Base64.getDecoder().decode(string);
        ByteArrayInputStream bin = new ByteArrayInputStream(by);
        try {
            NBTTagCompound compound = NBTCompressedStreamTools.read(bin);
            NBTTagCompound inventory = compound.getCompound("inventory");
            int size = compound.getInt("size");
            this.inv = Bukkit.createInventory(null, (int)size, (String)this.id.getProjectOBJ().getCraftingFile().getRecipe().getResult().getItemMeta().getDisplayName());
            for (int i = 0; i < size; ++i) {
                if (inventory.getString("" + i).equalsIgnoreCase("NONE")) continue;
                ItemStack is = new CraftItemStack().getItemStack(inventory.getCompound("" + i));
                this.inv.setItem(i, is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] armorStandtoBytes(NBTTagCompound compound) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.write(compound, out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
        return out.toByteArray();
    }
}

