/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.NBT;

import de.Ste3et_C0st.FurnitureLib.NBT.NBTBase;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTReadLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NBTTagString
extends NBTBase {
    private String data;

    public NBTTagString() {
        this.data = "";
    }

    public NBTTagString(String paramString) {
        this.data = paramString;
        if (paramString == null) {
            throw new IllegalArgumentException("Empty strings are not allowed");
        }
    }

    @Override
    void write(DataOutput paramDataOutput) {
        try {
            paramDataOutput.writeUTF(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    void load(DataInput paramDataInput, int paramInt, NBTReadLimiter paramNBTReadLimiter) {
        try {
            this.data = paramDataInput.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        paramNBTReadLimiter.readBytes(16 * this.data.length());
    }

    @Override
    public byte getTypeId() {
        return 8;
    }

    @Override
    public String toString() {
        return "\"" + this.data + "\"";
    }

    @Override
    public NBTBase clone() {
        return new NBTTagString(this.data);
    }

    @Override
    public boolean equals(Object paramObject) {
        if (super.equals(paramObject)) {
            NBTTagString localNBTTagString = (NBTTagString)paramObject;
            return this.data == null && localNBTTagString.data == null || this.data != null && this.data.equals(localNBTTagString.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data.hashCode();
    }

    public String a_() {
        return this.data;
    }
}

