/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.NBT;

import de.Ste3et_C0st.FurnitureLib.NBT.NBTReadLimiter;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagByte;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagByteArray;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagDouble;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagEnd;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagFloat;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagInt;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagIntArray;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagLong;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagShort;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagString;
import java.io.DataInput;
import java.io.DataOutput;

public abstract class NBTBase {
    public static final String[] types = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE[]", "STRING", "LIST", "COMPOUND", "INT[]"};

    protected NBTBase() {
    }

    protected static NBTBase createTag(byte type) {
        if (type > 11 || type < 0) {
            throw new IllegalArgumentException("type must be: 11 <= type >= 0");
        }
        switch (type) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte();
            }
            case 2: {
                return new NBTTagShort();
            }
            case 3: {
                return new NBTTagInt();
            }
            case 4: {
                return new NBTTagLong();
            }
            case 5: {
                return new NBTTagFloat();
            }
            case 6: {
                return new NBTTagDouble();
            }
            case 7: {
                return new NBTTagByteArray();
            }
            case 8: {
                return new NBTTagString();
            }
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
            case 11: {
                return new NBTTagIntArray();
            }
        }
        return null;
    }

    public abstract NBTBase clone();

    public boolean equals(Object object) {
        if (!(object instanceof NBTBase)) {
            return false;
        }
        NBTBase nbtbase = (NBTBase)object;
        return this.getTypeId() == nbtbase.getTypeId();
    }

    public abstract byte getTypeId();

    public int hashCode() {
        return this.getTypeId();
    }

    abstract void load(DataInput var1, int var2, NBTReadLimiter var3) throws Exception;

    public abstract String toString();

    abstract void write(DataOutput var1) throws Exception;
}

