/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.NBT;

import com.comphenix.protocol.utility.MinecraftVersion;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackReader;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV111_112;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV113;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV120_1;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV120_5;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV121_5;
import de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStackV121_6;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public class CraftItemStack {
    private static final ItemStackReader READER;

    public ItemStack getItemStack(NBTTagCompound nbtTagCompound) {
        if (Objects.nonNull(READER) && !nbtTagCompound.isEmpty()) {
            return READER.getItemStack(nbtTagCompound);
        }
        return null;
    }

    public NBTTagCompound getNBTTag(ItemStack is) throws Exception {
        return READER.getNBTTag(is);
    }

    public static Optional<ItemStackReader> getReader() {
        return Optional.ofNullable(READER);
    }

    static {
        if (FurnitureLib.getVersion(new MinecraftVersion("1.21.6"))) {
            if (FurnitureLib.isPaper()) {
                ItemStackReader tempReader = null;
                try {
                    tempReader = (ItemStackReader)Class.forName("de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStack_Paper_V121_6").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                READER = tempReader;
            } else {
                READER = new ItemStackV121_6();
            }
        } else if (FurnitureLib.getVersion(new MinecraftVersion("1.21.5"))) {
            if (FurnitureLib.isPaper()) {
                ItemStackReader tempReader = null;
                try {
                    tempReader = (ItemStackReader)Class.forName("de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStack_Paper_V121_5").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                READER = tempReader;
            } else {
                READER = new ItemStackV121_5();
            }
        } else if (FurnitureLib.getVersion(new MinecraftVersion("1.20.5"))) {
            if (FurnitureLib.isPaper()) {
                ItemStackReader tempReader = null;
                try {
                    tempReader = (ItemStackReader)Class.forName("de.Ste3et_C0st.FurnitureLib.NBT.ItemStackReader.ItemStack_Paper_V120_5").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                READER = tempReader;
            } else {
                READER = new ItemStackV120_5();
            }
        } else {
            READER = FurnitureLib.getVersion(new MinecraftVersion("1.20.3")) ? new ItemStackV120_1() : (FurnitureLib.getVersionInt() < 13 ? new ItemStackV111_112() : new ItemStackV113());
        }
    }
}

