/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.ModelLoader;

import de.Ste3et_C0st.FurnitureLib.Database.Serializer;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlockAquaticUpdate;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlockCombatUpdate;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelVector;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.Interactable;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fInteraction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.Vector;

public abstract class Modelschematic {
    private HashMap<ModelVector, fEntity> entityMap = new HashMap();
    private HashMap<ModelVector, ModelBlock> blockDataMap = new HashMap();
    protected Vector min = new Vector();
    protected Vector max = new Vector();
    protected Type.PlaceableSide placeableSide = Type.PlaceableSide.TOP;
    protected String name;

    public Modelschematic(InputStream stream, String fileHeader) {
        this(YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream)), fileHeader);
    }

    public Modelschematic(YamlConfiguration configuration, String fileHeader) {
        this.name = fileHeader;
        FurnitureLib.debug(this.name + " header found.");
        this.loadEntitiesTypo(fileHeader, configuration);
        this.loadBlockData(fileHeader, configuration);
        this.placeableSide = Type.PlaceableSide.valueOf(configuration.getString(fileHeader + ".placeAbleSide", "TOP").toUpperCase());
    }

    public Modelschematic(File file, String fileHeader) throws FileNotFoundException {
        this(new FileInputStream(file), fileHeader);
    }

    public Modelschematic(String name) {
        this.name = name;
    }

    public HashMap<ModelVector, fEntity> getEntityMap() {
        return this.entityMap;
    }

    public HashMap<ModelVector, ModelBlock> getBlockMap() {
        return this.blockDataMap;
    }

    public Type.PlaceableSide getPlaceableSide() {
        return this.placeableSide;
    }

    public String getHeader(YamlConfiguration config) {
        return (String)config.getConfigurationSection("").getKeys(false).toArray()[0];
    }

    public fEntity readNBTtag(NBTTagCompound compound) {
        String entityString = (compound.hasKey("EntityType") ? compound.getString("EntityType") : "armor_stand").toLowerCase();
        fEntity entity = FurnitureManager.getInstance().readEntity(entityString, null, null);
        if (!Objects.nonNull(entity)) {
            FurnitureLib.getInstance().send("Incorect Entity found:");
            FurnitureLib.getInstance().send(entityString + " isn't supported but is incudet in: " + this.name);
            return null;
        }
        entity.loadMetadata(compound);
        return entity;
    }

    private void loadBlockData(String yamlHeader, YamlConfiguration config) {
        boolean aquatic = FurnitureLib.isNewVersion();
        String loadParser = yamlHeader + "." + (aquatic ? "projectData.blockList" : "ProjectModels.Block");
        FurnitureLib.debug(this.name + " load: " + (aquatic ? "projectData.blockList" : "ProjectModels.Block") + " (BlockList)");
        if (config.isConfigurationSection(loadParser)) {
            FurnitureLib.debug(this.name + " load: " + (aquatic ? "projectData.blockList" : "ProjectModels.Block") + " isConfigurationSection = true");
            config.getConfigurationSection(loadParser).getKeys(false).stream().forEach(key -> {
                ModelBlock block;
                ModelBlock modelBlock = block = aquatic ? new ModelBlockAquaticUpdate(config, loadParser + "." + key) : new ModelBlockCombatUpdate(config, loadParser + "." + key);
                if (Objects.nonNull(block) && Material.AIR != block.getMaterial()) {
                    this.blockDataMap.put(block.getVector(), block);
                    this.setMax(block.getVector());
                }
            });
        }
    }

    private void setMax(ModelVector vector) {
        this.min = Vector.getMinimum((Vector)vector.toVector(), (Vector)this.min);
        this.max = Vector.getMaximum((Vector)vector.toVector(), (Vector)this.max);
    }

    private void loadEntitiesTypo(String yamlHeader, YamlConfiguration config) {
        String configString = FurnitureLib.isNewVersion() ? yamlHeader + ".projectData.entities" : yamlHeader + ".ProjectModels.ArmorStands";
        String typoConfigString = FurnitureLib.isNewVersion() ? yamlHeader + ".projectData.entitys" : yamlHeader + ".ProjectModels.ArmorStands";
        FurnitureLib.debug(this.name + " load: " + configString + " (Entities)");
        if (config.isConfigurationSection(configString)) {
            FurnitureLib.debug(this.name + " load: " + configString + " isConfigurationSection = true");
            this.loadEntities(configString, config);
        } else if (config.isConfigurationSection(typoConfigString)) {
            FurnitureLib.debug(this.name + " load: " + configString + " isConfigurationSection = true");
            this.loadEntities(typoConfigString, config);
        }
    }

    private void loadEntities(String configString, YamlConfiguration config) {
        FurnitureLib.debug(this.name + " load: " + configString + " isConfigurationSection = true");
        config.getConfigurationSection(configString).getKeys(false).stream().forEach(key -> {
            Optional<byte[]> optinalKey = this.decodeBase64toByte(config.getString(configString + "." + key, ""), (String)key);
            if (optinalKey.isPresent()) {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(optinalKey.get());){
                    NBTTagCompound entityData = NBTCompressedStreamTools.read(bin);
                    ModelVector vector = new ModelVector(entityData.getCompound("Location"));
                    fEntity entity = this.readNBTtag(entityData);
                    if (Objects.nonNull(vector) && Objects.nonNull(entity)) {
                        this.entityMap.put(vector, entity);
                        if (entity instanceof fInteraction) {
                            fInteraction interaction = (fInteraction)fInteraction.class.cast(entity);
                            BoundingBox boundingBox = new BoundingBox(0.0, 0.0, 0.0, interaction.getWidth(), interaction.getHeight(), interaction.getWidth());
                            boundingBox.shift(vector.toVector());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        FurnitureLib.debug(this.name + " load: " + configString + " has loadet: " + this.entityMap.size() + " Entities");
    }

    private Optional<byte[]> decodeBase64toByte(String encodedString, String key) {
        try {
            return Optional.of(Base64.getDecoder().decode(encodedString));
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.name + " is a corrupted dModel file entity {" + key + "}");
            System.err.println("FurnitureLib try to skip these entity: " + e.getMessage());
            return Optional.empty();
        }
    }

    protected List<Vector> getBlocksInArea(Vector start, Vector end) {
        ArrayList<Vector> vectorList = new ArrayList<Vector>();
        int topBlockX = Math.max(start.getBlockX(), end.getBlockX());
        int bottomBlockX = Math.min(start.getBlockX(), end.getBlockX());
        int topBlockY = Math.max(start.getBlockY(), end.getBlockY());
        int bottomBlockY = Math.min(start.getBlockY(), end.getBlockY());
        int topBlockZ = Math.max(start.getBlockZ(), end.getBlockZ());
        int bottomBlockZ = Math.min(start.getBlockZ(), end.getBlockZ());
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    Vector vector = new Vector(x, y, z);
                    vectorList.add(vector);
                }
            }
        }
        return vectorList;
    }

    protected ModelVector rotateVector(ModelVector vector, BlockFace direction) {
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        direction = this.getPlaceableSide().equals((Object)Type.PlaceableSide.SIDE) ? direction.getOppositeFace() : direction;
        ModelVector returnVector = new ModelVector(x, y, z, vector.getYaw(), vector.getPitch());
        switch (direction) {
            case SOUTH: {
                returnVector = new ModelVector(-x, y, -z, vector.getYaw() + 180.0f, vector.getPitch());
                break;
            }
            case WEST: {
                returnVector = new ModelVector(z, y, -x, vector.getYaw() + 270.0f, vector.getPitch());
                break;
            }
            case EAST: {
                returnVector = new ModelVector(-z, y, x, vector.getYaw() + 90.0f, vector.getPitch());
                break;
            }
        }
        return returnVector;
    }

    public boolean isDestroyAble() {
        AtomicBoolean returnBoolean = new AtomicBoolean(!this.getBlockMap().isEmpty());
        if (!returnBoolean.get()) {
            returnBoolean.set(this.getEntityMap().values().stream().filter(Interactable.class::isInstance).map(Interactable.class::cast).filter(Interactable::canInteractWith).findFirst().isPresent());
        }
        return returnBoolean.get();
    }

    public void save(File file) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        this.saveEntities(configuration);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveEntities(YamlConfiguration configuration) {
        AtomicInteger integer = new AtomicInteger(0);
        if (FurnitureLib.isNewVersion()) {
            this.entityMap.entrySet().stream().forEach(entry -> {
                NBTTagCompound metadata = ((fEntity)entry.getValue()).getMetaData();
                metadata.set("Location", ((ModelVector)entry.getKey()).toNBTTagCompound());
                byte[] bytes = Serializer.armorStandtoBytes(metadata);
                String base64 = Base64.getEncoder().encodeToString(bytes);
                configuration.set(this.name + ".projectData.entities." + integer.getAndIncrement(), (Object)base64);
            });
        } else {
            this.entityMap.entrySet().stream().forEach(entry -> {
                NBTTagCompound metadata = ((fEntity)entry.getValue()).getMetaData();
                metadata.set("Location", ((ModelVector)entry.getKey()).toNBTTagCompound());
                byte[] bytes = Serializer.armorStandtoBytes(metadata);
                String base64 = Base64.getEncoder().encodeToString(bytes);
                configuration.set(this.name + ".ProjectModels.ArmorStands." + integer.getAndIncrement(), (Object)base64);
            });
        }
    }
}

