/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.ModelLoader;

import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelVector;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Modelschematic;
import de.Ste3et_C0st.FurnitureLib.Utilitis.BoundingBox;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ModelHandler
extends Modelschematic {
    public static Predicate<Block> MODELBUILD_FILTER = block -> block.getType().isSolid();

    public ModelHandler(File file, String fileHeader) throws FileNotFoundException {
        super(file, fileHeader);
    }

    public ModelHandler(InputStream stream, String fileHeader) {
        super(stream, fileHeader);
    }

    public ModelHandler(YamlConfiguration configuration, String fileHeader) {
        super(configuration, fileHeader);
    }

    public ModelHandler(String name) {
        super(name);
    }

    public void spawn(ObjectID id) {
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Spawn [" + id.getProject() + "]");
        Location startLocation = id.getStartLocation().add(0.5, 0.0, 0.5);
        BlockFace direction = LocationUtil.yawToFace(id.getStartLocation().getYaw()).getOppositeFace();
        id.addEntities(this.addEntity(startLocation, direction, id));
        id.addBlockLocations(this.addBlocks(startLocation, direction));
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Spawn Send Models [" + id.getProject() + "]");
        FurnitureManager.getInstance().sendObjectInRange(id);
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Spawn Finish [" + id.getProject() + "]");
    }

    public CompletableFuture<Void> spawnWithAnimation(ObjectID id) {
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Spawn [" + id.getProject() + "]");
        Location startLocation = id.getStartLocation().add(0.5, 0.0, 0.5);
        BlockFace direction = LocationUtil.yawToFace(id.getStartLocation().getYaw()).getOppositeFace();
        List<fEntity> entities = this.addEntity(startLocation, direction, id);
        return null;
    }

    public HashMap<Location, ModelBlock> getBlockData(Location startLocation, BlockFace direction) {
        HashMap<Location, ModelBlock> locationList = new HashMap<Location, ModelBlock>();
        this.getBlockMap().forEach((key, value) -> {
            ModelVector rotateVector = this.rotateVector((ModelVector)key, direction);
            Location location = startLocation.clone().add(rotateVector.toVector());
            location.setYaw(0.0f);
            location.setPitch(0.0f);
            locationList.put(location, (ModelBlock)value);
        });
        return locationList;
    }

    public HashSet<fEntity> getEntityMap(Location startLocation, BlockFace direction) {
        HashSet<fEntity> locationList = new HashSet<fEntity>();
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Calculate Entities");
        this.getEntityMap().forEach((key, value) -> {
            fEntity entity = value.clone();
            ModelVector rotateVector = this.rotateVector((ModelVector)key, direction);
            Location entityLocation = startLocation.clone().add(rotateVector.toVector());
            entityLocation.setYaw(rotateVector.getYaw());
            entityLocation.setPitch(rotateVector.getPitch());
            entity.setLocation(entityLocation);
            locationList.add(entity);
            String customName = entity.getCustomName();
            if (entity.hasCustomName() && (customName.equalsIgnoreCase("#ITEM#") || customName.equalsIgnoreCase("#BLOCK#") || customName.equalsIgnoreCase("#SITZ#") || customName.startsWith("#Light") || customName.startsWith("/") || customName.toUpperCase().startsWith("#DYE_"))) {
                entity.setNameVisibility(false);
            }
        });
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Calculate Entities Finish");
        return locationList;
    }

    public List<Location> addBlocks(Location startLocation, BlockFace direction) {
        ArrayList<Location> blockList = new ArrayList<Location>();
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Calculate Blocks");
        this.getBlockData(startLocation, direction).entrySet().stream().sorted((e1, e2) -> Double.compare(((Location)e1.getKey()).getY(), ((Location)e2.getKey()).getY())).forEach(entry -> {
            Location location = (Location)entry.getKey();
            ((ModelBlock)entry.getValue()).place(location, direction);
            blockList.add(location);
        });
        return blockList;
    }

    public List<Location> getBlockLocations(Location startLocation, BlockFace direction) {
        ArrayList<Location> blockList = new ArrayList<Location>();
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Calculate Blocks");
        this.getBlockData(startLocation, direction).entrySet().stream().sorted((e1, e2) -> Double.compare(((Location)e1.getKey()).getY(), ((Location)e2.getKey()).getY())).forEach(entry -> blockList.add((Location)entry.getKey()));
        FurnitureLib.debug("FurnitureLib {ModelHandler} -> Calculate Blocks Finish");
        return blockList;
    }

    private List<fEntity> addEntity(Location startLocation, BlockFace direction, ObjectID id) {
        HashSet<fEntity> entityMap = new HashSet<fEntity>(this.getEntityMap(startLocation, direction));
        ArrayList<fEntity> entityList = new ArrayList<fEntity>();
        entityMap.stream().forEach(entry -> {
            entry.setObjectID(id);
            entityList.add((fEntity)entry);
        });
        return entityList;
    }

    public BoundingBox getBoundingBox() {
        return BoundingBox.of(this.min, this.max);
    }

    public void setBoundingBox(BoundingBox boundingbox) {
        this.min = boundingbox.getMin();
        this.max = boundingbox.getMax();
    }

    public void setSize(Vector min, Vector max) {
        this.min = min;
        this.max = max;
    }

    public void setMax(Vector vector) {
        this.max = vector;
    }

    public void setPlaceableSide(Type.PlaceableSide side) {
        this.placeableSide = side;
    }

    public Vector getPoint1() {
        return this.min;
    }

    public Vector getPoint2() {
        return this.max;
    }

    public boolean isPlaceable(Location loc) {
        BlockFace direction = LocationUtil.yawToFace(loc.getYaw());
        return this.isPlaceable(loc, direction);
    }

    public boolean isPlaceable(Location startLocation, BlockFace direction) {
        AtomicBoolean returnValue = new AtomicBoolean(true);
        if (Objects.nonNull(startLocation)) {
            ModelVector min = this.rotateVector(new ModelVector(this.min), direction.getOppositeFace());
            ModelVector max = this.rotateVector(new ModelVector(this.max), direction.getOppositeFace());
            BoundingBox box = BoundingBox.of(min.toVector(), max.toVector());
            box.shift(startLocation.clone().add(0.0, 0.0, 0.0));
            World world = startLocation.getWorld();
            this.getBlocksInArea(box.getMin(), box.getMax()).forEach(vector -> {
                Location location = vector.toLocation(world);
                Block block = location.getBlock();
                if (MODELBUILD_FILTER.test(block)) {
                    returnValue.set(false);
                    LocationUtil.particleBlock(block);
                }
            });
        }
        return returnValue.get();
    }

    public boolean checkPermission(Player player, Location startLocation, BlockFace direction) {
        AtomicBoolean returnValue = new AtomicBoolean(true);
        if (!FurnitureLib.getInstance().getPermManager().useProtectionLib()) {
            return true;
        }
        if (Objects.nonNull(startLocation)) {
            ModelVector min = this.rotateVector(new ModelVector(this.min), direction.getOppositeFace());
            ModelVector max = this.rotateVector(new ModelVector(this.max), direction.getOppositeFace());
            BoundingBox box = BoundingBox.of(min.toVector(), max.toVector());
            box.shift(startLocation.clone().add(0.0, 0.0, 0.0));
            List<Vector> vectorList = this.getBlocksInArea(box.getMin(), box.getMax());
            World world = startLocation.getWorld();
            vectorList.forEach(vector -> {
                Location location = vector.toLocation(world);
                if (!FurnitureLib.getInstance().getPermManager().canBuild(player, location)) {
                    returnValue.set(false);
                    LocationUtil.particleBlock(location.getBlock());
                }
            });
        }
        return returnValue.get();
    }

    public void setSize(Integer length, Integer height, Integer width, Type.CenterType type) {
        length = length - 1;
        height = height - 1;
        width = width - 1;
        Vector pos1 = new Vector();
        Vector pos2 = new Vector(width.intValue(), height.intValue(), length.intValue());
        if (type.equals((Object)Type.CenterType.RIGHT)) {
            pos2.setZ(-length.intValue());
        } else if (type.equals((Object)Type.CenterType.CENTER)) {
            width = Math.round(width / 2);
            pos1.setX(-width.intValue());
            pos2.setX(width.intValue());
            pos2.setZ(-length.intValue());
        }
        if (type.equals((Object)Type.CenterType.LEFT)) {
            pos2.setZ(-length.intValue());
            pos2.setX(-width.intValue());
        }
        this.setSize(pos1, pos2);
    }
}

