/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.ModelLoader;

import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.ProjectLoader;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.bukkit.plugin.Plugin;

public class ModelFileLoader {
    public static void loadModelFiles() {
        File folder = new File(FurnitureLib.isNewVersion() ? "plugins/FurnitureLib/models/" : "plugins/FurnitureLib/Crafting/");
        if (folder.exists()) {
            Arrays.asList(folder.listFiles()).forEach(entry -> ModelFileLoader.loadModelFile(entry));
        }
    }

    public static Project loadModelFile(File file) {
        Project project;
        FileInputStream stream = new FileInputStream(file);
        try {
            String name = file.getName().replace(".dModel", "").replace(".yml", "");
            FurnitureLib.debug("ModelFileLoader: Start loading -> " + name);
            Project pro = new Project(name, (Plugin)FurnitureLib.getInstance(), (InputStream)stream, Type.PlaceableSide.TOP, ProjectLoader::new);
            pro.applyFunction();
            pro.setEditorProject(true);
            project = pro;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return project;
    }

    private static <T> CompletableFuture<T> makeFuture(Callable<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.call();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        });
    }

    private static CompletableFuture<Void> makeFuture(Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        });
    }
}

