/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.ModelLoader.Block;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.state.ModelBlockSkullState;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.ModelVector;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.configuration.file.YamlConfiguration;

public class ModelBlockAquaticUpdate
extends ModelBlock {
    public static final String CONFIGKEY = "projectData.blockList";
    private BlockData blockData;

    public ModelBlockAquaticUpdate(ModelVector vector, String str) {
        super(vector);
        this.blockData = Bukkit.createBlockData((String)str);
    }

    public ModelBlockAquaticUpdate(YamlConfiguration yamlConfiguration, String key) {
        super(yamlConfiguration, key);
        if (!key.isEmpty()) {
            double x = yamlConfiguration.getDouble(key + ".xOffset");
            double y = yamlConfiguration.getDouble(key + ".yOffset");
            double z = yamlConfiguration.getDouble(key + ".zOffset");
            Object str = yamlConfiguration.getString(key + ".blockData", "");
            String materialStr = yamlConfiguration.getString(key + ".material", "");
            ModelVector vector = new ModelVector(x, y, z);
            if (FurnitureLib.getVersionInt() > 13 && materialStr.startsWith("WALL_SIGN")) {
                materialStr = materialStr.replace("WALL_SIGN", "OAK_WALL_SIGN");
                yamlConfiguration.set(key + ".material", (Object)materialStr);
            }
            if (((String)str).isEmpty() && !materialStr.isEmpty()) {
                String blockDataString = "minecraft:" + materialStr.toLowerCase();
                if (yamlConfiguration.isSet(key + ".Rotation")) {
                    blockDataString = blockDataString + "[facing=" + yamlConfiguration.getString(key + ".Rotation") + "]";
                }
                str = blockDataString;
            }
            try {
                this.blockData = Bukkit.createBlockData((String)((String)str).toLowerCase());
            }
            catch (IllegalArgumentException e) {
                FurnitureLib.debug("Furniture Model File: " + yamlConfiguration.getCurrentPath() + " make Problems with:", 10);
                FurnitureLib.debug("Parsing of: " + (String)str + " -> (" + key + ")", 10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.vector = vector;
            if (Objects.nonNull(this.blockData) && Material.PLAYER_HEAD == this.blockData.getMaterial() && yamlConfiguration.contains(key + ".gameProfile")) {
                String gameProfileName = yamlConfiguration.getString(key + ".gameProfile.name", null);
                UUID uuid = UUID.fromString(yamlConfiguration.getString(key + ".gameProfile.uuid"));
                WrappedGameProfile wrappedGameProfile = new WrappedGameProfile(uuid, gameProfileName);
                if (yamlConfiguration.contains(key + ".gameProfile.textures")) {
                    String value = yamlConfiguration.getString(key + ".gameProfile.textures.value");
                    String signature = yamlConfiguration.getString(key + ".gameProfile.signature.value", null);
                    wrappedGameProfile.getProperties().put((Object)"textures", (Object)new WrappedSignedProperty("textures", value, signature));
                }
                this.blockState = new ModelBlockSkullState(wrappedGameProfile);
            }
        }
    }

    public static boolean isSolid(Block b) {
        boolean bool = false;
        BlockData blockData = b.getBlockData();
        if (blockData.getMaterial().name().contains("_FENCE")) {
            return true;
        }
        if (blockData.getMaterial().name().contains("_WALL")) {
            return true;
        }
        if (blockData instanceof Slab) {
            return !((Slab)blockData).getType().name().equalsIgnoreCase("BOTTOM");
        }
        if (blockData instanceof Stairs) {
            return !((Stairs)blockData).getHalf().name().equalsIgnoreCase("BOTTOM");
        }
        return bool;
    }

    @Override
    public Material getMaterial() {
        return Objects.nonNull(this.blockData) ? this.blockData.getMaterial() : null;
    }

    @Override
    public void place(Location loc) {
        loc.getBlock().setBlockData(this.blockData, false);
        this.applyBlockState(loc);
    }

    @Override
    public void place(Location loc, BlockFace face) {
        if (Objects.nonNull(this.blockData)) {
            BlockData data = this.blockData.clone();
            if (data instanceof Directional) {
                Directional directional = (Directional)data;
                BlockFace originalBlockFace = directional.getFacing();
                float originalYaw = FurnitureLib.getInstance().getLocationUtil().FaceToYaw(originalBlockFace);
                float yawDirection = FurnitureLib.getInstance().getLocationUtil().FaceToYaw(face);
                float newYaw = originalYaw + yawDirection;
                directional.setFacing(LocationUtil.yawToFace(newYaw));
            }
            loc.getBlock().setBlockData(data, false);
            this.applyBlockState(loc);
        }
    }

    public boolean isPlaceable() {
        return false;
    }
}

