/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Listener.render;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import de.Ste3et_C0st.FurnitureLib.Listener.render.RenderEventHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RenderWithProtocols
extends RenderEventHandler {
    private final PacketListener chunkLoadListener = this.onChunkLoad();
    private final PacketListener chunkUnloadListener = this.onChunkUnload();

    @Override
    public void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener(this.chunkLoadListener);
        ProtocolLibrary.getProtocolManager().addPacketListener(this.chunkUnloadListener);
    }

    @Override
    public void remove() {
        ProtocolLibrary.getProtocolManager().removePacketListener(this.chunkLoadListener);
        ProtocolLibrary.getProtocolManager().removePacketListener(this.chunkUnloadListener);
    }

    private PacketListener onChunkLoad() {
        return new PacketAdapter((Plugin)FurnitureLib.getInstance(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            public void onPacketSending(PacketEvent event) {
                int chunkX = (Integer)event.getPacket().getIntegers().read(0);
                int chunkZ = (Integer)event.getPacket().getIntegers().read(1);
                Player player = event.getPlayer();
                World world = player.getWorld();
                SchedularHelper.runAsync(() -> RenderWithProtocols.this.getFurnitureManager().updatePlayerView(player, chunkX, chunkZ, world));
            }
        };
    }

    private PacketListener onChunkUnload() {
        return new PacketAdapter((Plugin)FurnitureLib.getInstance(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.UNLOAD_CHUNK}){

            public void onPacketSending(PacketEvent event) {
                int chunkX = (Integer)event.getPacket().getIntegers().read(0);
                int chunkZ = (Integer)event.getPacket().getIntegers().read(1);
                Player player = event.getPlayer();
                World world = player.getWorld();
                SchedularHelper.runAsync(() -> RenderWithProtocols.this.getFurnitureManager().destroyChunkPlayerView(player, chunkX, chunkZ, world));
            }
        };
    }
}

