/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Listener.render;

import de.Ste3et_C0st.FurnitureLib.Listener.render.RenderEventHandler;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class RenderWithBukkit
extends RenderEventHandler
implements Listener {
    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FurnitureLib.getInstance());
    }

    @Override
    public void remove() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getHealth() <= 0.0) {
            return;
        }
        Location fromLocation = event.getFrom();
        Location toLocation = event.getTo();
        int xFrom = fromLocation.getBlockX() >> 4;
        int xTo = toLocation.getBlockX() >> 4;
        int zFrom = fromLocation.getBlockZ() >> 4;
        int zTo = toLocation.getBlockZ() >> 4;
        if (xFrom != xTo || zFrom != zTo) {
            this.getFurnitureManager().updatePlayerViewWithRange(player, toLocation);
        }
    }

    @EventHandler
    public void onPlayerRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        SchedularHelper.runLater(() -> this.getFurnitureManager().updatePlayerViewWithRange(player, event.getRespawnLocation()), 5, true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        SchedularHelper.runLater(() -> this.getFurnitureManager().updatePlayerViewWithRange(player, event.getTo()), 5, true);
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        SchedularHelper.runLater(() -> this.getFurnitureManager().updatePlayerViewWithRange(player, player.getLocation()), 5, true);
    }
}

