/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.Events.ProjectBreakEvent;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.Events.ProjectClickEvent;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.Furniture;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class FurnitureProtocolListener {
    private final PacketListener use_entity = this.use_entity();
    private final PacketListener steer_vehicle = this.steer_vehicle();

    public FurnitureProtocolListener() {
        this.init();
    }

    private void init() {
        ProtocolLibrary.getProtocolManager().addPacketListener(this.use_entity);
        ProtocolLibrary.getProtocolManager().addPacketListener(this.steer_vehicle);
    }

    private PacketListener steer_vehicle() {
        return new PacketAdapter(this, (Plugin)FurnitureLib.getInstance(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Client.STEER_VEHICLE}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPacketType() == PacketType.Play.Client.STEER_VEHICLE) {
                    fEntity f;
                    List<fEntity> e;
                    Type.EntityMoving moving;
                    Player p = event.getPlayer();
                    if (FurnitureLib.isVersionOrAbove("1.21.2")) {
                        InternalStructure input = (InternalStructure)event.getPacket().getStructures().read(0);
                        moving = (Boolean)input.getBooleans().readSafely(5) != false ? Type.EntityMoving.SNEAKING : null;
                    } else {
                        Type.EntityMoving entityMoving = moving = (Boolean)event.getPacket().getBooleans().readSafely(1) != false ? Type.EntityMoving.SNEAKING : null;
                    }
                    if (moving != null && moving.equals((Object)Type.EntityMoving.SNEAKING) && (e = FurnitureManager.getInstance().getArmorStandFromPassenger(p)) != null && !e.isEmpty() && (f = (fEntity)e.stream().findFirst().get()) != null) {
                        f.eject();
                    }
                }
            }
        };
    }

    private PacketListener use_entity() {
        return new PacketAdapter((Plugin)FurnitureLib.getInstance(), ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.USE_ENTITY}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPacketType() == PacketType.Play.Client.USE_ENTITY) {
                    Integer PacketID = (Integer)event.getPacket().getIntegers().read(0);
                    if (Objects.isNull(PacketID)) {
                        return;
                    }
                    ObjectID objID = FurnitureManager.getInstance().getfArmorStandByID(PacketID);
                    if (Objects.nonNull(objID)) {
                        WrappedEnumEntityUseAction wrappedEnumEntityUseAction;
                        event.setCancelled(true);
                        if (objID.getSQLAction().equals((Object)Type.SQLAction.REMOVE)) {
                            return;
                        }
                        if (objID.isPrivate()) {
                            return;
                        }
                        Player player = event.getPlayer();
                        if (Objects.isNull(player)) {
                            return;
                        }
                        EnumWrappers.EntityUseAction action = (EnumWrappers.EntityUseAction)event.getPacket().getEntityUseActions().readSafely(0);
                        if (FurnitureLib.getVersionInt() > 16 && Objects.nonNull(wrappedEnumEntityUseAction = (WrappedEnumEntityUseAction)event.getPacket().getEnumEntityUseActions().readSafely(0))) {
                            action = wrappedEnumEntityUseAction.getAction();
                        }
                        switch (action) {
                            case ATTACK: {
                                FurnitureLib.debug("FurnitureLib -> Attack furniture (" + objID.toString() + ").");
                                FurnitureProtocolListener.this.onLeftClick(player, objID);
                                break;
                            }
                            case INTERACT_AT: {
                                FurnitureProtocolListener.this.onRightClick(player, objID);
                                break;
                            }
                        }
                    }
                }
            }
        };
    }

    private void onLeftClick(Player player, ObjectID objectID) {
        if (GameMode.SPECTATOR == player.getGameMode()) {
            return;
        }
        if (!FurnitureLib.getInstance().getFurnitureManager().getIgnoreList().contains(player.getUniqueId())) {
            SchedularHelper.runTask(() -> {
                Furniture furnitureOject;
                ProjectBreakEvent projectBreakEvent = new ProjectBreakEvent(player, objectID);
                Bukkit.getPluginManager().callEvent((Event)projectBreakEvent);
                FurnitureLib.debug("FurnitureLib -> ProjectBreakEvent cancled (" + projectBreakEvent.isCancelled() + ").");
                if (!projectBreakEvent.isCancelled() && Objects.nonNull(furnitureOject = objectID.getFurnitureObject())) {
                    furnitureOject.onBreak(player);
                }
            }, true);
        } else {
            LanguageManager.send((CommandSender)player, "message.FurnitureToggleEvent", new StringTranslator[0]);
        }
    }

    private void onRightClick(Player player, ObjectID objectID) {
        if (GameMode.SPECTATOR == player.getGameMode()) {
            return;
        }
        if (!FurnitureLib.getInstance().getFurnitureManager().getIgnoreList().contains(player.getUniqueId())) {
            SchedularHelper.runTask(() -> {
                Furniture furnitureOject;
                ProjectClickEvent projectBreakEvent = new ProjectClickEvent(player, objectID);
                Bukkit.getPluginManager().callEvent((Event)projectBreakEvent);
                if (!projectBreakEvent.isCancelled() && Objects.nonNull(furnitureOject = objectID.getFurnitureObject())) {
                    furnitureOject.onClick(player);
                }
            }, true);
        } else {
            LanguageManager.send((CommandSender)player, "message.FurnitureToggleEvent", new StringTranslator[0]);
        }
    }
}

