/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Listener;

import com.google.common.collect.Lists;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.Events.FurnitureItemEvent;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.Events.ProjectBreakEvent;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.Events.ProjectClickEvent;
import de.Ste3et_C0st.FurnitureLib.Utilitis.HiddenStringUtils;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LocationUtil;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.Utilitis.callbacks.CallbackBoolean;
import de.Ste3et_C0st.FurnitureLib.main.Furniture;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChunkOnLoad
implements Listener {
    public HashSet<Player> eventList = new HashSet();

    public static Project getProjectByItem(ItemStack is) {
        return FurnitureLib.getInstance().getFurnitureManager().getProject(ChunkOnLoad.getProjectString(is));
    }

    public static String getProjectString(ItemStack stack) {
        String projectString;
        if (Objects.isNull(stack)) {
            return null;
        }
        if (!stack.hasItemMeta()) {
            return null;
        }
        if (FurnitureLib.getVersionInt() > 13) {
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasLore() && HiddenStringUtils.hasHiddenString((String)stack.getItemMeta().getLore().get(0))) {
                return HiddenStringUtils.extractHiddenString((String)stack.getItemMeta().getLore().get(0));
            }
            NamespacedKey key = new NamespacedKey((Plugin)FurnitureLib.getInstance(), "model");
            return (String)meta.getPersistentDataContainer().getOrDefault(key, PersistentDataType.STRING, null);
        }
        if (stack.getItemMeta().hasLore() && (projectString = HiddenStringUtils.extractHiddenString((String)stack.getItemMeta().getLore().get(0))) != null) {
            return projectString;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSpawn(PlayerInteractEvent event) {
        Action action = event.getAction();
        EquipmentSlot equipmentSlot = event.getHand();
        Player player = event.getPlayer();
        if (event.hasItem()) {
            ItemStack stack = event.getItem();
            String projectString = ChunkOnLoad.getProjectString(stack);
            if (Objects.isNull(projectString)) {
                return;
            }
            if (projectString.isEmpty()) {
                return;
            }
            Project project = FurnitureManager.getInstance().getProject(projectString);
            event.setCancelled(true);
            if (Objects.isNull(project)) {
                LanguageManager.getInstance().sendMessage((CommandSender)player, "message.ProjectNotFound", new StringTranslator("project", projectString));
                return;
            }
            String projectName = project.getName();
            if (EquipmentSlot.HAND != equipmentSlot) {
                return;
            }
            if (Action.RIGHT_CLICK_BLOCK != action) {
                return;
            }
            if (!event.hasBlock()) {
                return;
            }
            BlockFace blockFace = event.getBlockFace();
            Block block = event.getClickedBlock();
            Location location = block.getLocation();
            World world = location.getWorld();
            if (block.isLiquid()) {
                return;
            }
            if (this.eventList.contains(player)) {
                return;
            }
            if (FurnitureLib.getInstance().getBlockManager().contains(location)) {
                return;
            }
            if (FurnitureConfig.getFurnitureConfig().isWorldIgnored(world.getName())) {
                LanguageManager.send((CommandSender)player, "message.IgnoredWorld", new StringTranslator("world", world.getName()));
                return;
            }
            this.eventList.add(player);
            location.setYaw((float)FurnitureLib.getInstance().getLocationUtil().FaceToYaw(LocationUtil.yawToFace(player.getLocation().getYaw())));
            FurnitureItemEvent itemEvent = new FurnitureItemEvent(player, stack, project, location, blockFace);
            FurnitureLib.debug("FurnitureLib -> Place Furniture Start (" + projectName + ").");
            Bukkit.getPluginManager().callEvent((Event)itemEvent);
            FurnitureLib.debug("FurnitureLib -> Call FurnitureItemEvent cancel (" + itemEvent.isCancelled() + ").");
            if (!itemEvent.isCancelled()) {
                if (itemEvent.canBuild()) {
                    FurnitureLib.debug("FurnitureLib -> Can Place Model (" + projectName + ") here");
                    if (itemEvent.isTimeToPlace()) {
                        itemEvent.debugTime("FurnitureLib -> {ChunkOnLoad} isTime to Place");
                        if (Objects.nonNull(itemEvent.getProject().getModelschematic())) {
                            itemEvent.debugTime("FurnitureLib -> Model " + projectName + " have Schematic place it.");
                            if (project.getModelschematic().isPlaceable(itemEvent.getObjID().getStartLocation())) {
                                itemEvent.debugTime("FurnitureLib -> Model " + projectName + " is Placeable");
                                this.spawn(itemEvent);
                            } else {
                                LanguageManager.send((CommandSender)player, "message.NotEnoughSpace", new StringTranslator[0]);
                            }
                        } else {
                            FurnitureLib.debug("FurnitureLib -> Can't place model [no Modelschematic (" + projectName + ")]");
                        }
                    }
                } else {
                    FurnitureLib.debug("FurnitureLib -> Can't place model " + projectName + " here canBuild(false)");
                }
            }
            this.removePlayer(player);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        SchedularHelper.runLater(() -> {
            if (Objects.nonNull(event.getWorld())) {
                FurnitureLib.getInstance().getSQLManager().getDatabase().loadWorld(Type.SQLAction.NOTHING, event.getWorld());
            }
        }, 20, true);
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        if (!event.isCancelled()) {
            World world = event.getWorld();
            final List objects = FurnitureManager.getInstance().getObjectList().stream().filter(entry -> entry.getWorld().equals((Object)world)).collect(Collectors.toList());
            FurnitureLib.getInstance().getSQLManager().save(new CallbackBoolean(){

                @Override
                public void onResult(boolean paramBoolean) {
                    if (paramBoolean) {
                        FurnitureManager.getInstance().getObjectList().removeAll(objects);
                    }
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRightClickBlock(PlayerInteractEvent e) {
        if (Action.RIGHT_CLICK_BLOCK == e.getAction()) {
            Block b = e.getClickedBlock();
            if (b == null) {
                return;
            }
            Player player = e.getPlayer();
            if (!FurnitureLib.getInstance().getBlockManager().contains(b.getLocation())) {
                return;
            }
            if (EquipmentSlot.HAND != e.getHand()) {
                return;
            }
            Location loc = b.getLocation();
            loc.setYaw((float)FurnitureLib.getInstance().getLocationUtil().FaceToYaw(LocationUtil.yawToFace(player.getLocation().getYaw())));
            Location blockLocation = b.getLocation();
            boolean bool = FurnitureLib.isNewVersion() ? !Tag.FLOWER_POTS.isTagged((Keyed)b.getType()) : !b.getType().equals((Object)Material.FLOWER_POT);
            ObjectID objID = FurnitureManager.getInstance().getObjectList().stream().filter(obj -> obj.containsBlock(blockLocation)).findFirst().orElse(null);
            if (Objects.isNull(objID)) {
                return;
            }
            if (objID.isPrivate()) {
                return;
            }
            if (bool && Type.SQLAction.REMOVE != objID.getSQLAction()) {
                if (player.getGameMode() == GameMode.CREATIVE && !FurnitureConfig.getFurnitureConfig().creativeInteract() && !FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)player, "furniture.bypass.creative.interact")) {
                    e.setCancelled(true);
                    return;
                }
                if (!FurnitureLib.getInstance().getFurnitureManager().getIgnoreList().contains(player.getUniqueId())) {
                    Furniture furniture;
                    ProjectClickEvent projectClickEvent = new ProjectClickEvent(player, objID);
                    Bukkit.getPluginManager().callEvent((Event)projectClickEvent);
                    if (!projectClickEvent.isCancelled() && Objects.nonNull(furniture = objID.getFurnitureObject())) {
                        furniture.onClick(player);
                    }
                    e.setCancelled(true);
                    return;
                }
                LanguageManager.send((CommandSender)player, "message.FurnitureToggleEvent", new StringTranslator[0]);
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (GameMode.SPECTATOR == player.getGameMode()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (Action.LEFT_CLICK_BLOCK == event.getAction()) {
            if (event.getClickedBlock() == null) {
                return;
            }
            if (event.getClickedBlock().getLocation() == null) {
                return;
            }
            if (FurnitureLib.getInstance() == null) {
                return;
            }
            if (FurnitureLib.getInstance().getBlockManager() == null) {
                return;
            }
            if (FurnitureLib.getInstance().getBlockManager().getList() == null) {
                return;
            }
            Location location = event.getClickedBlock().getLocation();
            if (FurnitureLib.getInstance().getBlockManager().contains(location)) {
                FurnitureLib.getInstance().getFurnitureManager().getAllExistObjectIDs().filter(entry -> entry.containsBlock(location)).findFirst().ifPresent(objectID -> {
                    if (objectID.isPrivate()) {
                        return;
                    }
                    event.setCancelled(true);
                    if (!FurnitureLib.getInstance().getFurnitureManager().getIgnoreList().contains(player.getUniqueId())) {
                        Furniture furniture;
                        ProjectBreakEvent projectBreakEvent = new ProjectBreakEvent(player, (ObjectID)objectID);
                        Bukkit.getPluginManager().callEvent((Event)projectBreakEvent);
                        if (!projectBreakEvent.isCancelled() && Objects.nonNull(furniture = objectID.getFurnitureObject())) {
                            furniture.onBreak(player);
                        }
                    } else {
                        LanguageManager.send((CommandSender)event.getPlayer(), "message.FurnitureToggleEvent", new StringTranslator[0]);
                    }
                });
            }
        }
    }

    @EventHandler
    public void onEntityRightClick(PlayerInteractEntityEvent e) {
        if (EquipmentSlot.HAND != e.getHand()) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (e.getRightClicked() != null && e.getPlayer() != null) {
            PlayerInventory inv = e.getPlayer().getInventory();
            if (ChunkOnLoad.getProjectByItem(inv.getItemInMainHand()) != null) {
                e.setCancelled(true);
                return;
            }
            if (ChunkOnLoad.getProjectByItem(inv.getItemInOffHand()) != null) {
                e.setCancelled(true);
                return;
            }
        }
    }

    public void spawn(FurnitureItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.debugTime("FurnitureLib -> spawn Start " + e.getObjID().getProject());
        ObjectID obj = e.getObjID();
        if (FurnitureLib.getInstance().getFurnitureManager().getIgnoreList().contains(e.getPlayer().getUniqueId())) {
            LanguageManager.send((CommandSender)e.getPlayer(), "message.FurnitureToggleEvent", new StringTranslator[0]);
            return;
        }
        if (FurnitureManager.getInstance().furnitureAlreadyExistOnBlock(obj.getStartLocation().getBlock())) {
            LanguageManager.send((CommandSender)e.getPlayer(), "message.FurnitureOnThisPlace", new StringTranslator[0]);
            return;
        }
        if (e.sendAnnouncer()) {
            FurnitureLib.getInstance().spawn(obj.getProjectOBJ(), obj);
            e.finish();
            e.removeItem();
            FurnitureManager.getInstance().addObjectID(obj);
            if (FurnitureLib.useDebugMode()) {
                FurnitureLib.debug("FurnitureLib -> Spawn Finish " + e.getObjID().getProject() + " it takes " + (System.currentTimeMillis() - e.getEventCallTime()) + "ms to spawn it");
            }
        }
    }

    private void removePlayer(Player p) {
        SchedularHelper.runLater(() -> {
            if (this.eventList != null && !this.eventList.isEmpty() && p != null && p.isOnline()) {
                this.eventList.remove(p);
            }
        }, 1, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonPush(BlockPistonExtendEvent event) {
        ArrayList locations = Lists.newArrayList();
        locations.add(event.getBlock().getLocation());
        event.getBlocks().stream().map(Block::getLocation).forEach(locations::add);
        locations.stream().forEach(location -> {
            if (!FurnitureManager.getInstance().getAllEntitiesInRange((Location)location, 1.7).isEmpty()) {
                event.setCancelled(true);
            } else if (FurnitureLib.getInstance().getBlockManager().contains((Location)location)) {
                event.setCancelled(true);
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonPush(BlockPistonRetractEvent event) {
        ArrayList locations = Lists.newArrayList();
        locations.add(event.getBlock().getLocation());
        event.getBlocks().stream().map(Block::getLocation).forEach(locations::add);
        locations.stream().forEach(location -> {
            if (!FurnitureManager.getInstance().getAllEntitiesInRange((Location)location, 1.7).isEmpty()) {
                event.setCancelled(true);
            } else if (FurnitureLib.getInstance().getBlockManager().contains((Location)location)) {
                event.setCancelled(true);
            }
        });
    }
}

