/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.LimitationManager;

import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.Limitation;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public abstract class PermissionKitLimit
extends Limitation {
    private static final String KEY = "Permission";
    private static final String headString = "PermissionKit";
    private static final String PERMISSION = "furniture.limit.";
    private HashMap<String, HashMap<Project, OptionalInt>> kitMap = new HashMap();
    protected HashMap<String, HashMap<String, OptionalInt>> worldMap = new HashMap();
    private Supplier<String> permissionConsumer = () -> PERMISSION + this.getEnum().name().toLowerCase() + ".<kitName>";

    public PermissionKitLimit(Type.LimitationType type) {
        super(type);
    }

    @Override
    public YamlConfiguration loadYaml(List<String> headerList) {
        if (!headerList.isEmpty()) {
            ArrayList<String> headerConfig = new ArrayList<String>();
            headerConfig.addAll(headerList);
            headerConfig.addAll(Arrays.asList("----------------------------------------------", "These Limitation type support permission Kits!", "PermissionKit:", "\t<kitName>:", this.getEnum() == Type.LimitationType.WORLD ? "\t\tworld: -1" : "\t\tchair: -1", "\t\ttotal:", "\t\t\tenable: false", "\t\t\tamount: -1", "----------------------------------------------", "the permission for these kit is " + this.permissionConsumer.get()));
            headerList = headerConfig;
        }
        return super.loadYaml(headerList);
    }

    @Override
    protected void ioProjectLimit(String headerString, Project project, YamlConfiguration configuration) {
        if (configuration.isConfigurationSection(headString)) {
            configuration.getConfigurationSection(headString).getKeys(false).stream().forEach(kitName -> {
                String kit = "PermissionKit." + kitName;
                if (Type.LimitationType.WORLD != this.getEnum()) {
                    HashMap<Project, OptionalInt> kitMap = this.kitMap.getOrDefault(kitName, new HashMap());
                    OptionalInt totalInt = this.loadTotal(configuration, kit);
                    kitMap.put(project, totalInt.isPresent() ? totalInt : OptionalInt.of(configuration.getInt(kit + "." + project.getName(), -2)));
                    this.kitMap.put((String)kitName, kitMap);
                } else {
                    HashMap worldKitMap = this.worldMap.getOrDefault(kitName, new HashMap());
                    OptionalInt worldOptionalInt = this.loadTotal(configuration, kit);
                    if (worldOptionalInt.isPresent()) {
                        Bukkit.getWorlds().stream().forEach(world -> worldKitMap.put(world.getName(), OptionalInt.of(worldOptionalInt.getAsInt())));
                    } else {
                        Bukkit.getWorlds().stream().forEach(world -> {
                            int limitWorld = configuration.getInt(kit + "." + world.getName(), -2);
                            worldKitMap.put(world.getName(), limitWorld > -2 ? OptionalInt.of(limitWorld) : OptionalInt.empty());
                        });
                    }
                    this.worldMap.put((String)kitName, worldKitMap);
                }
            });
        }
        super.ioProjectLimit(headerString, project, configuration);
    }

    private OptionalInt loadTotal(YamlConfiguration configuration, String key) {
        if (configuration.getBoolean(key + ".total.enable", false)) {
            return OptionalInt.of(configuration.getInt(key + ".total.amount", -1));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getKitLimit(Project project, Location location, Player player) {
        AtomicInteger returnValue = new AtomicInteger(-2);
        this.getKitPermissionSet(player, this.kitMap.keySet()).stream().forEach(kitName -> {
            HashMap projectMap = this.kitMap.getOrDefault(kitName, new HashMap());
            OptionalInt limit = projectMap.getOrDefault(project, OptionalInt.empty());
            if (limit.isPresent() && returnValue.get() < limit.getAsInt()) {
                returnValue.set(limit.getAsInt());
            }
        });
        return returnValue.get() > -2 ? OptionalInt.of(returnValue.get()) : OptionalInt.empty();
    }

    public OptionalInt getKitLimitWorld(Project project, Location location, Player player) {
        String worldName = location.getWorld().getName();
        AtomicInteger returnValue = new AtomicInteger(-2);
        this.getKitPermissionSet(player, this.worldMap.keySet()).stream().forEach(kitName -> {
            HashMap projectMap = this.worldMap.getOrDefault(kitName, new HashMap());
            OptionalInt limit = projectMap.getOrDefault(worldName, OptionalInt.empty());
            if (limit.isPresent() && returnValue.get() < limit.getAsInt()) {
                returnValue.set(limit.getAsInt());
            }
        });
        return returnValue.get() > -2 ? OptionalInt.of(returnValue.get()) : OptionalInt.empty();
    }

    private List<String> getKitPermissionSet(Player player, Set<String> stringSet) {
        return stringSet.stream().filter(entry -> player.hasPermission(this.permissionConsumer.get().replace("<kitName>", entry.toLowerCase()))).collect(Collectors.toList());
    }

    public boolean isPresent(OptionalInt optionalInt) {
        return optionalInt.isPresent() && optionalInt.getAsInt() > -2;
    }
}

