/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.LimitationManager;

import com.google.common.collect.Lists;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.LimitationInforamtion;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.LimitationManager;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public abstract class Limitation {
    protected HashMap<Project, Integer> amountMap = new HashMap();
    protected HashMap<String, Integer> worldMap = new HashMap();
    private final Type.LimitationType type;
    private boolean activate = false;

    public abstract int getAmount(Predicate<ObjectID> var1);

    public abstract boolean canPlace(Location var1, Project var2, Player var3);

    public abstract void writeConfig();

    public abstract void updateConfig(Project var1);

    public abstract Predicate<ObjectID> buildFilter(Location var1, Project var2, Player var3);

    public Limitation(Type.LimitationType type) {
        this.type = type;
    }

    public Type.LimitationType getEnum() {
        return this.type;
    }

    protected File getFile() {
        File file = new File(LimitationManager.getLimitationFolder(), this.getEnum().name().toLowerCase() + ".yml");
        return file;
    }

    public YamlConfiguration loadYaml() {
        return this.loadYaml(Lists.newArrayList());
    }

    public YamlConfiguration loadYaml(List<String> headerList) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.getFile());
        configuration.options().copyDefaults(true);
        configuration.options().copyHeader(true);
        if (!headerList.isEmpty()) {
            if (FurnitureLib.getVersionInt() > 18) {
                configuration.options().setHeader(headerList);
            } else {
                String headerString = String.join((CharSequence)"\n", headerList.toArray(new String[headerList.size()]));
                configuration.options().header(headerString);
            }
        }
        return configuration;
    }

    protected void writeGlobal(YamlConfiguration configuration, String headerString) {
        if (!configuration.contains(headerString + ".total")) {
            configuration.addDefault(headerString + ".total.enable", (Object)false);
            configuration.addDefault(headerString + ".total.amount", (Object)-1);
            configuration.addDefault(headerString + ".total.global", (Object)false);
        }
    }

    protected void ioProjectLimit(String headerString, Project project, YamlConfiguration configuration) {
        if (Objects.isNull(project)) {
            return;
        }
        if (Type.LimitationType.WORLD != this.getEnum()) {
            configuration.addDefault(headerString + ".projects." + project.getName(), (Object)(this.getEnum() == Type.LimitationType.PLAYER ? 10 : -1));
            if (configuration.getBoolean(headerString + ".total.enable", false)) {
                this.setLimit(project, configuration.getInt(headerString + ".total.amount", -1));
                FurnitureConfig.getFurnitureConfig().getLimitManager().setGlobal(configuration.getBoolean(headerString + ".total.global", false));
            } else {
                this.setLimit(project, configuration.getInt(headerString + ".projects." + project.getName(), this.getEnum() == Type.LimitationType.PLAYER ? 10 : -1));
            }
        } else {
            Bukkit.getWorlds().stream().forEach(entry -> {
                configuration.addDefault(headerString + ".worlds." + entry.getName(), (Object)-1);
                if (configuration.getBoolean(headerString + ".total.enable", false)) {
                    this.setWorldLimit(entry.getName(), configuration.getInt(headerString + ".total.amount", -1));
                } else {
                    this.setWorldLimit(entry.getName(), configuration.getInt(headerString + ".worlds." + entry.getName(), -1));
                }
            });
            if (configuration.getBoolean(headerString + ".total.enable", false)) {
                FurnitureConfig.getFurnitureConfig().getLimitManager().setGlobal(configuration.getBoolean(headerString + ".total.global", false));
            }
        }
    }

    protected void save(YamlConfiguration configuration, File file) {
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Optional<LimitationInforamtion> buildInforamtion(Player player, Location location, Project project) {
        return Optional.of(new LimitationInforamtion(this.getEnum().name().toLowerCase(), this.getLimit(project, location, player), this.getAmount(this.buildFilter(location, project, player))));
    }

    public int getLimit(Project project, Location location, Player player) {
        if (this.getEnum() == Type.LimitationType.WORLD) {
            String world = location.getWorld().getName();
            return this.worldMap.getOrDefault(world, -1);
        }
        return this.amountMap.getOrDefault(project, -1);
    }

    protected void setLimit(Project project, int amount) {
        this.amountMap.put(project, amount);
    }

    protected void setWorldLimit(String world, int amount) {
        this.worldMap.put(world, amount);
    }

    public boolean isGlobal() {
        return FurnitureConfig.getFurnitureConfig().getLimitGlobal() > 0;
    }

    public int getGlobalAmount() {
        return FurnitureConfig.getFurnitureConfig().getLimitGlobal();
    }

    public void reload() {
        this.amountMap.clear();
        this.writeConfig();
    }

    public boolean isActivate() {
        return this.activate;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }
}

