/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.LimitationManager;

import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.LimitationManager.PermissionKitLimit;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ChunkLimitation
extends PermissionKitLimit {
    private static final String KEY = "Chunk";
    private static final String headString = "ChunkLimit";

    public ChunkLimitation() {
        super(Type.LimitationType.CHUNK);
        this.writeConfig();
    }

    @Override
    public int getAmount(Predicate<ObjectID> predicate) {
        return (int)FurnitureManager.getInstance().getAllExistObjectIDs().filter(predicate).count();
    }

    @Override
    public int getLimit(Project project, Location location, Player player) {
        OptionalInt kitLimit = super.getKitLimit(project, location, player);
        return kitLimit.isPresent() ? kitLimit.getAsInt() : super.getLimit(project, location, player);
    }

    @Override
    public boolean canPlace(Location location, Project project, Player player) {
        return this.getAmount(this.buildFilter(location, project, player)) < this.getLimit(project, location, player);
    }

    @Override
    public void writeConfig() {
        List<String> headerConfig = Arrays.asList("This is the ChunkLimitation file", "You can limit the max amount of Furnitures each chunk", "total.enable = (bool) | set default value for each project", "total.global = (bool) | override the project limit and force use total.amount for each project");
        YamlConfiguration configuration = super.loadYaml(headerConfig);
        super.writeGlobal(configuration, headString);
        FurnitureManager.getInstance().getProjects().forEach(project -> super.ioProjectLimit(headString, (Project)project, configuration));
        super.save(configuration, this.getFile());
    }

    @Override
    public void updateConfig(Project project) {
        if (this.amountMap.containsKey(project)) {
            return;
        }
        YamlConfiguration configuration = super.loadYaml();
        super.ioProjectLimit(headString, project, configuration);
        super.save(configuration, this.getFile());
    }

    @Override
    public Predicate<ObjectID> buildFilter(Location location, Project project, Player player) {
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        World world = location.getWorld();
        Predicate<ObjectID> prediacte = objectID -> objectID.getWorld().equals((Object)world);
        return prediacte.and(objectID -> objectID.isInChunk(chunkX, chunkZ));
    }
}

