/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Events;

import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.Events.FurnitureLateSpawnEvent;
import de.Ste3et_C0st.FurnitureLib.Utilitis.LanguageManager;
import de.Ste3et_C0st.FurnitureLib.Utilitis.StringTranslator;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public final class FurnitureItemEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private ItemStack is;
    private Project pro;
    private ObjectID obj;
    private Player p;
    private Location l;
    private BlockFace clickedFace;
    private long timestamp;
    private boolean cancelled;

    public FurnitureItemEvent(Player p, ItemStack is, Project pro, Location l, BlockFace face) {
        this.p = p;
        this.pro = pro;
        this.is = is;
        this.l = l;
        this.clickedFace = face;
        this.obj = this.getStartLocation();
        this.obj.setUUID(p.getUniqueId());
        this.timestamp = System.currentTimeMillis();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public BlockFace getFace() {
        return this.clickedFace;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public ItemStack getItemStack() {
        return this.is;
    }

    public Project getProject() {
        return this.pro;
    }

    public Player getPlayer() {
        return this.p;
    }

    public Location getLocation() {
        return this.l;
    }

    public ObjectID getObjID() {
        return this.obj;
    }

    public BlockFace getClickedFace() {
        return this.clickedFace;
    }

    private ObjectID getStartLocation() {
        switch (this.clickedFace) {
            case UP: {
                return new ObjectID(this.pro.getName(), this.pro.getPlugin().getName(), this.l.clone().add(0.0, 1.0, 0.0));
            }
            case DOWN: {
                return new ObjectID(this.pro.getName(), this.pro.getPlugin().getName(), this.l.clone().add(0.0, -1.0, 0.0));
            }
        }
        this.l = FurnitureLib.getInstance().getLocationUtil().getRelative(this.l.add(0.0, -1.0, 0.0), this.clickedFace, -1.0, 0.0);
        this.l.setYaw((float)(FurnitureLib.getInstance().getLocationUtil().FaceToYaw(this.clickedFace) + 180));
        ObjectID obj = new ObjectID(this.pro.getName(), this.pro.getPlugin().getName(), this.l);
        return obj;
    }

    public boolean canBuild() {
        if (this.p == null || this.obj == null || this.getProject() == null) {
            return true;
        }
        BlockFace face = this.isOnTheRightSide();
        if (face == null) {
            LanguageManager.send((CommandSender)this.p, "message.NotONThisSide", new StringTranslator[0]);
            return false;
        }
        this.debugTime("FurnitureLib {FurnitureItemEvent} -> Start canBuild check");
        if (!FurnitureLib.getInstance().getPermManager().canBuild(this.p, this.obj.getStartLocation())) {
            FurnitureLib.debug("FurnitureLib -> ProtectionLib can't build here (" + this.getProject().getName() + ")", 0);
            return false;
        }
        this.debugTime("FurnitureLib {FurnitureItemEvent} -> ProtectionLib(" + FurnitureLib.getInstance().getPermManager().useProtectionLib() + ") canBuild on Position = true ");
        if (this.getBlock() == null) {
            FurnitureLib.debug("FurnitureLib -> Didn't find block (" + this.getProject().getName() + ")", 0);
            return false;
        }
        if (!FurnitureLib.getInstance().getPermManager().isSolid(this.getBlock().getType(), this.getProject().getPlaceableSide(), this.getBlock())) {
            FurnitureLib.debug("FurnitureLib -> Didn't find solid block (" + this.getProject().getName() + ")" + this.getBlock().getType().name());
            return false;
        }
        this.debugTime("FurnitureLib {FurnitureItemEvent} -> placed on solid block = true ");
        if (this.p.isOp()) {
            return true;
        }
        if (!this.pro.hasPermissions(this.p)) {
            FurnitureLib.debug("FurnitureLib -> Player " + this.p.getName() + " didn't have permissions to place it");
            return false;
        }
        this.debugTime("FurnitureLib {FurnitureItemEvent} -> Player hasPermissions = true ");
        return true;
    }

    public boolean sendAnnouncer() {
        return FurnitureConfig.getFurnitureConfig().getLimitManager().canPlace(this.p, this.obj);
    }

    public boolean isTimeToPlace() {
        if (FurnitureConfig.getFurnitureConfig().isSpamPlace() && !FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)this.getPlayer(), "furniture.admin") && !FurnitureLib.getInstance().getPermission().hasPerm((CommandSender)this.getPlayer(), "furniture.bypass.placeSpam")) {
            long dif;
            long since;
            long newCurrent;
            long current = System.currentTimeMillis();
            if (FurnitureLib.getInstance().getTimePlace().containsKey(this.getPlayer().getUniqueId()) && (newCurrent = current - (since = FurnitureLib.getInstance().getTimePlace().get(this.getPlayer().getUniqueId()).longValue())) < (dif = FurnitureConfig.getFurnitureConfig().getPlaceTime())) {
                String str = FurnitureLib.getInstance().getTimeDif(since, dif, FurnitureConfig.getFurnitureConfig().getTimePattern());
                LanguageManager.send((CommandSender)this.p, "message.FurnitureToFastPlace", new StringTranslator("time", str));
                return false;
            }
            FurnitureLib.getInstance().getTimePlace().put(this.getPlayer().getUniqueId(), current);
        }
        return true;
    }

    private Block getBlock() {
        BlockFace face = this.isOnTheRightSide();
        switch (face) {
            case UP: {
                return this.l.getBlock();
            }
            case DOWN: {
                return this.l.getBlock();
            }
        }
        return this.l.getBlock().getRelative(face.getOppositeFace());
    }

    private BlockFace isOnTheRightSide() {
        switch (this.getProject().getPlaceableSide()) {
            case TOP: 
            case WATER: {
                if (!this.clickedFace.equals((Object)BlockFace.UP)) break;
                return BlockFace.DOWN;
            }
            case SIDE: {
                if (this.clickedFace.equals((Object)BlockFace.UP) && this.clickedFace.equals((Object)BlockFace.DOWN)) break;
                if (this.clickedFace.equals((Object)BlockFace.UP) || this.clickedFace.equals((Object)BlockFace.DOWN)) {
                    return null;
                }
                return this.clickedFace;
            }
            case BOTTOM: {
                if (!this.clickedFace.equals((Object)BlockFace.DOWN)) break;
                return BlockFace.UP;
            }
        }
        return null;
    }

    public void removeItem() {
        Boolean useGameMode = FurnitureConfig.getFurnitureConfig().useGamemode();
        if (useGameMode.booleanValue() && this.p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        int slot = this.p.getInventory().getHeldItemSlot();
        ItemStack itemStack = this.is.clone();
        itemStack.setAmount(itemStack.getAmount() - 1);
        this.p.getInventory().setItem(slot, itemStack);
        this.p.updateInventory();
    }

    public void finish() {
        this.obj.setFinish();
        FurnitureLateSpawnEvent lateSpawn = new FurnitureLateSpawnEvent(this.p, this.obj, this.pro, this.l);
        Bukkit.getPluginManager().callEvent((Event)lateSpawn);
    }

    public long getEventCallTime() {
        return Objects.nonNull(this.timestamp) ? this.timestamp : 0L;
    }

    public void debugTime(String str) {
        if (FurnitureLib.useDebugMode()) {
            long timeMS = System.currentTimeMillis() - this.getEventCallTime();
            FurnitureLib.debug(str + " [" + timeMS + "ms]");
        }
    }
}

