/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Database;

import de.Ste3et_C0st.FurnitureLib.Database.Database;
import de.Ste3et_C0st.FurnitureLib.Database.MySQL;
import de.Ste3et_C0st.FurnitureLib.Database.SQLStatement;
import de.Ste3et_C0st.FurnitureLib.Database.SQLite;
import de.Ste3et_C0st.FurnitureLib.Database.com.zaxxer.hikari.HikariConfig;
import de.Ste3et_C0st.FurnitureLib.Utilitis.ExecuteTimer;
import de.Ste3et_C0st.FurnitureLib.Utilitis.SchedularHelper;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Task;
import de.Ste3et_C0st.FurnitureLib.Utilitis.callbacks.CallbackBoolean;
import de.Ste3et_C0st.FurnitureLib.async.ChunkData;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class SQLManager {
    private FurnitureLib plugin;
    private Task sqlSaveInterval = null;
    private Database database;
    private static int versionInt = FurnitureLib.getVersionInt();

    public SQLManager(FurnitureLib plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    private void initialize() {
        ExecuteTimer timer = new ExecuteTimer();
        if (Objects.isNull(FurnitureLib.getInstance().getFurnitureConfig())) {
            return;
        }
        HikariConfig config = FurnitureConfig.getFurnitureConfig().loadDatabaseAsset();
        Type.DataBaseType dataBaseType = FurnitureConfig.getFurnitureConfig().getDatabaseType();
        if (dataBaseType == Type.DataBaseType.MySQL) {
            this.isExist();
            this.database = new MySQL(this.plugin, config);
        } else if (dataBaseType == Type.DataBaseType.SQLite) {
            this.database = new SQLite(this.plugin, config);
        } else {
            this.plugin.getLogger().warning("Database Type not supported: FurnitureLib will shutdown.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
        FurnitureLib.debug("FurnitureLib Started " + this.database.getType().name() + " database. Took " + timer.getMilliString(), 1);
    }

    public void loadALL() {
        if (Objects.nonNull(this.database)) {
            this.database.loadAll(Type.SQLAction.NOTHING);
        }
        FurnitureLib.getInstance().getFurnitureManager().sendAll();
    }

    private void isExist() {
        File fileDB = null;
        if (!FurnitureConfig.getFurnitureConfig().isImportCheck()) {
            return;
        }
        File folder = new File("plugins/" + this.plugin.getName());
        File[] array = folder.listFiles();
        if (array == null) {
            return;
        }
        for (File file : array) {
            if (file == null || !file.getName().substring(file.getName().length() - 3).equalsIgnoreCase(".db")) continue;
            this.plugin.getLogger().info("Old Database File found: " + file.getName());
            this.plugin.getLogger().info("Start importing");
            fileDB = file;
        }
        if (fileDB != null) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:plugins/FurnitureLib/" + fileDB.getName());
            SQLite database = new SQLite(FurnitureLib.getInstance(), config);
            database.loadAll(Type.SQLAction.SAVE);
            this.plugin.getLogger().info("Import finish");
            this.plugin.getLogger().info("Make old Database unusable.");
            fileDB.renameTo(new File("plugins/" + this.plugin.getName(), fileDB.getName() + ".old"));
            fileDB.delete();
        }
    }

    public void save() {
        if (FurnitureConfig.getFurnitureConfig().shouldAutoSaveConsoleMessage()) {
            this.plugin.getLogger().info("Furniture save started");
        }
        if (!this.plugin.getFurnitureManager().getObjectList().isEmpty()) {
            Collection<List<ObjectID>> collection;
            ArrayList<ObjectID> objList = new ArrayList<ObjectID>();
            int j = 0;
            int i = 0;
            ArrayList<ObjectID> idList = new ArrayList<ObjectID>(this.plugin.getFurnitureManager().getObjectList());
            ArrayList<ObjectID> saveList = new ArrayList<ObjectID>();
            ArrayList<ObjectID> removeList = new ArrayList<ObjectID>();
            int stepSize = 100;
            for (ObjectID obj : idList) {
                if (objList.contains(obj)) continue;
                Type.SQLAction sqlAction = obj.getSQLAction();
                if (Type.SQLAction.REMOVE == sqlAction) {
                    this.remove(obj);
                    removeList.add(obj);
                } else if (Type.SQLAction.UPDATE == sqlAction) {
                    if (versionInt > 11) {
                        saveList.add(obj);
                    } else {
                        this.save(obj);
                    }
                    ++j;
                } else {
                    if (Type.SQLAction.SAVE != sqlAction) continue;
                    if (versionInt > 11) {
                        saveList.add(obj);
                    } else {
                        this.save(obj);
                    }
                    ++i;
                }
                objList.add(obj);
            }
            if (!saveList.isEmpty() && Objects.nonNull(collection = SQLManager.splitListBySize(saveList, stepSize))) {
                collection.stream().filter(Objects::nonNull).forEach(list -> {
                    SQLStatement statement = new SQLStatement();
                    statement.add((List<ObjectID>)list);
                    this.save(statement.getStatement());
                });
            }
            this.plugin.getFurnitureManager().deleteObjectID(removeList);
            if (FurnitureConfig.getFurnitureConfig().shouldAutoSaveConsoleMessage() && (i != 0 || j != 0 || removeList.size() != 0)) {
                this.plugin.getLogger().info(i + " furniture has been saved to the database.");
                this.plugin.getLogger().info(j + " furniture has been updated in the database.");
                this.plugin.getLogger().info(removeList.size() + " furniture has been removed from the database.");
            }
        }
    }

    public void save(CallbackBoolean callBackBoolean) {
        if (FurnitureConfig.getFurnitureConfig().shouldAutoSaveConsoleMessage()) {
            this.plugin.getLogger().info("Furniture save started");
        }
        if (!this.plugin.getFurnitureManager().getObjectList().isEmpty()) {
            Collection<List<ObjectID>> collection;
            ArrayList<ObjectID> objList = new ArrayList<ObjectID>();
            int j = 0;
            int i = 0;
            int l = 0;
            ArrayList<ObjectID> idList = new ArrayList<ObjectID>(this.plugin.getFurnitureManager().getObjectList());
            ArrayList<ObjectID> saveList = new ArrayList<ObjectID>();
            int stepSize = 100;
            for (ObjectID obj : idList) {
                if (objList.contains(obj)) continue;
                Type.SQLAction sqlAction = obj.getSQLAction();
                if (Type.SQLAction.REMOVE == sqlAction) {
                    this.remove(obj);
                    ++l;
                    this.plugin.getFurnitureManager().deleteObjectID(obj);
                } else if (Type.SQLAction.UPDATE == sqlAction) {
                    if (versionInt > 11) {
                        saveList.add(obj);
                    } else {
                        this.save(obj);
                    }
                    ++j;
                } else {
                    if (Type.SQLAction.SAVE != sqlAction) continue;
                    if (versionInt > 11) {
                        saveList.add(obj);
                    } else {
                        this.save(obj);
                    }
                    ++i;
                }
                objList.add(obj);
            }
            if (!saveList.isEmpty() && Objects.nonNull(collection = SQLManager.splitListBySize(saveList, stepSize))) {
                collection.stream().filter(Objects::nonNull).forEach(list -> {
                    SQLStatement statement = new SQLStatement();
                    statement.add((List<ObjectID>)list);
                    this.save(statement.getStatement());
                });
            }
            if (FurnitureConfig.getFurnitureConfig().shouldAutoSaveConsoleMessage() && (i != 0 || j != 0 || l != 0)) {
                this.plugin.getLogger().info(i + " furniture has been saved to the database.");
                this.plugin.getLogger().info(j + " furniture has been updated in the database.");
                this.plugin.getLogger().info(l + " furniture has been removed from the database.");
            }
        }
        if (Objects.nonNull(callBackBoolean)) {
            callBackBoolean.onResult(true);
        }
    }

    public static Collection<List<ObjectID>> splitListBySize(List<ObjectID> intList, int size) {
        if (!intList.isEmpty() && size > 0) {
            AtomicInteger counter = new AtomicInteger(0);
            return intList.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / size)).values();
        }
        return null;
    }

    public void save(ObjectID obj) {
        if (Objects.nonNull(this.database)) {
            this.database.save(obj);
            return;
        }
        FurnitureLib.getInstance().getLogger().warning("No SQLite and MySQL instance found.");
    }

    public void save(String query) {
        if (Objects.nonNull(this.database)) {
            this.database.save(query);
            return;
        }
        FurnitureLib.getInstance().getLogger().warning("No SQLite and MySQL instance found.");
    }

    public void remove(ObjectID obj) {
        if (Objects.nonNull(this.database)) {
            this.database.delete(obj);
            return;
        }
        FurnitureLib.getInstance().getLogger().warning("No SQLite and MySQL instance found.");
    }

    public void saveInterval(int time) {
        if (Objects.nonNull(this.sqlSaveInterval)) {
            this.sqlSaveInterval.cancel();
        }
        if (time < 1) {
            return;
        }
        this.sqlSaveInterval = SchedularHelper.runTimer(() -> FurnitureLib.getInstance().getFurnitureManager().saveAsynchron((CommandSender)Bukkit.getConsoleSender()), 20 * time, 20 * time, false);
    }

    public void stop() {
        if (this.sqlSaveInterval != null) {
            this.sqlSaveInterval.cancel();
            this.sqlSaveInterval = null;
        }
    }

    public void convert(CommandSender sender, String table) {
        this.database.getConverter().startConvert(sender, table);
    }

    public <T> CompletableFuture<HashSet<ObjectID>> loadAsynchron(ChunkData data, World world) {
        return this.database.loadAsynchron(data, world);
    }

    public Database getDatabase() {
        return this.database;
    }
}

