/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.FurnitureLib.Database;

import de.Ste3et_C0st.FurnitureLib.Database.Converter;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.Utilitis.cache.DiceOfflinePlayer;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureConfig;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

public class DeSerializer {
    public int purged = 0;

    public static ObjectID Deserialize(String objId, String md5, Type.SQLAction action, World world) {
        byte[] binary = Base64.getDecoder().decode(md5);
        return DeSerializer.Deserialize(objId, binary, action, world);
    }

    public static ObjectID Deserialize(String objId, byte[] binary, Type.SQLAction action, World world) {
        ObjectID objectID;
        ByteArrayInputStream bin = new ByteArrayInputStream(binary);
        try {
            NBTTagCompound compound = NBTCompressedStreamTools.read(bin);
            objectID = Objects.isNull(compound) ? null : DeSerializer.Deserialize(objId, compound, action, world);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("Furniture Model [" + objId + "] is broken");
                return null;
            }
        }
        bin.close();
        return objectID;
    }

    public static ObjectID Deserialize(String objId, NBTTagCompound compound, Type.SQLAction action, World world) {
        if (Objects.isNull(compound)) {
            return null;
        }
        ObjectID obj = new ObjectID(objId);
        Location startLocation = DeSerializer.locationFetcher(compound.getCompound("Location"), world);
        if (Objects.isNull(startLocation)) {
            obj.setSQLAction(Type.SQLAction.REMOVE);
            FurnitureLib.getInstance().getFurnitureManager().addObjectID(obj);
            return null;
        }
        obj.setStartLocation(startLocation);
        if (compound.hasKeyOfType("EventType", 8)) {
            Type.EventType evType = Type.EventType.valueOf(compound.getString("EventType"));
            obj.setEventTypeAccess(evType);
        }
        if (compound.hasKeyOfType("PublicMode", 8)) {
            Type.PublicMode pMode = Type.PublicMode.valueOf(compound.getString("PublicMode"));
            obj.setPublicMode(pMode);
        }
        if (compound.hasKeyOfType("Members", 9)) {
            HashSet<UUID> members = DeSerializer.membersFetcher(compound.getList("Members"));
            obj.setMemberList(members);
        }
        if (compound.hasKeyOfType("Owner-UUID", 8)) {
            UUID uuid = DeSerializer.uuidFetcher(compound.getString("Owner-UUID"));
            obj.setUUID(uuid);
        }
        obj.setFinish();
        obj.setSQLAction(action != null && action.equals((Object)Type.SQLAction.SAVE) ? Type.SQLAction.SAVE : Type.SQLAction.NOTHING);
        obj.setFromDatabase(true);
        if (compound.hasKey("entities") || compound.hasKey("entitys")) {
            NBTTagCompound entitys = compound.hasKey("entitys") ? compound.getCompound("entitys") : compound.getCompound("entities");
            entitys.c().stream().forEach(packet -> {
                NBTTagCompound metadata = entitys.getCompound((String)packet);
                Location loc = DeSerializer.locationFetcher(metadata.getCompound("Location"), world);
                FurnitureManager.getInstance().createFromType(metadata.getString("EntityType"), loc, obj).loadMetadata(metadata);
            });
        } else if (!FurnitureLib.isNewVersion() && compound.hasKey("ArmorStands")) {
            armorStands = compound.getCompound("ArmorStands");
            armorStands.c().stream().forEach(packet -> {
                NBTTagCompound metadata = armorStands.getCompound((String)packet);
                Location loc = DeSerializer.locationFetcher(metadata.getCompound("Location"), world);
                FurnitureManager.getInstance().createFromType("armor_stand", loc, obj).loadMetadata(metadata);
            });
        } else {
            armorStands = Converter.convertPacketItemStack(compound.getCompound("ArmorStands"));
            armorStands.c().stream().forEach(packet -> {
                NBTTagCompound metadata = armorStands.getCompound((String)packet);
                Location loc = DeSerializer.locationFetcher(metadata.getCompound("Location"), world);
                FurnitureManager.getInstance().createFromType("armor_stand", loc, obj).loadMetadata(metadata);
            });
            obj.setSQLAction(Type.SQLAction.UPDATE);
        }
        return obj;
    }

    public static void autoPurge(int purgeTime) {
        FurnitureManager.getInstance().getObjectList().stream().filter(entry -> Objects.nonNull(entry.getUUID())).forEach(entry -> {
            long lastSeen;
            Optional<DiceOfflinePlayer> player = FurnitureLib.getInstance().getPlayerCache().getPlayer(entry.getUUID());
            if (player.isPresent() && (lastSeen = player.get().getLastSeen()) > 0L && FurnitureLib.getInstance().isAfterDate(lastSeen, purgeTime)) {
                if (FurnitureConfig.getFurnitureConfig().isPurgeRemove()) {
                    FurnitureManager.getInstance().remove((ObjectID)entry);
                } else {
                    entry.setSQLAction(Type.SQLAction.REMOVE);
                }
            }
        });
    }

    public static Location locationFetcher(NBTTagCompound location, World world) {
        double X = location.getDouble("X");
        double Y = location.getDouble("Y");
        double Z = location.getDouble("Z");
        float Yaw = location.getFloat("Yaw");
        float Pitch = location.getFloat("Pitch");
        return new Location(world, X, Y, Z, Yaw, Pitch);
    }

    public static UUID uuidFetcher(String s) {
        if (s.equalsIgnoreCase("NULL")) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static HashSet<UUID> membersFetcher(NBTTagList nbtList) {
        HashSet<UUID> uuidList = new HashSet<UUID>();
        if (nbtList == null || nbtList.size() == 0) {
            return uuidList;
        }
        for (int i = 0; i < nbtList.size(); ++i) {
            String string = nbtList.getString(i).replaceAll("\"", "");
            try {
                uuidList.add(UUID.fromString(string));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uuidList;
    }
}

